#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "stones.inc"
#include "woods.inc"
#include "skies.inc"
#include "functions.inc"
#include "transforms.inc"
#include "golds.inc"
#include "rand.inc"
#include "glass.inc"

light_source { <3,10,-10> color White }

global_settings {
  assumed_gamma 1
  max_trace_level 10
}


camera { orthographic
up 4*y
right 4*image_width/image_height*x
location <0,0,-5> look_at 0
}

background { color White }

//plane {y,-4 pigment { color Yellow } }
box { <-10,-5,10>,<10,22,11> pigment { color White } finish { ambient 0 diffuse 0.6 }} 


/**********************************

Nun das gewnschte Objekt importieren.

**********************************/  

#declare Positionen = array [866] [650];
#declare Hoehen = array [866] [650];

#declare EPig = pigment { image_map { jpeg "Gold" } }
/*
#declare Objekt = union {
   #for(ix,1,866)
      #for(iy,1,650)
         #declare AktPig=eval_pigment(EPig,<ix/866+1/(2*866),iy/650+1/(2*650),0>);
         #declare AktColor=Yellow;
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,1,1>)<0.1 ) #declare AktColor=Clear; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,0>)<0.1 ) #declare AktColor=Red; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,0,1>)<0.1 ) #declare AktColor=Blue; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,1>)<0.1 ) #declare AktColor=Cyan; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,0>)<0.1 ) #declare AktColor=Green; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,1>)<0.1 ) #declare AktColor=White; #end
         
         sphere { <ix,iy,0>,0.5 pigment { color AktColor } }
      #end
   #end
}
*/
/*			 
#declare EPig = pigment { image_map { png "Erhoehungen" } }

#declare Objekt = union {
   #for(ix,1,866)
      #for(iy,1,650)
         #declare AktPig=eval_pigment(EPig,<ix/866+1/(2*866),iy/650+1/(2*650),0>);
         #declare AktColor=Yellow;
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,1,1>)<0.1 ) #declare AktColor=Clear; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,0>)<0.1 ) #declare AktColor=Red; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,0,1>)<0.1 ) #declare AktColor=Blue; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,1>)<0.1 ) #declare AktColor=Cyan; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,0>)<0.1 ) #declare AktColor=Green; #end
         #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,1>)<0.1 ) #declare AktColor=White; #end
         
         sphere { <ix,iy,0>,0.5 pigment { color AktColor } }
      #end
   #end
}
*/
#declare Rubin = 1; // Rot
#declare Smaragd = 2;  // Grn
#declare Opal = 3;  // Blau
#declare Amethyst = 4; // Cyan
#declare Porzellan = 5; // Magenta
#declare Gold=6; // sonst

#for(ix,1,866)
   #for(iy,1,650)
      #declare AktPig=eval_pigment(EPig,<ix/866+1/(2*866),iy/650+1/(2*650),0>);
      #declare AktColor=Yellow;
      #declare Positionen[ix-1][iy-1]=Gold;
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,1,1>)<0.1 ) #declare Positionen [ix-1][iy-1]=0; #end
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,0>)<0.1 ) #declare Positionen [ix-1][iy-1]=Rubin; #end
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,0,1>)<0.1 ) #declare Positionen [ix-1][iy-1]=Opal; #end
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,1>)<0.1 ) #declare Positionen [ix-1][iy-1]=Amethyst; #end
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<0,1,0>)<0.1 ) #declare Positionen [ix-1][iy-1]=Smaragd; #end
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,1>)<0.1 ) #declare Positionen [ix-1][iy-1]=Porzellan; #end
         
   #end
#end

#declare EPig = pigment { image_map { png "Erhoehungen" } }

#for(ix,1,866)
   #for(iy,1,650)
      #declare AktPig=eval_pigment(EPig,<ix/866+1/(2*866),iy/650+1/(2*650),0>);
      #declare AktColor=Yellow;
      #declare Hoehen[ix-1][iy-1]=0;
      #if ( vlength(<AktPig.x,AktPig.y,AktPig.z>-<1,0,1>)<0.1 ) #declare Hoehen[ix-1][iy-1]=1; #end
         
   #end
#end

#for(ix,5,860)
   #for(iy,5,645)
      #if (Hoehen[ix][iy] = 0)
         #if ( Hoehen[ix-1][iy-1]=1 |
               Hoehen[ix-1][iy]=1 |
               Hoehen[ix-1][iy+1]=1 |
               Hoehen[ix][iy-1]=1 |
               Hoehen[ix][iy+1]=1 |
               Hoehen[ix+1][iy]=1 |
               Hoehen[ix+1][iy-1]=1 |
               Hoehen[ix+1][iy]=1 |
               Hoehen[ix+1][iy+1]=1 )
               #declare Hoehen[ix][iy]=3/4;
         #elseif(
               Hoehen[ix+2][iy+2]=1 |
               Hoehen[ix+2][iy+1]=1 |
               Hoehen[ix+2][iy]=1 |
               Hoehen[ix+2][iy-1]=1 |
               Hoehen[ix+2][iy-2]=1 |
               Hoehen[ix+1][iy+2]=1 |
               Hoehen[ix+1][iy-2]=1 |
               Hoehen[ix][iy+2]=1 |
               Hoehen[ix][iy-2]=1 |
               Hoehen[ix-1][iy+2]=1 |
               Hoehen[ix-1][iy-2]=1 |
               Hoehen[ix-2][iy+2]=1 |
               Hoehen[ix-2][iy+1]=1 |
               Hoehen[ix-2][iy]=1 |
               Hoehen[ix-2][iy-1]=1 |
               Hoehen[ix-2][iy-2]=1 
         )
               #declare Hoehen[ix][iy]=2/4;
         #elseif (
               Hoehen[ix-3][iy-3]=1 |
               Hoehen[ix-3][iy-2]=1 |
               Hoehen[ix-3][iy-1]=1 |
               Hoehen[ix-3][iy]=1 |
               Hoehen[ix-3][iy+1]=1 |
               Hoehen[ix-3][iy+2]=1 |
               Hoehen[ix-3][iy+3]=1 |
               Hoehen[ix+3][iy-3]=1 |
               Hoehen[ix+3][iy-2]=1 |
               Hoehen[ix+3][iy-1]=1 |
               Hoehen[ix+3][iy]=1 |
               Hoehen[ix+3][iy+1]=1 |
               Hoehen[ix+3][iy+2]=1 |
               Hoehen[ix+3][iy+3]=1 |
               Hoehen[ix-2][iy+3]=1 |
               Hoehen[ix+2][iy+3]=1 |
               Hoehen[ix-2][iy-3]=1 |
               Hoehen[ix+1][iy-3]=1 |
               Hoehen[ix-1][iy+3]=1 |
               Hoehen[ix+1][iy+3]=1 |
               Hoehen[ix-1][iy-3]=1 |
               Hoehen[ix+1][iy-3]=1 |
               Hoehen[ix][iy+3]=1 |
               Hoehen[ix][iy+3]=1 |
               Hoehen[ix][iy-3]=1 |
               Hoehen[ix][iy-3]=1 
         )
               #declare Hoehen[ix][iy]=1/4;
         #end
      #end
   #end
#end

#declare MaxHoehe=5;

#fopen ha "HorusAuge.inc" write

#write(ha,"#declare HA_GoldMat=material {texture { T_Gold_1A  } }\n")
#write(ha,"#declare HA_RubinMat=material {texture { Ruby_Glass } interior { I_Glass }}\n")
#write(ha,"#declare HA_PorzellanMat=material{ texture { pigment { color rgbf <1, 1, 1, 0.2> } finish { F_Glass4 } } }\n")
#write(ha,"#declare HA_SmaragdMat=material{ texture { NBwinebottle } interior{ I_Glass } }\n")
#write(ha,"#declare HA_OpalMat = material { texture { pigment { color rgbf <0.1, 0.1, 0.99, 0.8> } finish { F_Glass4 } } }\n")
#write(ha,"#declare HA_AmethystMat = material { texture { pigment { color rgbf <0.53, 0.12, 0.47, 0.8> } finish { F_Glass4 } } }\n")

#write (ha,"#declare Gold = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Gold)
            #write(ha,"cylinder {",<ix,iy,-20-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,0>,",",1,",",1.2,"}\n")
         #end
      #end
   #end
#write(ha,"material { HA_GoldMat } }\n")


#write (ha,"#declare GoldBack = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]>0)
            #write(ha,"cylinder {",<ix,iy,-10>,",",<ix,iy,0>,",",1,",",1.2,"}\n")
         #end
      #end
   #end
   #write(ha,"material { HA_GoldMat } }\n")

#write(ha,"#declare Rubin = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Rubin)
            #write(ha,"cylinder { ",<ix,iy,-17-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,-10>,",",1,",",1.2," }\n")
         #end
      #end
   #end
   #write(ha,"material{ HA_RubinMat }}\n")

#write(ha,"#declare Smaragd = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Smaragd)
            #write(ha,"cylinder {",<ix,iy,-17-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,-10>,",",1,",",1.2," }\n")
         #end
      #end
   #end
   #write(ha,"material { HA_SmaragdMat } }\n")


#write(ha,"#declare Opal = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Opal)
            #write(ha,"cylinder {",<ix,iy,-17-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,-10>,",",1,",",1.2," }\n")
         #end
      #end
   #end
   #write(ha,"material { HA_OpalMat }}\n")

#write(ha,"#declare Amethyst = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Amethyst)
            #write(ha,"cylinder {",<ix,iy,-17-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,-10>,",",1,",",1.2," }\n")
         #end
      #end
   #end
   #write(ha,"material { HA_AmethystMat }}\n")

#write(ha,"#declare Porzellan = blob { threshold 0.8\n")
   #for(ix,0,865)
      #for(iy,0,649)
         #if (Positionen[ix][iy]=Porzellan)
            #write(ha,"cylinder {",<ix,iy,-17-Hoehen[ix][iy]*MaxHoehe>,",",<ix,iy,-10>,",",1,",",1.2," }\n")
         #end
      #end
   #end
#write(ha,"material { HA_PorzellanMat }}\n")

#write(ha,"#declare HorusAuge = union {\n")
#write(ha,"   object { Gold }\n")
#write(ha,"   object { GoldBack }\n")
#write(ha,"   object { Rubin }\n")
#write(ha,"   object { Smaragd }\n")
#write(ha,"   object { Opal }\n")
#write(ha,"   object { Amethyst }\n")
#write(ha,"   object { Porzellan }\n")
#write(ha,"}\n")

#fclose ha

#include "HorusAuge.inc"

#declare Objekt = object { HorusAuge }

#declare Fadenkreuz = union {
   cylinder { <-0.25,0,0>,<0.25,0,0>,0.01 pigment { color Blue } }
   cylinder { <0,-0.25,0>,<0,0.25,0>,0.01 pigment { color Red } }
   cylinder { <0,0,-0.25>,<0,0,0.25>,0.01 pigment { color Green } }
}


#declare MinExt= min_extent(Objekt);
#declare MaxExt= max_extent(Objekt);

#declare P1=<-0.04,0.4,-0.083>;
#declare P2=<-0.025,0.48,-0.125>;
#declare PA=P2-3/4*(P1-P2);
#declare PE=P2+8*(P1-P2);


#declare Objekt2 = union {
   object { Objekt }
   object { Fadenkreuz }
    
    translate -MinExt-(MaxExt-MinExt)/2
    scale 1/max(MaxExt.x-MinExt.x,MaxExt.y-MinExt.y,MaxExt.z-MinExt.z)
    scale 2
}



object { Objekt2 translate <-2,1.25,0> }
object { Objekt2 rotate y*90 translate <0,1.25,0> }
object { Objekt2 rotate y*180 translate <-2,-0.25,0> }
object { Objekt2 rotate y*270 translate <0,-0.25,0> }
object { Objekt2 rotate x*90  translate <2,1.25,0> }
object { Objekt2 rotate -x*90  translate <2,-0.25,0> }

//object { Objekt2 rotate -x*90 }// translate <-2,1.5,0> }

text{ttf "Arial.ttf" concat("Min_Extent=<",
                               str(MinExt.x,0,8),",",
                               str(MinExt.y,0,8),",",
                               str(MinExt.z,0,8),">"),0.1,0 scale 0.2 translate <-3,-1.5,0> }
                               
text{ttf "Arial.ttf" concat("Max_Extent=<",
                               str(MaxExt.x,0,8),",",
                               str(MaxExt.y,0,8),",",
                               str(MaxExt.z,0,8),">"),0.1,0 scale 0.2 translate <-3,-1.75,0> }


