#include "logo.inc"
#declare LogoTexture =
texture{
  pigment{
    bozo
    scale 0.02
    turbulence 0.1 lambda 3
    color_map{[0 rgb <0.9411,0.5176,0.0627>*.25][1 rgb <0.9411,0.5176,0.0627>]}
    }
	finish {
		specular 1
		roughness 1e-3
		diffuse 0.65
		emission rgb <0.9411,0.5176,0.0627>
		}
  }

#declare Logo =
object {
	Povray_Logo_Bevel
	/*material{
		texture {LogoTexture}
		}*/
  }

#declare Stand =
union {
	union {
		cylinder {<0,0,0>, <0,0.25,0>, 2 }
		torus {2,0.125 translate y*0.125}
		}
	union {
		cylinder {<0,0,0>, <0,0.25,0>, 1.75 }
		torus {1.75,0.125 translate y*0.125}
		translate y*0.125
		}
	union {
		cylinder {<0,0,0>, <0,0.25,0>, 1.5 }
		torus {1.5,0.125 translate y*0.125}
		translate y*0.25
		}
	union {
		cylinder {<0,0,0>, <0,0.25,0>, 0.5 }
		torus {0.5,0.125 translate y*0.125}
		translate y*0.375
		}
	union {
		cylinder {<0,0,0>, <0,4.375,0>, 0.2 }
		torus {0.2,0.0625 }
		torus {0.2,0.045 translate y*4.375}
		translate y*0.625
		}
	}

#declare fn_A = function { sqrt(pow(y,2) + pow(z,2)) - 0.25 }
#declare fn_B = function { sqrt(pow(y,2) + pow(x,2)) - 0.25 }

#declare Blob_Threshold=1e-3;

#declare TJoiner =
//union {
	isosurface {
		function {
			(1+Blob_Threshold)
			-pow(Blob_Threshold, fn_A(x,y,z))
			-pow(Blob_Threshold, fn_B(x,y,z))
			}
		max_gradient 17.616
		contained_by { box { <-0.75,-0.2,-1>, <-0.25,0.2,1> } }
		rotate z*90
		translate y*0.75
		}
	//torus {0.19, 0.05}
	//}

#include "metals.inc"

#declare SignHolderTBEdge =
// edge rounding
#local Rd = 0.025;
// moulding thickness
#local Mthk = .1;
	object {
		Round_Box_Union (<0.14+Mthk,0,2>, <-0.14-Mthk,0.14,-2>, Rd)
		}

#declare SignHolderLREdge =
// edge rounding
#local Rd = 0.025;
// moulding thickness
#local Mthk = .1;
	object {
		Round_Box_Union (<0.14+Mthk,0,1.5>, <-0.14-Mthk,0.14,-1.5>, Rd)
		}

/*
#declare Signage =
union {
	object {Stand}
	union {
		object {TJoiner}
		object {SignHolderTBEdge rotate y*0 translate y*0.5 }
		object {SignHolderTBEdge rotate y*0 translate y*3.45 }
		object {SignHolderLREdge rotate x*90 translate <0,2,-2> }
		object {SignHolderLREdge rotate x*90 translate <0,2,(2-0.14)> }

		box {<0,0,-0.001>,<1,1,0.001>
			material {
				texture {
					pigment {
						image_map {
							png "Persistence.png"
							map_type 0
							once
							}
						}
					finish { diffuse 1 emission 0.3 phong 1 phong_size 300 reflection 0.13 }
					translate -y*0.055
					}
				interior {
					ior 1.5
					media {
						emission rgb <0.9411,0.5176,0.0627>
						}
					}
				}
			translate -x*0.5
			rotate y*270
			scale <1,2.95,3.99>
			translate y*0.64
			hollow on
			}
		translate y*5
		}
	texture {T_Chrome_1D}
	}*/
