#version 3.7;

// povray ndi.pov +w1600 +h900 +a0.1 +am2 

// -- Variables and setup
// 0=no rad, 1=load, 2=save
#declare WorkMode = no;
#declare Debug = no;
#declare UseGrid = no;

#declare UseLight = yes;
#declare AreaLight = yes;
#declare UseRad = 2;

#declare DoScene = yes;
#declare DoObjects = yes;
#declare DoShrubs = yes;

// the inside floor and courtyard levels
#declare FL = 1.0251;
#declare CL = 1.025;

#default { finish { ambient 0 emission 0 diffuse 0.4 } }

global_settings {
	max_trace_level 80
	adc_bailout 0.00001
	noise_generator 3
	assumed_gamma 1.0

	#if (UseRad)
		radiosity {
			#if (UseRad=2)
				pretrace_start 1/16
				pretrace_end 1/128
				#if (Debug)
					count 128
				#else
					count 384
				#end
				error_bound 0.256
				low_error_factor 0.4
				nearest_count 20,12
				gray_threshold 0
				normal on
			#else
				pretrace_start 1
				pretrace_end 1
				gray_threshold 0
				always_sample off
				normal on
		  #end
			}
	#end
	}

// -- Some Includes
#include "colors.inc"

#if (UseGrid)
	#include "grid.inc"
	object { grid scale 1 translate <0,6,0> }
#end

#if (WorkMode)
	#declare CamPos = <-21,10,-35>;
	#declare LookAt = <-21,3,0>;
	#declare ZF = 2*z;
#else
	#declare CamPos = <-7,CL+1.86,-40>;    //<-10,1.4,-23>;
	#declare LookAt = <-7,CL+1.86,63>;      //<22.1,6,33.15>;
	#declare ZF = 1*z;
#end

// -- Camera & Lighting
camera {
	perspective
	location CamPos
	look_at  LookAt
	#if (WorkMode)
		rotate x*0
		rotate y*0
		//angle 33.5
	#else
		//rotate y*23/2
		//angle 50//33.5
	#end
	right  x*16/9
	direction ZF
	look_at  LookAt
	}

// -- The Sun Light
#declare SpotLight = no;
#declare ParaLight = no;
#declare FadePower = 2;

#declare Intensity = function (LD,FD,FP) {pow(1+(LD/FD),FP)/2};

#declare LightPos = <0,0,-3000>;
#declare LightDist = vlength(LightPos-<0,0,0>);
#declare FadeDist = 10;

#if (Debug)
	#debug concat ("\nSun:\nFade Distance: ", str(FadeDist,2,4))
	#debug concat ("\nLight Distance: ", str(LightDist,5,4)," \n")
	#debug concat ("Light Intensity: ", str(Intensity (LightDist, FadeDist, FadePower),6,4), "\n\n")
#end

#if (UseLight)
#declare Sun_Light =
light_source {
	#if (Debug)
		#declare LightColor = rgb 3;
	#else
		#declare LightColor = rgb 3;
	#end
 	0, LightColor *  Intensity (LightDist, FadeDist, FadePower)

	#if (Debug)
		looks_like {sphere {0,1 pigment {rgb <1,0.25,0.05>}} finish {emission <1,0.25,0.05> diffuse 0}}
	#end
	#if (ParaLight)
		parallel
	#end
	#if (SpotLight)
		spotlight
	#end
	#if (AreaLight)
		area_light x*60, z*60 10,10 adaptive 3 jitter orient circular
 	#end
	fade_distance FadeDist
 	fade_power FadePower
 	media_interaction on
 	media_attenuation on
 	translate LightPos
 	#if (ParaLight)
		point_at <0,0,-5>
	#end
	#if (SpotLight)	
		point_at <-15,6,7>
		radius 60
		falloff 70
		tightness 0
	#end
	}

#end

#declare SkyDome =
sphere { 0, 1 hollow 
	pigment {
		gradient y
		poly_wave 0.25
		color_map {
			[0.05 rgb <0.7,0.7,1>]
			[1 rgb <0.35,0.35,1>]
			}
		}
	finish { diffuse 0 emission 1 }
	no_shadow
	}

object { SkyDome scale 5000 }

#if (UseLight)
	object { Sun_Light rotate x*15 rotate y*230}
#end

#if (DoScene)
	// empty
#else
	plane {	y, 0 pigment { rgb 1 } radiosity{ importance 0.1 } }
#end

#include "taglogo.inc"
#include "buildings.inc"
#include "PrunedShrub.inc"

// Scene Objects

// adapted from distribution copy of benchmark.pov
#declare RMF = function{ f_ridged_mf(x, y, z, 0.07, 2.2,  7, 0.6, 0.9, 1)}

#declare M_Watx4 =
material {
   texture {
      pigment { color rgbt <0.21, 0.20, 0.3, 0.96> }
      finish {
         diffuse 0.0
         ambient 0.0
				emission 0.8 

         reflection {
            0.1, 0.95
            fresnel on
            exponent 0.8
         }

         conserve_energy

         specular 0.1
         roughness 0.007
         metallic
      }
      normal{
         function { RMF(x, y, z) } 0.2
         scale 2
      }
   }
   interior {
      ior 1.31
      fade_distance 0.8
      fade_power 1001.0
      fade_color <0.21, 0.20, 0.3>
   }
}

#declare Water =
cylinder  {<0,1e-6,0>, <0,-1,0>, 5000
	material { M_Watx4 }
	hollow on
	}

#declare Esphere =
sphere {0,1
	texture {
		pigment {rgb <0.7,0.7,1>} 
		finish {
			diffuse 0
			emission rgb <0.7,0.7,1>
			}
		}
	no_image
	no_shadow
	no_reflection
	}

#if (DoScene)
	union {
		// the structure
		object { Room translate y*1 }
		object { Water }

		//<-7,3.525,-40>
		object { Esphere
			translate -z*40
			rotate y*12.5
			translate <-CamPos.x,CamPos.y,0>
			}

		#if (DoObjects)	
			#if (DoShrubs)
				#if (Debug)
					#local TestShrub = cylinder {<0,0,0>, <0,1,0>, 0.25 pigment {Green} radiosity {importance 0.2}}
				#end

				// inside the center line arches
				#local ArchShrubs =
					array [16][2] {
						{ 9876,-46 },
						{ 2716,-32 },
						{ 4480,-18 },
						{ 1984,-4 },
						{ 1616,10 },
						{ 1954,24 },
						{ 1999,38 },
						{ 2525,52 },
						{ 9876,-38 },
						{ 2716,-24 },
						{ 4480,-10 },
						{ 1984,4 },
						{ 1616,18 },
						{ 1954,32 },
						{ 1999,46 },
						{ 2525,60 }
					};

				#local idx = 0;
				#while (idx < 16)
					#if (Debug)
						 object { TestShrub translate <0,FL,ArchShrubs[idx][1]> }
					#else
						object { Potted_PrunedShrub(seed(ArchShrubs[idx][0])) scale 0.35 translate <0,FL,ArchShrubs[idx][1]> }
					#end
					#local idx = idx + 1;
				#end

				#local idx = 0;
				#while (idx < 16)
					#if (Debug)
						 object { TestShrub translate <-42,FL,ArchShrubs[idx][1]> }
					#else
						object { Potted_PrunedShrub(seed(ArchShrubs[idx][0])) scale 0.35 translate <-42,FL,ArchShrubs[idx][1]> }
					#end
					#local idx = idx + 1;
				#end

			#end // DoShrubs

			//object { Benches }
			//object { Logo translate <0,1,-0.125> scale 2.35 translate <-7,FL,42> }
			//object { Signage rotate y*0 scale 0.195 translate <-9.125,CL,-37>}

			#end // DoObjects
		rotate y*0
		}
	#end // DoScene
