#include "shapes.inc"
#include "OTOc.inc"

#declare BuildingTexture =
texture{
  pigment{
    planar
    scale 4
    turbulence 1 lambda 3
    color_map{[0 rgb <1, 0.65, 0.25>][1 rgb <1, 0.7, 0.35>]}
    }
  normal{
    granite -.1 poly_wave .5
    accuracy .001
    }
  }

#declare DarkWallTexture =
texture{
  pigment{
    planar
    scale 4
    turbulence 1 lambda 3
    color_map{[0 rgb <1, 0.65, 0.25>*0.1][1 rgb <1, 0.7, 0.35>*0.1]}
    }
  normal{
    granite -.1 poly_wave .5
    accuracy .001
    }
  }

#declare CeilingTexture = BuildingTexture;

#declare FloorTexture =
  texture{
    pigment{
      granite scale 10 poly_wave .35
      color_map{[0 rgb <1,0.75,0.5>*.5][1 rgb <1,0.75,0.5>]}
      }
    }

#include "TiledCeiling.inc"
#declare Tiled_Ceiling_FlipTiles = 1;

#declare CeilingPanels =
union {
	object{
		Tiled_Ceiling(
			"JTile1.png"
			<-41,-49>,
			<-1,-22>,
			<41,27>,
			0.2
			)
		}
	object{
		Tiled_Ceiling(
			"JTile1.png"
			<-41,-20>,
			<-1,6>,
			<41,26>,
			0.2
			)
		}
	object{
		Tiled_Ceiling(
			"JTile1.png"
			<-41,8>,
			<-1,34>,
			<41,26>,
			0.2
			)
		}
	object{
		Tiled_Ceiling(
			"JTile1.png"
			<-41,36>,
			<-1,63>,
			<41,27>,
			0.2
			)
		}
	texture { FloorTexture }
	translate y*5.89
	radiosity {importance 0.25}
	}


#declare SeaWallSegment =
union {
	difference {
		box {<0,0,0.1>, <-0.25,1,0.9>}
		cylinder {<0.01,0,0>, <-0.26,0,0> 0.25 translate <0,0.5,0.1>}
		cylinder {<0.01,0,0>, <-0.26,0,0> 0.25 translate <0,0.5,0.9>}

		torus {0.25, 0.05 rotate z*90 translate <0,0.5,0.1>}
		torus {0.25, 0.05 rotate z*90 translate <0,0.5,0.9>}
		torus {0.25, 0.05 rotate z*90 translate <-0.25,0.5,0.1>}
		torus {0.25, 0.05 rotate z*90 translate <-0.25,0.5,0.9>}

		cylinder {<0.-0.01,0,0>, <0,1.01,0> 0.05 translate <0,0,0.1>}
		cylinder {<0.-0.01,0,0>, <0,1.01,0> 0.05 translate <0,0,0.9>}
		cylinder {<0.-0.01,0,0>, <0,1.01,0> 0.05 translate <-0.25,0,0.1>}
		cylinder {<0.-0.01,0,0>, <0,1.01,0> 0.05 translate <-0.25,0,0.9>}
		}

	difference {
		box {<0,0,0>, <-0.3,0.125,1>}
		cylinder {<0,0,-0.01>, <0,0,1.01>, 0.05 translate -x*0.3}
		translate <-0.125,0.975,0>
		}

	difference {
		box {<0,0,0>, <-0.3,0.125,1>}
		cylinder {<0,0,-0.01>, <0,0,1.01>, 0.05 translate -x*0.3}
		rotate y*180
		translate <-0.125,0.975,1>
		}

	cylinder {<0,0,0>, <0,0,1>, 0.0375 translate <-0.425,1.0625,0>}
	cylinder {<0,0,0>, <0,0,1>, 0.0375 translate <-0.425,1.0625,0> rotate y*180 translate <-0.25,0,1>}
	}

/* not used
#declare ArchSegment =
difference {
	// the archway
	union {
		// edge rounding
		#local Rd = 0.1;
		
		// rounded arch
		difference {
			box {<1,0,7>, <-1,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5+Rd}
			}
		difference {
			box {<1-Rd,0,7>, <-1+Rd,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5}
			}

		difference {
			torus {5+Rd, Rd rotate z*90}
			box {<0.15,0,6>, <-0.15,-6,-6>}
			translate -x*(1-Rd)
			}

		difference {
			torus {5+Rd, Rd rotate z*90}
			box {<0.15,0,6>, <-0.15,-6,-6>}
			translate x*(1-Rd)
			}
		
		// edge rounding
		#local Rd = 0.05;
		
		// the arch support
		object {Round_Box_Union (<1.5,0,1.5>, <-1.5,12,-1.5>, Rd) translate z*7}
		
		// moulding thickness
		#local Mthk = .1;
		
		// top moulding
		object {Round_Box_Union (<1+Mthk,5.5,7>, <-1-Mthk,6,-7>, Rd)}
		
		// arch moulding
    object {Round_Box_Union (<1+Mthk,0,2+Mthk>, <-1-Mthk,.35,-2-Mthk>, Rd) translate z*7}
    
    // arch support moulding
    object {Round_Box_Union (<1.5+Mthk,0,1+Mthk>, <-1.5-Mthk,.35,-1.5-Mthk>, Rd) translate z*7}
    //object {Round_Box_Union (<1.5+Mthk,5.5,1.5+Mthk>, <-1.5-Mthk,6,-1.5-Mthk>, Rd) translate z*7}
    
		// arch support cap		
		#local idx = 0;
		difference {
			box {<1.75,0,1.75>, <-1.75,2,-1.75> }
			#while (idx < 360)
				cylinder {<2,0,0>, <-2,0,0>, 0.25 translate -z*1.75 rotate y*idx }
				#local idx = idx + 90;
			#end
			translate <0,12,7>
			}
		}

	// z axis walkway
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		translate y*5.9
		}

	// x axis walkway opening
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		rotate y*90
		translate <0,5.8999999,7>
		}
	translate z*7
	}*/

#declare InnerArchway =
union {
	// edge rounding
	#local Rd = 0.1;
		
	// rounded arch
	difference {
		box {<1,0,7>, <-1,6,-7> }
		cylinder {<-1.1,0.0>, <1.1,0,0>, 5+Rd}
		}
	difference {
		box {<1-Rd,0,7>, <-1+Rd,6,-7> }
		cylinder {<-1.1,0.0>, <1.1,0,0>, 5}
		}

	difference {
		torus {5+Rd, Rd rotate z*90}
		box {<0.15,0,6>, <-0.15,-6,-6>}
		translate -x*(1-Rd)
		}

	difference {
		torus {5+Rd, Rd rotate z*90}
		box {<0.15,0,6>, <-0.15,-6,-6>}
		translate x*(1-Rd)
		}
		
	// edge rounding
	#local Rd = 0.05;
		
	// moulding thickness
	#local Mthk = .1;
		
	// top moulding
	object {Round_Box_Union (<1+Mthk,5.5,7>, <-1-Mthk,6,-7>, Rd)}
		
	// arch moulding
  object {Round_Box_Union (<1+Mthk,0,0+Mthk>, <-1-Mthk,.35,-2-Mthk>, Rd) translate z*7 }
  object {Round_Box_Union (<1+Mthk,0,0+Mthk>, <-1-Mthk,.35,-2-Mthk>, Rd) translate z*-5 }
	}

#declare MouldingRepair =
// edge rounding
#local Rd = 0.05;
// moulding thickness
#local Mthk = .1;
	// a small strip to bridge a gap
	object {
		Round_Box_Union (<1+Mthk,5.5,0.7>, <-1-Mthk,6,-0.7>, Rd)
		}

#declare RoomArches =
union {
	object {InnerArchway rotate y*90 translate <-7,0,0>}
	object {MouldingRepair rotate y*90 translate -x*14 }
	object { Logo translate y*1 scale 2 translate <-14,0.75,-1> }
	object {InnerArchway rotate y*90 translate <-21,0,0>}
	object {MouldingRepair rotate y*90 translate -x*28 }
	object { Logo translate y*1 scale 2 translate <-28,0.75,-1> }
	object {InnerArchway rotate y*90 translate <-35,0,0>}
	radiosity {importance 0.25}
	}

#declare Room =
union {
	// the ends of the room
	box { <0,0,63>, <-42,6,63> }
	box { <0,0,-49>, <-42,6,-49> }
	
	// the floor
	#declare OTOScale = 0.25; /* since the macro is rudimentary, here's an ad-hoc solution to change the tile size */
	object {
		OTO( <-42/OTOScale,-49/OTOScale,-.025/OTOScale>, <0/OTOScale,63/OTOScale,1/OTOScale>, 0.075/OTOScale, texture {FloorTexture} )
		scale OTOScale rotate x*90
		}

	// the outer ceiling
	box {<0,0,63>, <-42,0,-49> translate y*5.9	texture {CeilingTexture} }
	object { CeilingPanels }
	
	// the border
	union {
		box{<-3,-1,-49>,<3,0.0251,63>}
		box{<-3,-1,-49>,<3,0.0251,63> translate -x*42}
		box{<-45,-1,-3>,<3,0.0251,3> translate z*63}
		box{<-45,-1,-3>,<3,0.0251,3> translate -z*49}
		}

	#local ndx = -49;
	#while (ndx < 63)
		object {SeaWallSegment translate <3.25,0,ndx>}
		#local ndx = ndx + 1;
	#end
	#local ndx = -49;
	#while (ndx < 63)
		object {SeaWallSegment translate <-45,0,ndx>}
		#local ndx = ndx + 1;
	#end

	#local ndx = -42;
	#while (ndx < 70)	
		object {InnerArchway translate <0,0,ndx>}
		#local ndx = ndx + 14;
	#end

	#local ndx = -42;
	#while (ndx < 70)	
		object {InnerArchway translate <-42,0,ndx>}
		#local ndx = ndx + 14;
	#end

	object { RoomArches translate -z*21 }
	object { RoomArches translate z*7 }
	object { RoomArches translate z*35 }

	texture {BuildingTexture scale 0.5}
	}
