/*
 * Wall - version with isosurfaces
 *
 * Credits: Philippe for bricks texture (fast_wall=1)
 */

// Parameters ------------------------------------------------------------------
#declare fast_wall=0;
// -----------------------------------------------------------------------------

// General setting -------------------------------------------------------------
#include "colors.inc"
#include "math.inc"

global_settings {
	assumed_gamma 1.0
}
#default{
	finish{ambient 0.1 diffuse 0.9}
}

camera{
	location <1,3.5,-2.2>
	look_at <0,1,0>
}
// -----------------------------------------------------------------------------

// Lights and sky --------------------------------------------------------------
light_source{<-1000,1000,-500> color rgb <1,1,1>} // to be multiplied for 147 milions km

//background {rgb <0.2,0.4,0.9>}
sky_sphere {
    pigment{
        gradient <0,1,0>
        color_map {
            [0.00 rgb <1.0,1.0,1.0>]
            [0.30 rgb <0.0,0.1,1.0>]
            [0.70 rgb <0.2,0.4,0.9>]
            [1.00 rgb <1.0,1.0,1.0>] 
        } 
        scale 2         
    }
}
// -----------------------------------------------------------------------------

// Textures --------------------------------------------------------------------
#declare t_brick_space=texture{
	pigment{color rgb <0.898039, 0.85098, 0.733333>}
	finish{diffuse .65}
	normal{granite .6 scale .4}
}

#declare t_brick=texture{
	pigment{color rgb <0.815686, 0.803922, 0.776471>*1.1}
	finish{
		diffuse .7
		specular .08 roughness .15
	}
	normal{
		average
		normal_map{
			[1.00
			boxed 1
			poly_wave .3
			/*
			slope_map{
				[0.00 <0,0>]
				[0.05 <0,0>]
				[0.05 <0,.5>]
				[1.00 <1,0>]
			} 
			*/
			slope_map{
				[0.00 <0,0>]
				[0.02 <0,0>]
				[0.02 <0,.5>]
				[1.00 <1,0>]
			}
			]
			[1.00 agate .15 ]
		}
	}
}

#declare t_wall=texture{
	boxed
	poly_wave .3
	texture_map{
		[0.00 t_brick_space]
		[0.05 t_brick_space]
		[0.05 t_brick]
		[1.00 t_brick]
	}
	warp{planar}
	rotate -90*x
	scale .5
	translate <.5,0,.5>
	warp{repeat 1.1*x}
	warp{repeat z offset .5*x}
	#local w_s=.3;
	scale w_s
	warp{
		turbulence <.3,1.5,.3>*.2
	}
	scale 1/w_s
	scale 0.3
	rotate 90*x
}


#declare t_stone=texture{
	pigment{
        granite
        color_map {
           //[0.0 rgb<0.67, 0.50, 0.32>]
           //[1.0 rgb<0.94, 0.88, 0.79>]
           [0.0 rgb<1,0.75,0.55>]
           [1.0 rgb<1, 0.88, 0.79>]
        }
        turbulence 0.75
        ramp_wave
        //scale 0.1 // Too big for high resolutions
        //scale  0.01
	}
	normal {
        granite
        turbulence 0.75
        ramp_wave
	}
    scale  0.1
}

#declare t_sand=texture {
	pigment{
		color rgb<1,0.89,0.82>
	}
	normal {bumps 0.5 scale 0.05}
	finish { diffuse 0.85 phong 0.3}
}


// Objects ---------------------------------------------------------------------
#declare from_wall=<-6,-2,0>;
#declare to_wall=<6,2.5,0.2>;

// A simple wall generator -------------------------------------
#macro do_wall()
	//Cement    
    box{from_wall*0.95 to_wall*0.95 texture{t_sand}}
    
    #declare curr_max_space=0;
    // Support macro 
    #macro update_curr_max_space_in_wall(arr,row,curr_col,max_col)
	    #declare curr_max_space=0;
	    #local i=curr_col;
	    #while(i<max_col)
	    	// If the wall is not empty, exit
	    	#if(arr[i][row]=1)
	    		#local i=max_col+1;
	    	// Else, updates the curr_max_space
	    	#else
	    		#declare curr_max_space=curr_max_space+1;
	    		#local i=i+1;
	    	#end
	    #end    	
    #end
    
    // Stone parameters
    #declare stone_base_size=0.1; //0.2;	// Metric
    #declare max_stone_grid_x=3;	// Maximum stone x size to be multiplied for stone_base_size
    #declare max_stone_grid_y=3;	// Maximum stone y size to be multiplied for stone_base_size
    #declare wall_grid_cols=int((to_wall.x-from_wall.x)/stone_base_size);
    #declare wall_grid_rows=int((to_wall.y-from_wall.y)/stone_base_size);
    #declare R1 = seed(5);			// Random seed
    #declare R2 = seed(3);			// Random seed
    
    
    #declare a_wall=array[wall_grid_cols+max_stone_grid_x][wall_grid_rows+max_stone_grid_y]; //Support array
	#local ax=0;
	#while(ax<wall_grid_cols+max_stone_grid_x)
		#local ay=0;
		#while(ay<wall_grid_rows+max_stone_grid_y)
			#declare a_wall[ax][ay]=0;
    		#local ay=ay+1;
		#end
		#local ax=ax+1;
	#end
    #declare curr_max_space=wall_grid_cols;
    
    // Begin the cycle
    #local curr_row=0;
    #while(curr_row<wall_grid_rows)
    	// Places random sized stones and updates array
    	#local curr_col=0;
	    #while(curr_col<wall_grid_cols)
	    	//1. Determinate max stone lenght for current position basing on array values
	    	update_curr_max_space_in_wall(a_wall,curr_row,curr_col,wall_grid_cols)
	    	//2.A. If in current position isn't space available, increment counter
	    	#if(curr_max_space=0)
	    		#local curr_col=curr_col+1;
	    	//2.B. Else place stone
	    	#else
	    		//3. Generate random stone
	    		#local xmax=min(max_stone_grid_x,curr_max_space);
	    		#local ymax=min(max_stone_grid_y,wall_grid_rows-curr_row);
	    		#local stone_x=ceil(rand(R1)*xmax);
	    		#local stone_y=ceil(rand(R1)*ymax);
	    		//4. Update array
	    		#local ax=curr_col;
	    		#while(ax<curr_col+stone_x)
		    		#local ay=curr_row;
		    		#while(ay<curr_row+stone_y)
		    			#declare a_wall[ax][ay]=1;
			    		#local ay=ay+1;
		    		#end
		    		#local ax=ax+1;
	    		#end
	    		//5. Place stone
	    		//box{0 stone_base_size scale<stone_x, stone_y> translate<from_wall.x+curr_col*stone_base_size,from_wall.y+curr_row*stone_base_size,0> texture{pigment {color rgbt <rand(R1),rand(R1),rand(R1),0> }}}
	    		//round_boxes: nice, but not similar to my wall
	    		//object{Round_Box(<0,0,0>,<stone_base_size,stone_base_size,stone_base_size>, stone_base_size/5, 0) scale<stone_x, stone_y> translate<from_wall.x+curr_col*stone_base_size,from_wall.y+curr_row*stone_base_size,0> texture{t_stone}}
	    		//isosurface: better
	    		//ToDo: a better base isosurface
	    		#local aga_x=0.2+rand(R2)*0.1;
	    		#local aga_y=0.2+rand(R2)*0.1;
	    		#local aga_z=0.2+rand(R2)*0.1;
	    		#local aga_mul=0.015*(0.8+rand(R2)*0.4);
				isosurface {
					function{
						f_rounded_box(x,y,z,
											stone_base_size/5, // radius of curvature
											stone_base_size*.585, stone_base_size*.585, stone_base_size*.585 // scale<x,y,z>
											)
						-(f_agate(x/aga_x,y/aga_y,z/aga_z)*aga_mul)
					}
					threshold 0
					contained_by {box {<0,0,0>-stone_base_size,<stone_base_size,stone_base_size,stone_base_size>}}
					//max_gradient 3.168
					max_gradient 2.2
					accuracy 0.0001
					//evaluate 1,20,0.99
					scale<stone_x, stone_y,1> translate<from_wall.x+(curr_col+0.5)*stone_base_size,from_wall.y+(curr_row-0.05)*stone_base_size,0.5*stone_base_size> texture{t_stone}
				}
	    		
    			//6. Update counter
	    		#local curr_col=curr_col+stone_x;
	    	#end
		#end
		#local curr_row=curr_row+1;
    #end
#end
// --------------------------------
// -----------------------------------------------------------------------------


// Scene -----------------------------------------------------------------------
// Wall ------------------------------------------------------
#if(fast_wall=1)
	box{from_wall to_wall texture{t_wall}}
#else
	do_wall()
#end
// -----------------------------------------------------------
      
// -----------------------------------------------------------------------------

