/*
 ____________________________
  OTO.inc 'Odd Tiles Object'
 
     2011 Samuel Benge
 
 
 This macro will make a tiling of interlocking, irregularly-shaped bricks in the x/y plane.
 
 
 The Macro
 
  OTO(Min_Extent, Max_Extent, Bev, Texture)
   *Min_Extent = a 3D vector
   *Max_Extent = a 3D vector
   *Bev        = amount of edge rounding
   *Texture    = a texture that will be scaled/translated randomly for each brick  
  
   Min_Extent.x must be less than Max_Extent.x, likewise for the y components. The z
   components control the depth, or thickness.
  
   Example:
  
    OTO( <-5,-5,0>, <5,5,1>, 0.1, texture{pigment{granite scale 10}} )
  
  
  Declarable
  
   OTO_Seed
    
    A random seed to change the overall apperance. #declare it before calling OTO().
    
    Example:
     
      #declare OTO_Seed = seed(1005);
  
*/

#macro OTO(Min_Extent, Max_Extent, Bev, Texture)
 
 #ifndef(OTO_Seed)
  #local OTO_Seed = seed(1005);
 #end
 
 #local Bev = max(0,min(1,Bev/2));
 
 #local OTO_FMask = function{ pattern{ pigment_pattern{ checker 0, 1 warp{planar} } } }
 #ifndef(OTO_FOffs) // additional support for custom offsets, use with care
  #local OTO_FOffs = function{ pattern{ pigment_pattern{ cells translate z*int(rand(OTO_Seed)*1000) warp{planar} } } }
 #end
 
 #macro OTO_Get_Offset(Cell)
  #local CX = Cell.x;
  #local CY = Cell.y;
  (1-Bev*2)*<1,1,0>*(.5-OTO_FOffs(CX,CY,0))
 #end

 #macro OTO_Get_Mask(Cell)
  #local CX = Cell.x;
  #local CY = Cell.y;
  OTO_FMask(CX,CY,0)
 #end
  
 union{
  #local Y=Min_Extent.y;
  #while(Y<=Max_Extent.y)
   #local X=Min_Extent.x;
   #while(X<=Max_Extent.x)
    #local Vec = <X-.5,Y-.5,0>;
   
    // corner finding
    #if(OTO_Get_Mask(Vec)=1 )
     #local Pt1 = Vec + y*(OTO_Get_Offset(Vec).y) + x*(OTO_Get_Offset(Vec+y).x);
     #local Pt2 = Vec + y*(OTO_Get_Offset(Vec+x+y).y) + x*(OTO_Get_Offset(Vec-y+x+y).x) +x+y;
    #else
     #local Pt1 = Vec + x*(OTO_Get_Offset(Vec).x) + y*(OTO_Get_Offset(Vec+x).y); 
     #local Pt2 = Vec + x*(OTO_Get_Offset(Vec+x+y).x) + y*(OTO_Get_Offset(Vec-x+x+y).y) +x+y;
    #end
    
    // the object
    object{
     Round_Box_Union(Pt1+z*Min_Extent.z,Pt2+z*Max_Extent.z,Bev)
     texture{
      Texture
      scale .5+rand(OTO_Seed)
      translate 100*<rand(OTO_Seed),rand(OTO_Seed),rand(OTO_Seed)>
     }
    }
   
    #local X=X+1;
   #end
   #local Y=Y+1;
  #end
 }

#end