#version 3.7;

// povray ndi.pov +w1000 +h562 +a0.1 +am1 +r3
// 1 pov unit = 10ft

// -- Variables and setup
// 0=no rad, 1=load, 2=save
#declare WorkMode = no;
#declare Debug = no;
#declare UseLight = yes;
#declare UseRad = 2;
#declare UseGrid = no;

#default { finish { ambient 0 emission 0 diffuse 0.35 } }

global_settings {
	max_trace_level 80
	charset utf8
	adc_bailout 0.00001
	noise_generator 3
	assumed_gamma 1.0
	photons {count 5000}
	#if (UseRad)
		radiosity {
			#if (UseRad=2)
				count 32
				nearest_count 1
				error_bound .1
				gray_threshold 0
				recursion_limit 2
				pretrace_end 2/256
				normal on
			#else
				pretrace_start 1
				pretrace_end 1
				gray_threshold 1
				always_sample off
				normal on
		  #end
			}
	#end
	}

// -- Some Includes
#include "colors.inc"

#if (UseGrid)
	#include "grid.inc"
	object { grid scale 4 }
#end

#if (WorkMode)
	#declare CamPos = <50,24,-200>;
	#declare LookAt = <50,2,0>;
	#declare ZF = 6*z;
#else
	//#declare CamPos = <0,0.6,-30>;
	//#declare LookAt = <5,3,0>;
	//#declare ZF = 1*z;
	#declare CamPos = <-10,1.4,-3>;
	#declare LookAt = <22.1,4,33.15>;
	#declare ZF = 1*z;
#end

// -- Camera & Lighting
camera {
	perspective
	location CamPos
	look_at  LookAt
	#if (WorkMode)
		rotate x*0
		rotate y*5
	#else
		//rotate x*0
		//rotate y*29.35
		//angle 25.5
		angle 45
	#end
	right  x*16/9
	direction ZF
	}

// -- The Sun Light
#declare AreaLight = no;
#declare SpotLight = no;
#declare ParaLight = no;
#declare FadePower = 2;

#declare Intensity = function (LD,FD,FP) {pow(1+(LD/FD),FP)/2};

#declare LightPos = <0,0,-3000>;
#declare LightDist = vlength(LightPos-<0,0,-1500>);
#declare FadeDist = 3;

#if (Debug)
	#debug concat ("\nSun:\nFade Distance: ", str(FadeDist,2,4))
	#debug concat ("\nLight Distance: ", str(LightDist,5,4)," \n")
	#debug concat ("Light Intensity: ", str(Intensity (LightDist, FadeDist, FadePower),6,4), "\n\n")
#end

#if (UseLight)
#declare Sun_Light =
light_source {
	#if (Debug)
		#declare LightColor = White * 3;
	#else
		#declare LightColor = rgb 3;
	#end
 	0, LightColor *  Intensity (LightDist, FadeDist, FadePower)

	#if (Debug)
		looks_like {sphere {0,1 pigment {rgb <1,0.25,0.05>}} finish {emission <1,0.25,0.05> diffuse 0}}
	#end
	#if (ParaLight)
		parallel
	#end
	#if (SpotLight)
		spotlight
	#end
	#if (AreaLight)
		area_light x*1.5, y*1.5 10,10 adaptive 1 jitter orient circular
		area_illumination on
 	#end
	fade_distance FadeDist
 	fade_power FadePower
 	media_interaction on
 	media_attenuation on
 	translate LightPos
 	#if (ParaLight)
		point_at <0,0,-5>
	#end
	#if (SpotLight)	
		point_at <-15,6,7>
		radius 60
		falloff 70
		tightness 0
	#end
	};
#end

#declare SkyDome =
sphere{0, 1 hollow
	texture {
  	pigment { rgb <0.4,0.4,1> }
		finish {
			ambient 0
			diffuse 0
			emission 1
			}
		}
	};

object { SkyDome scale 5000 }
object { Sun_Light rotate x*30 rotate y*310 }
plane { y,-0.01 pigment {rgb 1 } }

#include "ndi_buildings.inc"
#include "logo.inc"
#include "ndi_centerpiece.inc"

// Scene Objects

// the structure
union {
	object { FirstLevel }
	object { SecondLevel translate <0,7,50> }
	object { ThirdLevel translate <0,12,50> }
	rotate y*0
	}

//object { CenterPiece rotate y*90 translate <22.1,0.3,30> }
