#include "shapes.inc"
#declare BuildingPigment =
pigment{
 planar
 scale 4
 turbulence .5 lambda 3
 color_map{[0 rgb <1, 0.65, 0.25>][1 rgb <1, 0.5, 0.25>]}
 }
 
#declare CeilingPigment  = pigment {rgb <1,0.5,0.25>}
#declare FloorPigment    = pigment {rgb <1,0.5,0.25>}

#declare GroundLevel =
union {
	// the 1st wall
	difference {
		box {<46.5,0,46.5>, <-46.5,5,-46.5>}
		box {<44.2,-0.1,44.2>, <-44.2,5.1,-44.2>}
		pigment {BuildingPigment}
		}

	// level up
	difference {
		box {<50,0,50>, <-50,7,-50>}
		box {<46.05,-0.1,46.05>, <-46.05,7.1,-46.05>}
		pigment {BuildingPigment}
		}

	// level up
	difference {
		box {<46.5,0,46.5>, <-46.5,6,-46.5>}
		box {<45.125,-0.1,45.125>, <-45.125,6.1,-45.125>}
		pigment {BuildingPigment}
		}

	// the floor
	box {<46.5,0,46.5>, <-46.5,0,-46.5> pigment {FloorPigment}}

	// the ceiling
	box {<0,0,46.5>, <-46.5,0,-46.5> translate y*5.5 pigment {CeilingPigment}}
	};

#declare ArchSegment =
difference {
	// the archway
	union {
		// edge rounding
		#local Rd = 0.1;
		
		// rounded arch
		difference {
			box {<1,0,7>, <-1,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5+Rd }
			}
		difference {
			box {<1-Rd,0,7>, <-1+Rd,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5 }
			}
		torus {5+Rd, Rd rotate z*90 translate -x*(1-Rd)}
		
		// the arch support
		object {Round_Box_Union (<1.5,0,1.5>, <-1.5,12,-1.5>, Rd) translate z*7}
		
		// top moulding
		object {Round_Box_Union (<1+Rd,5.25,7>, <-1-Rd,6,-7>, Rd) }
		
		// arch moulding
    object {Round_Box_Union (<1+Rd,0,2+Rd>, <-1-Rd,.25,-2-Rd>, Rd) translate z*7}
    
    // arch support moulding
    object {Round_Box_Union (<1.5+Rd,0,1+Rd>, <-1.5-Rd,.25,-1.5-Rd>, Rd) translate z*7}
    object {Round_Box_Union (<1.5+Rd,5.25,1.5+Rd>, <-1.5-Rd,5.5,-1.5-Rd>, Rd) translate z*7}
    
		// arch support cap		
		#local idx = 0;
		difference {
			box {<1.75,0,1.75>, <-1.75,2,-1.75> }
			#while (idx < 360)
				cylinder {<2,0,0>, <-2,0,0>, 0.25 translate -z*1.75 rotate y*idx }
				#local idx = idx + 90;
			#end
			translate <0,12,7>
			}
		}

	// z axis walkway
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		translate y*5.9
		}

	// x axis walkway opening
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		rotate y*90
		translate <0,5.8999999,7>
		}
	translate z*7
	pigment {BuildingPigment}
	};

#declare SmlArches =
#local idx = 0;
union {
	#while (idx < 50)
		object { ArchSegment scale 0.35715 rotate y*90 translate <idx,0,0> }
		#local idx = idx + 5;
	#end
	};

#declare FirstLevel =
union {
	object { GroundLevel }

	/*object { ArchSegment }
	object { ArchSegment translate z*15.5 }
	object { ArchSegment translate z*31 }

	object { ArchSegment rotate y*180 }
	object { ArchSegment rotate y*180 translate -z*15.5 }
	object { ArchSegment rotate y*180 translate -z*31 }

	#local idx = 1.5;
	union {
		#while (idx < 37)
			object { ArchSegment scale 0.5 rotate y*90 translate <idx,7,47> }
			#local idx = idx + 7;
		#end
		}

	#local idx = 1.5;
	union {
		#while (idx < 37)
			object { ArchSegment scale 0.5 rotate y*90 translate <idx,7,47> }
			#local idx = idx + 7;
		#end
		translate -z*47
		rotate y*180
		translate z*47
		rotate y*90
		translate <0,0,0>
		}*/

	object { ArchSegment }
	object { ArchSegment translate z*15.5 }
	object { ArchSegment translate z*31 }
	object { ArchSegment translate -z*15.5 }
	object { ArchSegment translate -z*31 }
	object { ArchSegment translate -z*46.5 }
	object { ArchSegment translate -z*62 }

	object { SmlArches translate <0,7,50> }
	object { SmlArches translate <0,7,50> rotate y*90 translate z*50 }
	};
