#version 3.7;

// povray ndi.pov +w1000 +h562
// 1 pov unit = 10ft

// -- Variables and setup
// 0=no rad, 1=load, 2=save
#declare WorkMode = no;
#declare Debug = no;
#declare UseLight = yes;
#declare UseRad = 2;

#default { finish { ambient 0 emission 0 diffuse 0.5 } }

global_settings {
	max_trace_level 80
	charset utf8
	adc_bailout 0.00001
	noise_generator 3
	assumed_gamma 1.0
	#if (UseRad)
		radiosity {
			#if (UseRad=2)
				count 256
				nearest_count 10
				error_bound .1
				gray_threshold 0
				recursion_limit 2
				pretrace_end 1/256
			#else
				pretrace_start 1
				pretrace_end 1
				gray_threshold 1
				always_sample off
		  #end
			}
	#end
	}

// -- Some Includes
#include "colors.inc"

#if (WorkMode)
	#declare CamPos = <0,48,-150>;
	#declare LookAt = <0,14,50>;
	#declare ZF = 1*z;
#else
	#declare CamPos = <-10,2.4,-3>;
	#declare LookAt = <22.1,2.4,33.15>;
	#declare ZF = 1*z;
#end

// -- Camera & Lighting
camera {
	perspective
	location CamPos
	look_at  LookAt
	#if (WorkMode)
		rotate x*0
		rotate y*0
	#else
		rotate x*0
		rotate y*0
	#end
	right  x*16/9
	direction ZF
	angle 45
	}

// -- The Sun Light
#declare AreaLight = no;
#declare SpotLight = no;
#declare ParaLight = no;
#declare FadePower = 2;

#declare Intensity = function (LD,FD,FP) {pow(1+(LD/FD),FP)/2};

#declare LightPos = <0,0,-3000>;
#declare LightDist = vlength(LightPos-<0,0,-1500>);
#declare FadeDist = 3;

#if (Debug)
	#debug concat ("\nSun:\nFade Distance: ", str(FadeDist,2,4))
	#debug concat ("\nLight Distance: ", str(LightDist,5,4)," \n")
	#debug concat ("Light Intensity: ", str(Intensity (LightDist, FadeDist, FadePower),6,4), "\n\n")
#end

#if (UseLight)
#declare Sun_Light =
light_source {
	#if (Debug)
		#declare LightColor = White * 3;
	#else
		#declare LightColor = rgb 3;
	#end
 	0, LightColor *  Intensity (LightDist, FadeDist, FadePower)

	#if (Debug)
		looks_like {sphere {0,1 pigment {rgb <1,0.25,0.05>}} finish {emission <1,0.25,0.05> diffuse 0}}
	#end
	#if (ParaLight)
		parallel
	#end
	#if (SpotLight)
		spotlight
	#end
	#if (AreaLight)
		area_light x*1.5, y*1.5 10,10 adaptive 1 jitter orient circular
		area_illumination on
 	#end
	fade_distance FadeDist
 	fade_power FadePower
 	media_interaction on
 	media_attenuation on
 	translate LightPos
 	#if (ParaLight)
		point_at <0,0,-5>
	#end
	#if (SpotLight)	
		point_at <-15,6,7>
		radius 60
		falloff 70
		tightness 0
	#end
	};
#end

#declare SkyDome =
sphere{0, 1 hollow
	texture {
  	pigment { rgb <0.6,0.6,1> }
		finish {
			ambient 0
			diffuse 0
			emission 1
			}
		}
	};

object { SkyDome scale 5000 }
object { Sun_Light rotate x*60 rotate y*340 }
plane { y,-0.01 pigment {rgb 1 } }

#include "ndi_buildings.inc"

#declare CenterPiece = cylinder { <0,0,0>, <0,1,0>, 1 pigment { rgb <0.8,0.8,1> } };

// Scene Objects

object { FirstLevel rotate y*0 }
object { CenterPiece translate <22.1,0,22.1> }
