#declare GroundLevel =
union {
	// the 1st wall
	difference {
		box {<46.5,0,46.5>, <-46.5,5,-46.5>}
		box {<44.2,-0.1,44.2>, <-44.2,5.1,-44.2>}
		pigment {rgb <1,0.65,0.25>}
		}

	// level up
	difference {
		box {<50,0,50>, <-50,7,-50>}
		box {<46.05,-0.1,46.05>, <-46.05,7.1,-46.05>}
		pigment {rgb <1,0.65,0.25>}
		}

	// level up
	difference {
		box {<46.5,0,46.5>, <-46.5,6,-46.5>}
		box {<45.125,-0.1,45.125>, <-45.125,6.1,-45.125>}
		pigment {rgb <1,0.65,0.25>}
		}

	// the floor
	box {<46.5,0,46.5>, <-46.5,0,-46.5> pigment {rgb <1,0.5,0.25>}}

	// the ceiling
	box {<0,0,46.5>, <-46.5,0,-46.5> translate y*5.5 pigment {rgb <1,0.5,0.25>}}
	};

#declare ArchSegment =
difference {
	// the archway
	union {
		difference {
			box {<1,0,7>, <-1,6,-7> }
			cylinder {<-1.1,0.0>, <1.1,0,0>, 5 }
			}

		// the arch support
		box {<1.5,0,1.5>, <-1.5,12,-1.5> translate z*7}

		// arch support cap		
		#local idx = 0;
		difference {
			box {<1.75,0,1.75>, <-1.75,2,-1.75> }
			#while (idx < 360)
				cylinder {<2,0,0>, <-2,0,0>, 0.25 translate -z*1.75 rotate y*idx }
				#local idx = idx + 90;
			#end
			translate <0,12,7>
			}
		}

	// z axis walkway
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		translate y*5.9
		}

	// x axis walkway opening
	union {
		box {<0.9,0,8.6>, <-0.9,3.1,-8.6> }
		cylinder {<0,0,8.6>, <0,0,-8.6>, 0.9 translate y*3.1}
		rotate y*90
		translate <0,5.8999999,7>
		}
	translate z*7
	pigment {rgb <1,0.65,0.25>}
	};

#declare FirstLevel =
union {
	object { GroundLevel }

	object { ArchSegment }
	object { ArchSegment translate z*15.5 }
	object { ArchSegment translate z*31 }

	object { ArchSegment rotate y*180 }
	object { ArchSegment rotate y*180 translate -z*15.5 }
	object { ArchSegment rotate y*180 translate -z*31 }

	#local idx = 1.5;
	union {
		#while (idx < 37)
			object { ArchSegment scale 0.5 rotate y*90 translate <idx,7,47> }
			#local idx = idx + 7;
		#end
		}

	#local idx = 1.5;
	union {
		#while (idx < 37)
			object { ArchSegment scale 0.5 rotate y*90 translate <idx,7,47> }
			#local idx = idx + 7;
		#end
		translate -z*47
		rotate y*180
		translate z*47
		rotate y*90
		translate <0,0,0>
		}
	};
