#version 3.6;

#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"
#include "colors.inc"

/* Photon & Media Quality Settings
  0: setup or debug no photons
  1: low
  2: better photons and media
  3: best */

#declare Quality = 2;

#if (Quality > 0)
  #declare Use_Photons = yes;
  #declare Photon_Run = yes; // change to "no" to reuse a map
  #declare Photon_File = "laser_test.ph";
#end

#switch (Quality)
  #case (0)
    #declare Use_Photons = no;
  #break
  #case (1)
    #declare S_val = 0.1;
    #declare M_val = 75;
    #declare T_val = 5;
  #break
  #case (2)
    #declare S_val = 0.025;
    #declare M_val = 500;
    #declare T_val = 10;
  #break
  #case (3)
    #declare S_val = 0.01;
    #declare M_val = 1000;
    #declare T_val = 15;
  #break
#end

global_settings {
  max_trace_level 10
  assumed_gamma 1
  #if(Use_Photons)
    photons {
      spacing S_val
      media M_val
      max_trace_level T_val
      #if (Photon_Run)
        save_file Photon_File
      #else
        load_file Photon_File
      #end
      }
  #end
  }

background {rgb 0.5}

#declare CamPos = <0, 150, -100>;

camera {
  location CamPos
  up y
  right x * image_width/image_height
  look_at <0,0,-1.5>
  angle 22
  }

// a little light for debugging
#if (Quality < 1)
light_source {
  <0,0,0>,
  rgb 1
  translate CamPos
  }
#end
  
#declare laser =
light_source {
  <0,0,0>,
  rgb 1
  cylinder
  point_at <-1,0,0>
  radius 0.05
  falloff 0.1
  tightness 0
  #if (Use_Photons)
    photons {reflection on refraction on}
  #end
  };

#declare flat_reflector =
difference {
  cylinder {<0,0,0>, <-0.6,0,0>, 4}
  cylinder {<-0.5,0,0>, <-0.61,0,0>, 4.5 pigment {rgb <0,1,1>} finish {ambient 0.25}} // make the back non reflective
  #if (Quality > 0)
    pigment { rgb .2 }
    finish {
      ambient .1
      diffuse .6
      reflection { 1 }
      }
    photons {target reflection on refraction on}
  #end
  };
  
#declare the_target =
cylinder {<-0.5,0,0>, <0.5,0,0>,3
  pigment {
    onion
    color_map {
      [0.0 rgb 1]
      [0.5 rgb 1]
      [0.5 rgb <1,0,0>]
      [1.0 rgb <1,0,0>]
      }
    } finish {ambient 0.25}
  rotate z*175
  };

#declare Scatter_M =
material {
  texture {
    pigment { rgbt 1 }
    finish {
      ambient 0
      diffuse 0
      }
    }
  interior {
    media {
      method 3
      intervals 1
      #if (Quality > 2)
        samples 70, 1000
      #else
        samples 10, 25
      #end
      scattering {
        1, rgb 10
        extinction 0
        }
      absorption <1,0,1>
      }
    }
  };
  
#declare m_glass = 
material {
  texture {
    pigment {rgbf <1.0, 1.0, 1.0,0.9>}
    finish {F_Glass3}
    }
  interior {ior 1.5}
  };
    
#declare concave_glass1 = 
difference {
  cylinder {<-.5,0,0>,<.5,0,0> 2}
  sphere {<1.85,0,0>, 1.75}
  sphere { <-1.85,0,0>, 1.75}
  hollow on
  #if (Quality > 0)
    material {m_glass} photons {target reflection on refraction on}
  #else
    pigment {Orange}
  #end
  };

#declare maglass = 
intersection {
  sphere {<3.2,0,0>, 4}
  sphere {<-3.2,0,0>, 4}
  hollow on
  #if (Quality > 0)
    material {m_glass} photons {target reflection on refraction on}
  #else
    pigment {SkyBlue}
  #end
  };

#declare container =
sphere { 0, 60
  hollow on
  material {Scatter_M}
  photons {
    pass_through
    }
  };

#declare table  =
object {
  Round_Box_Union(<-40, -5, -40>, <40, 0, 40>, 0.5)
  pigment {rgb 0.8}
  finish {ambient 0.25}
  #if (Quality > 0)
    photons {pass_through}
  #end
  };
  
// begin scene objects
// -------------------
#if (Use_Photons)
  object {container}
#end

light_source {laser translate <42,2,22>}

object {flat_reflector 
  #if (Quality > 0)
    pigment { rgb .2 }
    finish {
      ambient .1
      diffuse .6
      reflection { 1 }
      } 
    photons {target reflection on refraction on}
  #else
    pigment {Silver}
  #end
  rotate y*45
  translate <0,2,22>
  }

object {flat_reflector 
  #if (Quality > 0)
    pigment { rgb .2 }
    finish {
      ambient .1
      diffuse .6
      reflection { 1 }
      } 
    photons {target reflection on refraction on}
  #else
    pigment {Silver}
  #end
  rotate y*225
  translate <0,2,0>
  }

object {flat_reflector 
  #if (Quality > 0)
    pigment { rgb .2 }
    finish {
      ambient .1
      diffuse .6
      reflection { 1 }
      } 
    photons {target reflection on refraction on}
  #else
    pigment {Silver}
  #end
  rotate y*45
  translate <-15,2,0>
  }

object {flat_reflector 
  #if (Quality > 0)
    pigment { rgb .2 }
    finish {
      ambient .1
      diffuse .6
      reflection { 1 }
      } 
    photons {target reflection on refraction on}
  #else
    pigment {Silver}
  #end
  rotate y*315
  translate <-15,2,-22>
  }
  
object {concave_glass1 scale <0.5,2,2> translate <-2.5,2,-22>}
object {maglass translate <2.5,2,-22>}
object {table translate y*-1.75}
object {the_target translate  <22,2,-22>}

// End Scene Objects
// -----------------

/* Begin Unused Items

#declare _z_ = -<44,36,0>;
#declare _x_ = vnormalize(vcross(y,_z_))*10;
#declare _y_ = vnormalize(vcross(_z_,_x_))*10;

#declare emitter =
merge {
  difference {
    cylinder {<-2,0,0>, <2,0,0>, 1}
    cylinder {<-2.1,0,0>, <1,0,0>, 0.9}
    }
  cylinder {<0,0,0>, <0,-3,0>, 0.7}
  #if (Quality > 0)
    texture { T_Chrome_3C }
    photons {pass_through}
  #else
    pigment {Silver}
  #end
  };
  
#declare trget = box {
  <-0.5, -8, -8>, <0.5, 8, 8>
  pigment { White }
  rotate z * 90
  translate  <-9, 9, 0>
  };
  
#declare concave_glass = 
difference {
  cylinder { <-2,0,0>,<2,0,0> 2 }
  //box { <-1, -2, -2>, <1, 2, 2> }
  sphere { <3.05,0,0>, 3 } sphere { <-3.05,0,0>, 3 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {Blue}
  #end
  };

#declare concave_glass66 = 
difference {
  cylinder { <-2,0,0>,<2,0,0> 2 }
  sphere { <6.05,0,0>, 6 } 
  sphere { <-6.05,0,0>, 6 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {Yellow}
  #end
  };
  
#declare concave_glass55 = 
difference {
  cylinder { <-2,0,0>,<2,0,0> 2 }
  sphere { <5.05,0,0>, 5 } sphere { <-5.05,0,0>, 5 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {Cyan}
  #end
  };
  
#declare concave_glass3 = 
difference {
  cylinder { <-2,0,0>,<2,0,0> 2 } 
  //sphere {  <5.1,0,0>, 5 }
  box { <.1,-3,-3>, <3, 3, 3> } sphere { <-3.3,0,0>, 3.2 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {Magenta}
  #end
  };
  
#declare concave_glass5 = 
difference {
  cylinder { <-.5,0,0>,<.5,0,0> 2 } 
  //sphere { <5.1,0,0>, 5 }
  box { <0,-3,-3>, <3, 3, 3> }
  //sphere { <-4.6,0,0>, 4.5 }
  sphere { <-5.1,0,0>, 5 }
  //sphere { <-2.1,0,0>, 2 }
  //sphere { <-6.1,0,0>, 6 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {White}
  #end
  };
  
#declare _prism =
prism {
  linear_sweep
  bezier_spline
  0.44,//top
  0.0, //bottom
  12 ,
  <0.22,0>,<-0.22,0>,<0.22,0>,<-0.22,0>,
  <-0.22,0>,<0.0,0.38106>,<-0.22,0>,<0.0,0.38106>,
  <0.0,0.38106>,<0.22,0>,<0.0,0.38106>,<0.22,0>
  };

#declare aprism =
object { _prism scale 10 
  texture {
    pigment { rgbf <1.0, 1.0, 1.0,.9> }
    finish { F_Glass3 }
    }
  interior { I_Glass }
  photons {
    target
    reflection on
    refraction on
    }
  };

#declare concave_glass21 = 
difference {
  cylinder { <-.5,0,0>,<.5,0,0> 2 }
  sphere { <2,0,0>, 1.9 } sphere { <-2,0,0>, 1.9 }
  
  #if (Quality > 0)
    material { m_glass } photons { target reflection on refraction on }
  #else
    pigment {MediumSeaGreen}
  #end
  };
  
#declare convex_reflector = 
sphere {0, 4
  scale <1,1,0.25>
  translate z*-1
  };

#declare concave_reflector = 
difference {
  sphere {  0, 4 }
  sphere {  0, 5 translate z*4
    #if (Quality > 0)
      pigment { rgb .2 }
      finish {
        ambient .1
        diffuse .6
        reflection { 1 }
        } 
      photons {target reflection on refraction on}
    #else
      pigment {White}
    #end
    }
  };
  
End Unused Items */