///////////////////////////////////////////////////////////
// Persistence of Vision Ray Tracer Scene Description File
// File: minesweeper.inc
// Vers: 3.6
// Desc: Scene file for solving minesweeper
// Date: May 22, 2006
// Auth: David Curtis


///////////////////////////////////////////////////////////
// Window Sizes
// +w144 +h144 +iminesweeper.pov
// +w256 +h256 +iminesweeper.pov
// +w480 +h256 +iminesweeper.pov


///////////////////////////////////////////////////////////
// controls
#declare grid_num     = 0;//int(clock*final_frame);
#declare game_num     = 5;//int(clock*final_frame);

#declare game_board   = < 9,  9, 10>; // Beginner
#declare game_board   = <16, 16, 40>; // Intermediate
#declare game_board   = <30, 16, 99>; // Expert

#declare hit_count    = 0;
//#declare initial_hits = array[hit_count] { <2, 12> }


///////////////////////////////////////////////////////////
// vars
#declare grid_seed    = seed(grid_num);
#declare game_seed    = seed(game_num);
#declare col          = game_board.x; 
#declare row          = game_board.y; 
#declare mines 	      = game_board.z;
#declare col_m        = col - 1;
#declare row_m        = row - 1;
#declare tables       = 4;
#declare gm           = 0;
#declare gr           = 1;
#declare max_loops    = 20;
#declare grid         = array[col][row][tables];
#declare hits         = 0;


///////////////////////////////////////////////////////////
//

#if (1)
	camera {
	  orthographic
	  location <0,1.2,0>
	  look_at  <0,0,0>
	  right col*x
	  up row*y
	  translate <col/2, 0, row/2>
	}
#else	
	camera {
		location  < col/2,    col,  row/2>
		direction < 0.000,  0.000,  1.000>
		right     < 1.333,  0.000,  0.000>
		look_at   < col/2,  0.000,  row/2>
	}
#end


background { color rgb 0.5 }

#default { finish { ambient 1 } }

#include "minesweeper.inc"


///////////////////////////////////////////////////////////
// Initialize grid
Init()


///////////////////////////////////////////////////////////
// Game play
#if (1)
	#declare game_won = false;
	#declare playing = true;
	#while (playing)

		NewHit()
		#debug concat("hit ",str(hits,2,0)," (",str(i,2,0),",",str(j,2,0),")\n")
		#declare grid[i][j][gr] = 1;

		#if (IsMine(i, j)) // game over?
			#declare playing = false;
			#declare grid[i][j][gm] = -2; // game ender

		#else
			#declare done = false;
			#declare loops = 0;
			#while (!done)
				CaptureSnapshot()
				
				MatchBlank()
				MatchUnrevealed()
				MatchFlagged()
				
				#if (CompareSnapshot())
					#declare done = true;
				#end
				
				#declare loops = loops + 1;
				#if (loops > max_loops)
					#debug "Max loops reached.\n"
					#declare done = true;
				#end
			#end
		#end
		
		#if (CountFlaggedTiles() = mines)
			#declare playing = false;
			#declare game_won = true;
		#end
	
	#end
#end


///////////////////////////////////////////////////////////
// output tiles
#declare i = 0; #while (i < col)
	#declare j = 0; #while (j < row)

		box { 
			0,<1, 0.1, 1>
			pigment { 
				image_map { sys "minesweeper icons.bmp" interpolate 2 }				
				scale <13,1,1> 
				rotate 90*x 
				translate TileIcon(i, j)*x
			}
			translate <i, 0, j>
		}
		
	#declare j = j + 1; #end
#declare i = i + 1; #end


///////////////////////////////////////////////////////////
// 
#if (game_won)
	#declare msg = "WIN";
	#declare clr = rgbt <0, 0.4, 0, 0.6>;
#else
	#declare msg = "LOSE";
	#declare clr = rgbt <1, 0, 0, 0.6>;
#end

#if (0)
	text { ttf "timrom.ttf" msg 0.1 0
		pigment { clr }
		translate <0.4,0.125,0>
		scale <0.3*col, row, 1>
		rotate 90*x
		translate <0, 0.25, 0>
	}
#end

#debug concat("\n",msg)
#debug concat("\n  Grid number: ",str(grid_num,0,0))
#debug concat("\n  Game number: ",str(game_num,0,0))
#debug concat("\n         Hits: ",str(hits,0,0),"\n")