//
// Add Widges (detail) to the basic space ship hull
//          

#include "transforms.inc"

#declare ComplexMast = union    {
        #declare cm = 1;
        #while(cm <= 4) 
                union   {                        
                        cylinder        {
                                        <-1,0,-1>,
                                        <-1,1,-1>,
                                        .05
                                        }    
                        cylinder        {
                                        <-1,0,-1>,
                                        <1,1,-1>,
                                        .03
                                        }    
                        cylinder        {
                                        <1,0,-1>,
                                        <-1,1,-1>,
                                        .03
                                        }    
                        rotate <0,90*cm,0>
                        }
                #declare cm = cm + 1;
        #end                        
        };


#macro AddWidges(theBasicObject)

#declare r1 = 10000 + int(rand(rStream)*15000); // count of widges
#declare restrictedWidgesCount = 0;
#declare maximumRestrictedWidges = 100;
#declare t1 = rand(rStream)*100;
#if(t1 < 50)
        #declare WhiteLights = yes;
#else                             
        #declare WhiteLights = no;
#end

union   { 
        object  {
                theBasicObject
                }
        // iterate through the widget count
        #while(r1 > 0)
                
                // declare a start point for the trace
                #declare TraceStartPoint = <0,0,1500>;
                
                //rotate the trace  start point round the origin (<0,0,0>)
                #declare TraceStartPoint = vrotate(TraceStartPoint,<rand(rStream)*360,rand(rStream)*360,rand(rStream)*360>);
                
                // the normal at the point of intersection
                #declare theNormal = <0,0,0>;
                
                // trace from random place to center of object                
                #declare TraceEnd = trace(theBasicObject,<(rand(rStream)*100)-50,(rand(rStream)*100)-50,(rand(rStream)*100)-50>,TraceStartPoint,theNormal);
        

                #if(TraceEnd.x != 0 & TraceEnd.y != 0 & TraceEnd.z != 0)

                        // select a widget type
                        #declare r2 = int(rand(rStream)*800); // widge type
                        #switch(r2)
                                #range(11,15)
                                        //fan
                                        union   {
                                                difference      {
                                                                cylinder        {
                                                                                <0,0,0>
                                                                                <0,1,0>,
                                                                                1
                                                                                }
                                                                cylinder        {
                                                                                <0,0,0>
                                                                                <0,1.1,0>,
                                                                                .8
                                                                                }
                                                                }
                                                sphere  { <0,0,0>,.2 scale <1,.5,1> translate <0,.81,0>} 
                                                #declare fanBlade = 0;
                                                #while(fanBlade < 360)
                                                        triangle { <0,0,0>,<1,0,0>,<.9,.2,-.4> translate <0,.81.0> rotate <0,fanBlade,0>}
                                                        #declare fanBlade = fanBlade + 30;
                                                #end 
                                                scale <2,1,2>
                                                scale <1,1+int(rand(rStream)*3),1>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break
                                #range(16,20)   
                                        // big gantry mast
                                        #declare t3 = int(rand(rStream)*5);
                                        #if(t3 = 2)
                                        #declare mastheight = int(rand(rStream)*30);
                                        #declare mastscale = (rand(rStream)+1);
                                        union   { 
                                                
                                        
                                        
                                        
                                                //top of mast
                                                box     {
                                                        <-1,1,-1>,<1,1.1,1>
                                                        translate <0,mastheight,0>
                                                        }             
                                                #declare mastTop = int(rand(rStream)*100);                                                        
                                                #switch(mastTop)
                                                        #range(0,10)
                                                                sphere  {<0,mastheight,0>,1
                                                                        }
                                                        #break                             
                                                        #range(11,20)
                                                        #break
                                                        #range(21,30)
                                                                cylinder        {
                                                                                <0,mastheight+1,0>,
                                                                                <0,mastheight+1+(rand(rStream)*2),0>,
                                                                                rand(rStream)*.5
                                                                                }
                                                        #range(31,100)
                                                                difference      {
                                                                                sphere  { <0,mastheight+1,0>,1 }
                                                                                box     {<-1,mastheight+1,-1 >,<1,mastheight-2,1>}
                                                                                }
                                                        #break
                                                #end
                                                
                                                        
                                                #while(mastheight >= 0)
                                                        object  {
                                                                ComplexMast
                                                                translate <0,mastheight,0>
                                                                }              
                                                        #declare mastheight = mastheight - 1;
                                                #end  
                                                scale <mastscale,mastscale*1.2,mastscale>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                                #declare restrictedWidgesCount = restrictedWidgesCount + 1;                                
                                       #end
                                #break   
                                #range(21,25)
                                        //Light Mast
                                        #declare restrictedWidgesCount = restrictedWidgesCount + 1;
                                        #if(restrictedWidgesCount < maximumRestrictedWidges)
                                                #declare lightHeight = (rand(rStream)*5)+2; 
                                                #if(WhiteLights = yes)
                                                        #declare lightColor = rgb <1,1,1>;
                                                #else
                                                        #declare lightColor = rgb <rand(rStream)+.1,rand(rStream)+.1,rand(rStream)+.1>;
                                                #end
                                                union {
                                                        cone    {
                                                                <0,0,0>,.2,
                                                                <0,lightHeight,0>,0
                                                                }
                                                        sphere  {
                                                                <0,lightHeight,0>,.12
                                                                no_shadow
                                                                texture { 
                                                                        pigment {
                                                                                lightColor
                                                                                }
                                                                        finish  {
                                                                                specular .1
                                                                                ambient .5
                                                                                }
                                                                        }                                                
                                                                }                                                     
                                                        light_source    { <0,lightHeight+2,0> color lightColor  fade_distance lightHeight fade_power 2
                                                                        area_light <.1,0,0>,<0,0,.1>,2,2
                                                                        adaptive 1 jitter
                                                                        }
                                                        Reorient_Trans(y, theNormal)
                                                        translate TraceEnd
                                                        }                                        
                                        #end                                        
                                #break    
                                #range(26,30)
                                        //Pipe work   
                                        #declare pipeSize = rand(rStream)*1;
                                        #declare pipeLength = 5+(rand(rStream)*5);
                                        sphere_sweep    {
                                                        linear_spline 
                                                        4,
                                                        <((pipeLength)/2)*-1,0,0>,pipeSize,
                                                        <((pipeLength)/2)*-1,rand(rStream)*5,0>,pipeSize,
                                                        <((pipeLength)/2),rand(rStream)*5,0>,pipeSize,
                                                        <((pipeLength)/2),0,0>,pipeSize
                                                        rotate <0,rand(rStream)*180,0> 
                                                        Reorient_Trans(y, theNormal)
                                                        translate TraceEnd
                                                        }
                                #break

                                #range(31,35)
                                        //small mast        
                                        #declare mastHeight = 10 + (5*rand(rStream));      
                                        #declare mastPole = .01 + (.3*rand(rStream));
                                        union   {
                                                cylinder        {<-1,0,-1>,<0,mastHeight,0>,mastPole}
                                                cylinder        {<1,0,1>,<0,mastHeight,0>,mastPole}
                                                cylinder        {<-1,0,1>,<0,mastHeight,0>,mastPole}
                                                cylinder        {<1,0,-1>,<0,mastHeight,0>,mastPole}
                                                sphere          {<0,mastHeight,0>,mastPole}
                                                cylinder        {<0,0,0>,<0,mastHeight,0>,.01+(.02*rand(rStream))}
                                                rotate <0,rand(rStream)*180,0>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break; 

                                #range(36,40)

                                        //tube
                                        #declare t3 = rand(rStream)*4;
                                        #declare t1 = cylinder{
                                                <0,0,0>,
                                                <0,4,0>,
                                                t3
                                                scale <1,1 +((rand(rStream)*2)-1.1),1>
                                                };
                                        difference      {
                                                        object  {
                                                                t1
                                                                }         
                                                        #declare t4 = t3-(rand(rStream)*t3);                                                                
                                                        object  {
                                                                t1 scale <t4,1.1,t4>
                                                                }                                                                
                                                        Reorient_Trans(y, theNormal)
                                                        translate TraceEnd
                                                        }                                                
                                #break;                                
                                #range(41,45)
                                        //sphere
                                        sphere  {
                                                <0,0,0>,rand(rStream)*4
                                                scale <1+rand(rStream),1-rand(rStream),1+rand(rStream)>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break;                                
                                #range(46,50)
                                        //cylinder
                                        cylinder{
                                                <0,0,0>,
                                                <0,4,0>,
                                                rand(rStream)*2
                                                scale <1+rand(rStream),1 +((rand(rStream)*2)-1.1),1+rand(rStream)>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break;
                                #range(51,55)
                                        // pyramid
                                        prism   {

                                                conic_sweep
                                                linear_spline
                                                0,1,5
                                                <4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>
                                                rotate<180,0,0>
                                                rotate <0,rand(rStream)*90,0>
                                                scale <1,5,1>
                                                translate <0,5,0>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break
                                #range(56,56)     
                                        // conning tower with cut outs
                                        difference      {
                                                        sphere  {
                                                                <0,0,0>,1
                                                                scale <2,5,1>                
                                                                rotate <0,0,20>
                                                                }  
                                                        box     {
                                                                <-1,2,-2>,<3,2.5,2>
                                                                }
                                                        box     {
                                                                <-1.3,3,-2>,<3,3.5,2>
                                                                }
                                                        box     {
                                                                <-.7,1,-2>,<3,1.5,2>
                                                                }          
                                                        box     {
                                                                <-3,0,-3>,<3,-5,3>
                                                                }                
                                                        rotate <0,rand(rStream)*360,0>
                                                        scale <1+(rand(rStream)*2),1+(rand(rStream)*2),1+(rand(rStream)*2)>
                                                        Reorient_Trans(y, theNormal)
                                                        translate TraceEnd
                                                        }
                                #break
                                #range(57,60)
                                        // bulbous headed mast
                                        union   {
                                                cone    {
                                                        <0,0,0>,.5
                                                        <0,5,0>,.2
                                                        }    
                                                cylinder{
                                                        <0,4.6,0>,
                                                        <0,4.65,0>,
                                                        .6
                                                        }  
                                                difference      {
                                                                sphere  {
                                                                        <0,0,0>,.5
                                                                        scale <1,1,1>
                                                                        translate <0,5,0>
                                                                        }                              
                                                                box     {
                                                                        <-.6 , 4.8 , -.6>,
                                                                        <.6  ,4    , .6>
                                                                        }
                                                                }  
                                                #declare dishCount = int(rand(rStream)*5);
                                                #while(dishCount >=0)
                                                        cylinder{
                                                                <0,0,0>,
                                                                <0,0,-.2>,
                                                                (rand(rStream)*.3) + .1
                                                                translate <0,0,-.25>
                                                                translate <0,rand(rStream)*4.5,0>
                                                                rotate <0,rand(rStream)*360,0>
                                                                }
                                                        #declare dishCount = dishCount - 1;
                                                #end 
                                                cylinder{
                                                        <0,4.65,-.6>,
                                                        <0,6.5,-.6>,
                                                        .05  
                                                        rotate <0,rand(rStream)*360,0>
                                                        }
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break
                                #range(61,65)
                                        difference      {
                                                         sphere {
                                                                <0,0,0>,1
                                                                scale <1,2,1>
                                                                }
                                                        torus   {
                                                                1,.1
                                                                translate <0,.5,0>
                                                                }  
                                                        torus   {
                                                                .9,.1
                                                                translate <0,1,0>
                                                                }  
                                                        torus   {
                                                                .7,.1
                                                                translate <0,1.5,0>
                                                                }  
                                                        torus   {
                                                                .5,.1
                                                                translate <0,1.8,0>
                                                                }  
                                                        box     {
                                                                <-1,0,-1>,
                                                                <1,-2,1>
                                                                }        
                                                                scale <1,1.5,1>                      
                                                        Reorient_Trans(y, theNormal)
                                                        translate TraceEnd
                                                        }
                                
                                #break
                                #else
                                        //box
                                        box     {
                                                <rand(rStream)*-4,rand(rStream)*-4,rand(rStream)*-4>,
                                                <rand(rStream)*4,rand(rStream)*4,rand(rStream)*4>
                                                Reorient_Trans(y, theNormal)
                                                translate TraceEnd
                                                }
                                #break
                        #end                                                   
                #end

                #declare r1 = r1 - 1;
        #end                       
        
        }

#end                                                   
                                                   