

//
// Base hull shape for the space ship
//
#macro Hull()  
merge   {
        #declare r3 = int(rand(rStream)*3);
        #while(r3 > -1)
                object  {
                        Hull2(r3)
                        }
                #declare r3 = r3 - 1;
        #end
        }                                
#end

#macro Hull2(scaleFactor)
object {
        //
        // establish a basic hull shape
        //
        #declare randHull = int(rand(rStream)*8);

        #if(randHull = 0) // sphere
                sphere  {
                        <0,0,0>,100
                        scale 1-(scaleFactor/1000)
                        }
        #end
        
        #if(randHull = 1) // cylinder
                cylinder{
                        <-100,0,0>,
                        <100,0,0>,40
                        scale 1-(scaleFactor/1000)
                        }
        #end                         
        #if(randHull = 2) // torus
                #declare r1 = (rand(rStream)*20)+20;
                #declare r2 = (r1 / (1 + (rand(rStream)*2)));
                torus   {
                        r1,r2
                        scale 1-(scaleFactor/1000)
                        }
        #end 
        #if(randHull = 3) // box
                box     {
                        <-90,-40,-40>,
                        <90,40,40>
                        scale 1-(scaleFactor/1000)
                        }  
        #end
        #if(randHull = 4) // rounded box
                superellipsoid  {
                        <.25,.25>
                        scale <90,40,40>
                        scale 1-(scaleFactor/1000)
                        }
        #end   
        #if(randHull = 5) // bumpy sphere
                isosurface {
                        function { f_sphere(x,y,z,100) -(f_noise3d(x/15,y/15,z/15)*8) }
                        contained_by { box {-200,200} }
                        max_gradient 1.9
                        scale 1-(scaleFactor/1000)
                        }
        #end  
        #if(randHull = 6) // scaled sphere
                sphere  {
                        <0,0,0>,50
                        scale <1,1+(rand(rStream)*3),1>
                        }
        #end                              
        #if(randHull = 7) // lumpy stick
                union   {
                        cylinder        {
                                        <-100,0,0>,
                                        <60,0,0>,40
                                        }          
                        sphere  {
                                <60,0,0>,60
                                }                                        
                        }
        #end        

        //
        // apply a random number of shape modifiers
        //
        #declare r1 = int(rand(rStream)*3);
        #while(r1 > 0)
                #declare r2 = int(rand(rStream)*3);
                #if(r2 = 0)
                        // rotation
                        rotate <rand(rStream)*90,rand(rStream)*90,rand(rStream)*90>
                #end               
                #if(r2 = 1)
                        // scale                                                   
                        scale <1 + (((rand(rStream)*10)-5)*.01),1 + (((rand(rStream)*10)-5)*.1),1 + (((rand(rStream)*10)-5)*.1)>
                #end                             
      /*
                #if(r2 = 2)
                        // shear
                        matrix <
                                (rand(rStream)*2),0,0,0,
                                0,0,0,0,
                                0,0,0,0
                                >

                #end                        
      */                  
                #declare r1 = r1 - 1;
        #end

        }                                            
#end