//
// Launch File for Spaceship Of The Week
//
#declare addTheWidges = true;  // false, to just see basic hull shape
#declare devLights = false; 

// basic includes
#include "colors.inc"
#include "glass.inc"  
#include "stars.inc"
#include "shapes.inc"
#include "metals.inc"
#include "functions.inc"   

camera {
  location  <50,1,-250>
  look_at   <0, 0,  0>
}

// Main seed value used thru out
#declare rStream = seed(3035);
//#declare rStream = seed(clock);

#if(devLights = true)
        light_source 	{
        		<-150, 400, -150>            
        		color White
        		}                  
        light_source 	{
        		<150, -400, -250>            
        		color White
        		}                  
#else
        #include "SOTWLights.inc"
#end		


// background
#include "SOTWStarField.inc"

// get basic hull shape 
#include "SOTWBasicHull.inc"
#declare basicHull = object {Hull()};

// decorate the hull with widges
#include "SOTWWidges.inc"          
#if(addTheWidges = true)
        #declare withWidges = object { AddWidges(basicHull) };
#else                                 
        #declare withWidges = object {basicHull};
#end        

// create a full ship texture
#include "SOTWTexture.inc" 
#declare shipTexture = GetTexture();
object  { withWidges texture { shipTexture } }






