
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// p4def_09.inc - Woman carrying flowerpot.
//
// "Paul's Primitive POV People", or "P4".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Declare the *textures* for everything.

        #declare P4_Eye_Texture = texture { T_Gold_1A }
        #declare P4_Glasses_Texture = texture { pigment{SpicyPink} }

        #declare P4_Hair_Texture = texture {
                pigment { Brown_Agate scale 0.05 } }

        #declare P4_Hat_Texture = texture {
                pigment { checker NeonBlue, White scale 50 } }

        #declare P4_Shirt_Texture = texture {

                pigment {
                        image_map { gif "paper-1.gif"
                                interpolate 2
                                } // end of image_map
                        } // end of pigment
                scale 5
                rotate < 33, 33, 33 >
                normal { bumps 0.2 scale 2 } }

        #declare P4_Shoe_Texture = texture { pigment{CornflowerBlue} }

        #declare P4_Shorts_Texture = texture {
                pigment { checker Yellow, White scale<1,100,1> }
                normal { bumps 0.5 scale 2 }
                rotate < 90, 0, 30 > }

        #declare P4_Skin_Texture = texture {
                pigment { color rgb < 0.4, 0.2, 0 > } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now choose *types* of things. You will have to read the directions
// to see what numbers are legal here!

        #declare P4_Eye_Type = 1
        #declare P4_Glasses_Type = 0
        #declare P4_Hair_Type = 3
        #declare P4_Hand_Type = 1
        #declare P4_Hat_Type = 0
        #declare P4_Mouth_Type = 5
        #declare P4_Nose_Type = 1
        #declare P4_Shirt_Type = 2
        #declare P4_Shoe_Type = 1
        #declare P4_Shorts_Type = 1

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set the sizes of various things.

        #declare P4_Leg_Length = 34
        #declare P4_Neck_Height = 3
        #declare P4_Shirt_Height = 22
        #declare P4_Shorts_Height = 14

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose the rotation values. Please read the directions!

        #declare P4_Hat_Rotate = < 20, 0, -10 >
        #declare P4_Neck_Rotate = < 0, -50, 0 >
        #declare P4_Waist_Rotate = < -10, 0, 0 >

        #declare P4_Left_Elbow_Rotate = < 0, -150, -70 >
        #declare P4_Right_Elbow_Rotate = < 0, 150,  70 >

        #declare P4_Left_Eyelid_Rotate = -40
        #declare P4_Right_Eyelid_Rotate = -40

        #declare P4_Left_Knee_Rotate = < -30, 0, 0 >
        #declare P4_Right_Knee_Rotate = < -10, 0, 0 >

        #declare P4_Left_Leg_Rotate = < 30, 0, -10 >
        #declare P4_Right_Leg_Rotate = < 10, 0, 10 >

        #declare P4_Left_Shoulder_Rotate = < 20, -40,  20 >
        #declare P4_Right_Shoulder_Rotate = < 20, 50, -30 >

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Create the optional "holding" object. This will go into the left
// hand, and move with the hand. This is optional - just comment it
// out if not needed, and set the flag to "false".
//
// The flag is necessary to prevent person #2 from carrying the object
// that you gave to person #1. Set it to true or false.

        #declare P4_Holding_Flag = true

// Kludge: Use an empty flowerpot for testing, and then when you include
//         this in the main scene, use the real (pre-defined) flowerpot.

        #declare P4_Holding_Object =
                union {
                difference {
                union {
                cone { <0,0,0>,3 <0,12,0>,5 pigment{color rgb<0.7,0,0>} }
                cone { <0,10,0>,5.2 <0,12,0>,5.5 pigment{color rgb<0.7,0,0>} }
                } // End of union.
                cone { <0,1,0>,2 <0,13,0>,5.0 pigment{color rgb<0.7,0,0>} }
                } // End of difference.
                cylinder{<0,10.9,0><0,11,0>,5 pigment{Yellow} }

                translate y* -8
                rotate z*30
                } // End of union.

        #ifdef ( Fancy_Flowerpot )
                #declare P4_Holding_Object =
                        object { Fancy_Flowerpot
                                translate y * -8
                                rotate z * 30 }
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make another optional object - a "bracelet". This also has a flag
// to set on/off. This prevents duplicate bracelets! The bracelet
// should be at <0,0,0>, just like a standard torus.

        #declare P4_Bracelet_Flag = true

        #declare P4_Bracelet_Object =
                torus { 3, 1 texture { T_Gold_5E } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Despite my attempts at using "realistic inches" as units, the
// people always seem to end up 8 or 9 feet tall. This variable lets
// you scale the person down to a normal size. Use the P4_TEST.POV
// scene to see how tall your person actually is!

        #declare P4_Total_Scale = 80/100

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// This is the height to move the person up, so his/her feet are on
// the floor. Sorry, but because of bendable legs, this has to be
// adjusted manually (by YOU). 8-)

        #declare P4_Y_Adjust = 33

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now call "p4_main.inc" to create the object.

        #include "p4_main.inc"

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

