
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "p4_test.pov" - The main test file for the people.
//
// "Paul's Primitive POV People", or "P4".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// The purpose of this file is to let you design and test one "person"
// with a simple scene. Then, when you have all of the settings just
// right, you can add the "person" to your own scene.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The standard initialization stuff.

        #include "colors.inc"
        #include "textures.inc"
        #include "skies.inc"
        #include "golds.inc"
        #include "stones.inc"
        #default { finish { Shiny } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose a camera. These are approximate, and will need adjusting!
//
// 1 = Far away.
// 2 = Head.
// 3 = Side of head.
// 4 = Shoes (to see if feet are on floor!).
// 5 = Really far away.
// 6 = Back view.
// 7 = Front view - head to waist.

        #declare P4_Which_Camera = 1

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose the file to test.

        #declare P4_FILENAME = "p4def_08.inc"

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set up the camera.

        #if ( P4_Which_Camera = 1 )
                camera { location < 0, 36, -150 > look_at < 0, 36, 0 > }
        #end

        #if ( P4_Which_Camera = 2 )
                camera { location < 0, 45, -45 > look_at < 0, 45, 0 > }
        #end

        #if ( P4_Which_Camera = 3 )
                camera { location < -70, 75, -40 > look_at < -70, 75, 0 > }
        #end

        #if ( P4_Which_Camera = 4 )
                camera { location < 0, 1, -30 > look_at < 0, 0, 0 > }
        #end

        #if ( P4_Which_Camera = 5 )
                camera { location < 0, 36, -300 > look_at < 0, 36, 0 > }
        #end

        #if ( P4_Which_Camera = 6 )
                camera { location < 70, 24, -85 > look_at < 70, 24, 0 > }
        #end

        #if ( P4_Which_Camera = 7 )
                camera { location < 0, 36, -60 > look_at < 0, 36, 0 > }
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Simple lights, floor, and background.

        light_source { < -50, 50, -200 > color White}
        light_source { <   0, 50, -200 > color White}
        light_source { <  50, 50, -200 > color White}

        cylinder { < 0, 0, 0 > < 0, -1, 0 >, 200 pigment { Cyan } }

        background { Gray20 }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// These posts show how tall your person is (12 inch squares).

        #declare A = -35 #while ( A <= 35 )

        box { < -3, 0, -3 > < 3, 100, 3 >
                pigment { checker White, Black scale 12 }
                translate x * A }

        #declare A = A + 70 #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// This is the random number seed (required!).

        #declare P4_RAND = seed(0)

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Go and set the variables, and create the object.

        #include P4_FILENAME

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now show the person three times.

        object { One_Person  rotate y * 90
                translate x * -70 }

        object { One_Person }

        object { One_Person rotate y * 180
                translate x * 70 }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

