
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// p4def_14.inc - Skateboarder - this one is on the board.
//
// "Paul's Primitive POV People", or "P4".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Declare the *textures* for everything.

        #declare P4_Eye_Texture = texture { pigment { Sapphire_Agate } }
        #declare P4_Glasses_Texture = texture { pigment{NavyBlue} }

        #declare P4_Hair_Texture = texture {
                pigment { color rgb < 0.9, 0.9, 0.2 > } }

        #declare P4_Hat_Texture = texture {
                pigment { color rgb<1,0.1,0.1> } }

        #declare P4_Shirt_Texture = texture {
                pigment { brick Black, NeonBlue scale 0.5 rotate < 50, 50, 50 > }
                normal { bumps 0.5 scale 2 } }

        #declare P4_Shoe_Texture = texture { pigment { Gray30 } }

        #declare P4_Shorts_Texture = texture {
                pigment { checker White, Black scale 0.5 }
                normal { bumps 0.5 scale 2 } }

        #declare P4_Skin_Texture = texture { pigment { CoolCopper } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now choose *types* of things. You will have to read the directions
// to see what numbers are legal here!

        #declare P4_Eye_Type = 1
        #declare P4_Glasses_Type = 0
        #declare P4_Hair_Type = 1
        #declare P4_Hand_Type = 1
        #declare P4_Hat_Type = 5
        #declare P4_Mouth_Type = 1
        #declare P4_Nose_Type = 2
        #declare P4_Shirt_Type = 2
        #declare P4_Shoe_Type = 1
        #declare P4_Shorts_Type = 3

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set the sizes of various things.

        #declare P4_Leg_Length = 30
        #declare P4_Neck_Height = 3
        #declare P4_Shirt_Height = 24
        #declare P4_Shorts_Height = 10

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Choose the rotation values. Please read the directions!

        #declare P4_Hat_Rotate = < -30, 190, 0 >
        #declare P4_Neck_Rotate = < 10, -40, 0 >
        #declare P4_Waist_Rotate = < -40, -10, 0 >

        #declare P4_Left_Elbow_Rotate = < 30, -130, 0 >
        #declare P4_Right_Elbow_Rotate = < 30, 40, 0 >

        #declare P4_Left_Eyelid_Rotate = -40
        #declare P4_Right_Eyelid_Rotate = -40

        #declare P4_Left_Knee_Rotate = < -70, 0, 0 >
        #declare P4_Right_Knee_Rotate = < -70, 0, 0 >

        #declare P4_Left_Leg_Rotate = < 80, 20, 0 >
        #declare P4_Right_Leg_Rotate = < 80, -20, 0 >

        #declare P4_Left_Shoulder_Rotate = < 0, -20,  10 >
        #declare P4_Right_Shoulder_Rotate = < 0, 20, -20 >

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Create the optional "holding" object. This will go into the left
// hand, and move with the hand. This is optional - just comment it
// out if not needed, and set the flag to "false".
//
// The flag is necessary to prevent person #2 from carrying the object
// that you gave to person #1. Set it to true or false.

        #declare P4_Holding_Flag = false

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make another optional object - a "bracelet". This also has a flag
// to set on/off. This prevents duplicate bracelets! The bracelet
// should be at <0,0,0>, just like a standard torus.

        #declare P4_Bracelet_Flag = false

        #declare P4_Bracelet_Object =
                torus { 2.5, 0.5 scale <1,2,1> pigment{Red} }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Despite my attempts at using "realistic inches" as units, the
// people always seem to end up 8 or 9 feet tall. This variable lets
// you scale the person down to a normal size. Use the P4_TEST.POV
// scene to see how tall your person actually is!

        #declare P4_Total_Scale = 70/100

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// This is the height to move the person up, so his/her feet are on
// the floor. Sorry, but because of bendable legs, this has to be
// adjusted manually (by YOU). 8-)

        #declare P4_Y_Adjust = 17

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now call "p4_main.inc" to create the object.

        #include "p4_main.inc"

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

