
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "house-2.inc" - Create the second (left side) house.
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// Note: This is the house on the left. It's even sloppier than the
//       house on the right! Most of the pieces are copied from house-1,
//       which was [obviously] done first.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set up the colors.

        #declare Trim_Pigment = pigment { MediumSeaGreen }
        #declare Siding_Pigment = pigment { Goldenrod }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Front siding.

        #declare Front_Siding = difference{

                union {
                #declare A = 0
                #while ( A < 9*12 )
                        box { < 0, -5, -1 > < 36*12, 5, 1 >
                                rotate x*10
                                translate y * (A+12) }
                #declare A=A+8
                #end
                } // End of union.

                // Move the windows and doors around.
                //  4- 8 window
                // 12-17 door
                // 22-26 window
                // 28-32 window

                // Cutouts for medium size windows.
                box { <  4*12, 2*12, -10 > <  8*12, 8*12, 10 > }
                box { < 22*12, 2*12, -10 > < 26*12, 8*12, 10 > }
                box { < 28*12, 2*12, -10 > < 32*12, 8*12, 10 > }

                // Cutout for door.
                box { < 12*12, 1*12, -10 > < 17*12, 8*12, 10 > }

                pigment { Siding_Pigment }
                normal { bumps 0.2 scale 1 }

                } // End of difference.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Right side siding. This starts out *too tall*, then everything
// outside the /\ part is differenced off.

        #declare Right_Side_Siding = difference {

                union {

                #declare A = 0
                #while ( A < 16*12 )

                        box { < 0, -5, -1 > < 24*12, 5, 1 >
                                rotate x*10
                                translate y * (A+12) }

                #declare A=A+8
                #end

                } // End of union.

                // Cutouts for medium size windows.
                box { <   4*12, 2*12, -10 > <   8*12, 8*12, 10 > }
                box { <  12*12, 2*12, -10 > <  16*12, 8*12, 10 > }

                // Slicer thingies.
                box { < -50, 0, -5 > < 300, 100, 5 >
                        rotate z * -30
                        translate <12*12, 17*12,0 > }

                box { <-300, 0, -5 > < 50, 100, 5 >
                        rotate z * 30
                        translate <12*12, 17*12,0 > }

                // Now spin it all, and move it over.
                        rotate y * -90
                        translate x * 36*12

                pigment { Siding_Pigment }
                normal { bumps 0.2 scale 1 }

                } // End of difference.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Very simple back and left side walls. These are white, because
// all you see is the interior side. Sloppy!

        #declare Fake_Walls = union {

                box { < 0, 12, 3 > < 1, 9*12, 24*12 > }

                box { < 0, 12, 24*12 > < 36*12, 9*12, (24*12)-1 > }

                pigment { White }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Medium size windows - fill up 48x72 rough openings.

        #declare Medium_Window = union {

                difference{
                box { < 0, 0, -6 > < 48, 72, 6 > }
                box { < 6, 6, -7 > < 42, 66, 7 > }

                        } // End of difference.

                // Horizontal dividers.
                        #declare A = 16
                        #while ( A <= 56 )
                        box{ < 0, A-0.5, -1 > < 48, A+0.5, 1 > }
                        #declare A = A + 10
                        #end

                // Extra thick center one!
                        box{ < 0, (36)-1.5, -2 > < 48, (36)+1.5, 2 > }

                // Vertical dividers.
                        #declare A = 15
                        #while (A <= 33 )
                        box{ < A-0.5, 0, -1 > < A+0.5, 72, 1 > }
                        #declare A=A+9
                        #end

                pigment { Trim_Pigment }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Curtains for medium windows.

        #declare The_Curtains =

                mesh {

                // Top part.
                triangle{ <0,72,7><28,72,7><0,0,7> }
                triangle{ <20,72,7><48,72,7><48,0,7> }

                // Bottom part.
                triangle{ <0,0,7><0,24,7><24,0,7> }
                triangle{ <48,0,7><48,24,7><24,0,7> }

                pigment { color rgb < 0.6, 0.6, 1.0 > }

                } // End of mesh

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The front door - fill up 60x84 rough opening.

        #declare Front_Door = union {

                difference{

                        box { < 0, 0, -6 > < 60, 84, 6 > }
                        box { < 6, 1, -7 > < 54, 78, 7 > }

                        pigment { Trim_Pigment }

                        } // End of difference.

                // Wood door.
                        box { < 0, 0, 5 > < 60, 84, 6 >
                                pigment { brick GreenCopper, Blue
                                        scale < 0.5, 200, 200 > }
                                normal { bumps 0.5 scale 0.2 } }

                // Door knob.
                        sphere{0,2 scale <1,1,0.5> translate < 9,36,4 >
                                texture { T_Gold_3C } }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Trim boards (at front corners of house).

        #declare Trim_Boards = union {

                box { < -2, 6, -2 > < 4, 9.5*12, 4 > }

                box { < (36*12)-4, 9, -2 > < (36*12)+2, 9.5*12, 4 > }

                pigment { Trim_Pigment }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Brick foundation

        #declare Brick_Foundation =

                box { < 1, 0, 1 > < (36*12)-1, 12, (24*12)-1 >
                        pigment { brick Gray30, Firebrick } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Front steps - one foot past door.

        #declare Front_Steps = union {

                box { < 15*12, 0, 1 > < 22*12,  6, -4.5*12 > }
                box { < 15*12, 6, 1 > < 22*12, 12, -4.0*12 > }

                pigment { brick Gray30, Firebrick }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Hand rails for front steps.

        #declare Hand_Rails = union {

        cylinder { < 15.5*12, 4*12, -2*12 > < 15.5*12, 4*12, 1*12 >, 1.5 }
        cylinder { < 21.5*12, 4*12, -2*12 > < 21.5*12, 4*12, 1*12 >, 1.5 }

        #declare A = -3.5 #while ( A <= -0.5 )

        cylinder { < 15.5*12, 0, A*12 > < 15.5*12, 4*12, A*12 >, 1.5 }
        cylinder { < 21.5*12, 0, A*12 > < 21.5*12, 4*12, A*12 >, 1.5 }

        #declare A = A + 0.5 #end

        pigment { SteelBlue }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Bright white floor.

        #declare White_Floor =
                box { < 3, 12, 3 > < (36*12)-3, 12.1, (24*12)-3 >
                pigment { White } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The roof (not very accurate, but it looks semi-ok).

        #declare Roof = union {

                // Front part (all shingles).
                // Rotate this *after* texture is applied.
                box { < -12, -24, 0 > < 37*12, 15*12, -6 >
                        texture { brick 
                                texture { pigment { Gray20 } },
                                texture { T_Wood35 }
                                brick_size < 36, 12, 12 >
                                mortar 0.5
                        } // End of texture.
                        rotate x * 90 }

                // Trim on front and right edge. This fits just a little
                // bit under the shingles.
                        box { < -12.1, 0, -24.1 > < 37.1*12, 5, 14.9*12 >
                        pigment { Trim_Pigment } }

                // Back part (just the right edge is visible). Paint it
                // with the trim color, because you're really looking
                // at the bottom, not the shingles!
                        box { < 34*12, 0, 0 > < 37*12, 6, 15*12 >
                        rotate x * 60 translate z * 12*15
                        pigment { Trim_Pigment } }

                // Adjust the entire roof.
                        rotate x * -30
                        translate y * 10*12

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// How about a nice big chimney!?!

        #declare The_Chimney = union {

                box { < -2*12, 0, 9*12 > < 0, 20*12, 15*12 >
                        pigment { brick Gray30, Firebrick } }

                box { < (-2*12)-2, 20*12,     ( 9*12)-2 >
                        < 2,       (20*12)+2, (15*12)+2 >
                        pigment { Gray30 } }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Put everything together.

        #declare House_Two = union {

                object { The_Chimney }
                object { Front_Siding }
                object { Right_Side_Siding }
                object { Fake_Walls }
                object { Brick_Foundation }
                object { Trim_Boards }

                object { Front_Steps translate x * (-4*12) }
                object { Hand_Rails  translate x * (-4*12) }

                object { White_Floor }
                object { Roof }

                object { Medium_Window translate<  4*12, 2*12, 4> }
                object { Medium_Window translate< 22*12, 2*12, 4> }
                object { Medium_Window translate< 28*12, 2*12, 4> }
                object { The_Curtains  translate<  4*12, 2*12, 4> }
                object { The_Curtains  translate< 22*12, 2*12, 4> }
                object { The_Curtains  translate< 28*12, 2*12, 4> }

                // Side windows
                object { Medium_Window rotate y * -90
                        translate<  (36*12)-4, 2*12, 4*12> }
                object { Medium_Window rotate y * -90
                        translate<  (36*12)-4, 2*12, 12*12> }
                object { The_Curtains  rotate y * -90
                        translate< (36*12)-4, 2*12, 4*12> }
                object { The_Curtains  rotate y * -90
                        translate< (36*12)-4, 2*12, 12*12> }

                object { Front_Door translate < 12*12, 1*12, 0 > }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

