
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "fryanegg.pov"
//
// "Fry An Egg On The Sidewalk".
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
// My entry for the July-August 1996 "Summer" IRTC.
//
// This scene requires POV-Ray 3.0, by the magnificent POV-Ray Team.
//
// All code and techniques are hereby declared PUBLIC DOMAIN.
// Have fun with it!
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Notes:
//
// All units represent INCHES. Some measurements are written as "37*12",
// to mean 37 FEET. This is the USA, we don't like the metric system!
//
// The origin (0,0,0) is in the middle of the street. Almost everything
// is placed to the right side, to avoid a lot of negative numbers.
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// These switches control what is/isn't displayed.
// Remember to set them all to "on" for that final render!

        #declare Show_Car         = on
        #declare Show_Curbs       = on
        #declare Show_Driveways   = on
        #declare Show_Eggs        = on
        #declare Show_Fake_Grass  = on
        #declare Show_Fences      = on
        #declare Show_Flowers     = on
        #declare Show_Garage      = on
        #declare Show_House_Left  = on
        #declare Show_House_Right = on
        #declare Show_Mailbox     = on
        #declare Show_People      = on
        #declare Show_Real_Grass  = on
        #declare Show_Road        = on
        #declare Show_Shrubs      = on
        #declare Show_Sidewalks   = on
        #declare Show_Sky         = on
        #declare Show_Trees       = on

        #declare Which_Camera = 1

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// All of the usual initialization.

        #include "colors.inc"
        #include "textures.inc"
        #include "skies.inc"
        #include "golds.inc"
        #include "stones.inc"
        #include "woods.inc"
        #include "teak.map"

        #default { finish { Shiny } }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set the camera position.

// Final camera position.

        #if ( Which_Camera = 1 )
                camera { location < 135*12, 8*12, -21*12 >
                        look_at < 121*12, 1*12, 0 > }
        #end

// Mailbox test camera.

        #if ( Which_Camera = 2 )
                camera { location < 118.5*12, 5*12, -9.25*12 >
                        look_at < 115*12, 3*12, -9*12 > }
        #end

// Left side house test camera.

        #if ( Which_Camera = 3 )
                camera { location < 40*12, 8*12, -15*12 >
                        look_at < 40*12, 4*12, 0 > }
        #end

// Right side house test camera.

        #if ( Which_Camera = 4 )
                camera { location < 112*12, 7*12, 15*12 >
                        look_at < 111*12, 7*12, 25*12 > }
        #end

// The mailman test camera.

        #if ( Which_Camera = 5 )
                camera { location < 102*12, 5*12, 9*12 >
                        look_at < 95*12, 3*12, 10.5*12 > }
        #end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Set up the main lights.

// Exactly at camera location.

        light_source { < 135*12, 8*12, -21*12 > color rgb 2.0 shadowless }

// Over on left - to fill in a little.
        
        light_source { < 0*12, 20*12, -10*12 > color rgb 0.5 shadowless }

// High overhead (this one makes the shadows).

        light_source { < 500*12, 2000*12, 0*12 > color rgb 1.0 }

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Miscellaneous.

        background { White }

        #declare R = seed(0)
        #declare P4_RAND = seed(0)

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Here's the skateboard for person #10 and #14.
// This is always included - no on/off switch (sloppy!).

        #declare Skateboard = union {

                // The board itself..
                superellipsoid { <0.1, 0.75 >
                        scale < 15, 1, 4 >
                        translate y * 2.5
                        texture { T_Gold_3C } }

                // Left side wheels.
                cylinder { <-10,0,-5><-10,0,-2>,1.4 pigment{OrangeRed} }
                cylinder { <-10,0, 5><-10,0, 2>,1.4 pigment{OrangeRed} }

                // Right side wheels.
                cylinder { < 10,0,-5>< 10,0,-2>,1.4 pigment{OrangeRed} }
                cylinder { < 10,0, 5>< 10,0, 2>,1.4 pigment{OrangeRed} }

                // Left and right trucks.
                box { <  9, -0.5, -2><  11, 1.5, 2> pigment{Blue} }
                box { < -9, -0.5, -2>< -11, 1.5, 2> pigment{Blue} }

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Here's the mailbag for person #3.
// This is always included - no on/off switch (sloppy!).

        #declare Mailbag = union {

                box { < -6, 0, -12 > < 6, 20, 12 > }

                torus { 9, 1 scale < 1, 3, 1 >
                        rotate z * 90
                        translate y * 24 }

                scale 0.75
                rotate z * 10
                translate < 12, 26.5, 0 >

                pigment { DarkBrown }
                normal { crackle 0.1 scale 0.01 }

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// All of the following sections are in alphabetical order, and each
// section has an on/off switch, set at the beginning of this file.
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build the car, and park it on the far side driveway.
//
// Note: This is a VERY sloppy car!!!
//
// The car was originally inside the garage, but now it's been
// backed out wa-a-a-a-a-a-y into the driveway.

#if ( Show_Car = on )

        #include "car-1.inc"

        object { One_Mysterious_Car translate < 122*12, 6, 13*12 > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Install the curbs. These are a little too wide (18 inches), but
// most of that ends up covered with grass.

#if ( Show_Curbs = on )

// Far side curbs.

        box { <0,0,8*12><117*12,6,(8*12)+18>
                pigment { Gray60 }
                normal { crackle 1 scale 0.5 } }

        box { <127*12,0,8*12><200*12,6,(8*12)+18>
                pigment { Gray60 }
                normal { crackle 1 scale 0.5 } }

// Near side curbs.

        box { <0,0,-8*12><117*12,6,(-8*12)-18>
                pigment { Gray60 }
                normal { crackle 1 scale 0.5 } }

        box { <127*12,0,-8*12><200*12,6,(-8*12)-18>
                pigment { Gray60 }
                normal { crackle 1 scale 0.5 } }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build the driveways.

#if ( Show_Driveways = on )

// The near side driveway and ramp.


        // Near side.
        box{ < 117*12, 0, (-8*12)-54> < 127*12, 6, -38*12 >
        pigment{Gray30}
        normal { crackle 1 scale 0.5 }
        }

        // Near side ramp.

        mesh {
                triangle {
                <117*12,0,-8*12><127*12,0,-8*12><117*12,6,(-8*12)-18> }
                triangle
                { <117*12,6,(-8*12)-18><127*12,0,-8*12><127*12,6,(-8*12)-18> }

                // Extra triangle to fill mysterious gap.
                triangle
                { <117*12,6,(-8*12)-18><127*12,6,(-8*12)-18><127*12,-30,(-8*12)-18> }

                pigment{Gray30}
                normal { crackle 1 scale 0.5 }
        } // end of mesh.

// The far side driveway and ramp.

        // Far side.
        box{ < 117*12, 0, (8*12)+54> < (80+47)*12, 6, 38*12 >
        pigment{Gray40}
        normal { crackle 1 scale 0.5 }
        }

        // Far side ramp.
        mesh {
                triangle {
                <117*12,0,8*12><127*12,0,8*12><117*12,5.9,(8*12)+18> }
                triangle {
                <117*12,5.9,(8*12)+18><127*12,0,8*12><127*12,5.9,(8*12)+18> }
                pigment{Gray30}
                normal { crackle 1 scale 0.5 }
        } // end of mesh.

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The eggs.

#if ( Show_Eggs = on )

// The eggs.

        #declare The_Center_Of_Attention = union {

                // The white part.
                sphere { 0, 3 scale < 1, 0.1, 1.5 > pigment { White } }

                // The yolk.
                sphere { 0, 1.2 scale < 1, 0.5, 1 >
                        pigment { color rgb < 2, 2, 0 > } }

                // Browned edges.
                sphere { 0, 3 scale < 1.03, 0.03, 1.53 > pigment { Copper } }

                } // End of union.

        object { The_Center_Of_Attention
                translate < 132*12, 6, -11*12 > }

        object { The_Center_Of_Attention
                translate < 132.4*12, 6, -11.4*12 > }

// Make a fancy (what else???) egg carton.

        #declare Egg_Carton = union {

                superellipsoid { < 0.25, 0.25 >

                        // Move it into position for image_map.
                        scale < 0.5, 0.5, 0.5 >
                        translate < 0.5, 0.5, 0.5 >

                        // Print the label.
                        pigment {
                                image_map { gif "eggs-1.gif"
                                interpolate 2
                                } // end of image_map
                                } // end of pigment

                        // Resize again.
                        translate < -0.5, -0.5, -0.5 >
                        rotate x * 90
                        scale < 13.5, 2, 4.2 >

                        } // End of superellipsoid.

                // Add twelve spheres.

                #declare X = 1 #while ( X <= 6 )
                #declare XX = (X*2)-7

                sphere { 0, 1.2 scale < 1, 1.5, -1 >
                        translate < XX, -1, -1 > pigment { Cyan } }

                sphere { 0, 1.2 scale < 1, 1.5,  1 >
                        translate < XX, -1, -1 > pigment { Cyan } }

                #declare X = X + 1 #end

        } // End of union.

// Show the egg carton. It's raised 2.8+6, to sit flat on sidewalk.

        object { Egg_Carton

                rotate y * -60
                translate < 130.7*12, 8.8, -12.3*12 >

                } // End of object.

// Now for some salt and pepper shakers.

        box { < 0, 0, 0 > < 1, 1, 1 >
                pigment {
                        image_map { gif "salt.gif"
                        interpolate 2
                        } // end of image_map
                        } // end of pigment
                translate < -0.5, 0, -0.5 >
                scale < 1.5, 5, 1.5 >
                translate < 131.5*12, 6, -12*12 > }

        sphere { < 131.5*12, 11, -12*12 >, 0.75 pigment { SteelBlue } }

        box { < 0, 0, 0 > < 1, 1, 1 >
                pigment {
                        image_map { gif "pepper.gif"
                        interpolate 2
                        } // end of image_map
                        } // end of pigment
                translate < -0.5, 0, -0.5 >
                scale < 1.5, 5, 1.5 >
                translate < 131.8*12, 6, -12.1*12 > }

        sphere { < 131.8*12, 11, -12.1*12 >, 0.75 pigment { SteelBlue } }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Plant fake grass across road.

#if ( Show_Fake_Grass = on )

// Left side of right-side-house (and WAAAAAY to the left).

        box { < -300*12, 0, (12.5*12) > < (80*12), 9, 300*12 >
                pigment { Jade scale 0.1 } }

// Directly in front of right side house. (mulch starts at z=34*12)

        box { < 80*12, 0, (12.5*12) > < (117*12), 9, 34*12 >
                pigment { Jade scale 0.1 } }

// Straight behind garage and house.
        box { < 80*12, 0, 58*12 > < 127*12, 9, 300*12 >
                pigment { Jade scale 0.1 } }

// Right side of far driveway.

        box { < 127*12, 0, (12.5*12) > < (200*12), 9, 300*12 >
                pigment { Jade scale 0.1 } }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build fences, behind and to left of houses.

#if ( Show_Fences = on )

// Build back fence at 90 feet, about 30 feet behind the houses.

        union {

                // Top cross rail.
                box { < 100*12, 3.5*12, 90.1*12 > < 150*12, 4*12, 90.2*12 > }

                // Bottom cross rail.
                box { < 100*12, 1*12, 90.1*12 > < 150*12, 1.5*12, 90.2*12 > }

                // Vertical pieces (every 8 inches).
                #declare X = 100*12 #while ( X <= 140*12 )

                box { < X, 0, 90*12 > < X+7, 4.5*12, 90.1*12 > }

                cylinder { < X+3.5, 4.5*12, 90*12 >
                           < X+3.5, 4.5*12, 90.1*12 >, 3.5 }

                #declare X = X + 8 #end

                pigment { Gray80 }
                normal { bumps 0.1 scale 0.1 }

        } // End of union.

// Build left side fence at x=0, just before left side trees.

        union {

                // Top cross rail.
                box { < -1, 3.5*12, 0 > < 0, 4*12, 100*12 > }

                // Bottom cross rail.
                box { < -1, 1*12, 0 > < 0, 1.5*12, 100*12 > }

                // Vertical pieces (every 8 inches).
                #declare Z = 20*12 #while ( Z <= 70*12 )

                box { < 0, 0, Z > < 1, 4.5*12, Z+7 > }

                cylinder { < 0, 4.5*12, Z+3.5 >
                           < 1, 4.5*12, Z+3.5 >, 3.5 }

                #declare Z = Z + 8 #end

                pigment { Gray80 }
                normal { bumps 0.1 scale 0.1 }

        } // End of union.


#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build the flowerpot, with flowers. This is used on the mailbox,
// and with person #09. You need to turn this switch on if you are
// displaying the mailbox.

#if ( Show_Flowers = on )

        #include "flowers.inc"

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The garage for the house on the right.

#if ( Show_Garage = on )

        #declare Trim_Pigment = pigment { Sapphire_Agate scale 0.1 }
        #declare Siding_Pigment = pigment { color rgb < 0.4, 0.4, 1.0 > }

// Here's the garage - it's 12 feet wide, 20 feet deep, 8 feet high,
// plus the roof height.

        #declare House_Two_Garage = union {

                // Left front wall.
                box{ < 0, 0, 0 > < 1.5*12, 8*12, 0.5*12 >
                        pigment { Siding_Pigment }
                        normal { bumps 0.5 scale 0.1 } }

                // Trim where garage hits house.
                box{ < -6, 0, -1 > < 6, 8*12, 0 >
                        pigment { Trim_Pigment } }

                // Wall above door.
                box{ < 0, 7*12, 0 > < 12*12, 8*12, 0.5*12 >
                        pigment { Siding_Pigment }
                        normal { bumps 0.5 scale 0.1 } }

                // Right front wall.
                box{ < 10.5*12, 0, 0 > < 12*12, 8*12, 0.5*12 >
                        pigment { Siding_Pigment }
                        normal { bumps 0.5 scale 0.1 } }

                // Left side wall (glued to house).
                box{ < 0, 0, 0 > < 0.5*12, 8*12, 20*12 > }

                // Right side wall.
                box{ < 11.5*12, 0, 0 > < 12*12, 8*12, 20*12 >
                        pigment { Siding_Pigment }
                        normal { bumps 0.5 scale 0.1 } }

                // Right side triangle.
                triangle { < 12*12,  8*12,  0*12 >
                           < 12*12,  8*12, 20*12 >
                           < 12*12, 13*12, 10*12 >
                           pigment { Siding_Pigment }
                           normal { bumps 0.5 scale 0.1 } }

                // Back wall.
                box{ < 0, 0, 19.5*12 > < 12*12, 8*12, 20*12 > }

                // A little bit of the roll-up door. It's TEAK!!! 8-)
                box{ < 0, 6*12, 7 > < 12*12, 8*12, 8 >
                        texture {
                        pigment { P_WoodGrain3A
                                color_map { M_Teak }
                                scale 2 rotate x*90
                                } // End of pigment.
                                } // End of texture.
                                } // End of box.

                // Handle on the door. It's SOLID GOLD!!! 8-)
                box{ < 5.5*12, 6.2*12, 6.8 > < 6.4*12, 6.4*12, 7 >
                        texture { T_Gold_3C } }

                // Floor (below zero to hide driveway gap).
                box{ < 0.1, -6, 0.1 > < 11.9*12, 0.1, 19.9*12 >
                        pigment { Gray70 } }

                // Door into house. A really CHEAP door! 8-)
                box{ < 6, 8, 6*12 > < 6.1, 7.5*12, 9*12 >
                        pigment { Gray30 } }

                // Step up to that door.
                box{ < 5, 0, 6*12 > < 12, 8, 9*12 >
                        pigment { color rgb <1, 0.5, 0.5 > } }

                pigment { Siding_Pigment }

                } // End of union.

// Build the garage roof.

        #declare Garage_Roof = union {

                // Front part (all shingles).
                // Rotate this *after* pigment is applied.
                box { < -12, -12, 0 > < 13*12, 11.5*12, -6 >
                        pigment { brick Gray20, SteelBlue
                        brick_size < 36, 12, 12 >
                        mortar 0.5 }
                        normal { bumps 0.5 scale 0.1 }
                        rotate x * 90 }

                // Trim on front and right edge. This fits just a little
                // bit under the shingles.
                        box { < -12.1, 0, -12.1 > < 13.1*12, 5, 11.4*12 >
                        pigment { Trim_Pigment } }

                // Back part (just the right edge is visible). Paint it
                // with the trim color, because you're really looking
                // at the bottom, not the shingles!
                        box { < 10*12, 0, 0 > < 13*12, 6, 11.5*12 >
                        rotate x * 50 translate z * 11*12
                        pigment { Trim_Pigment } }

                // Adjust the entire roof.
                        rotate x * -25
                        translate y * 8.0*12

                } // End of union.


// So far, the garage looks rather FAKE. So, to make it more realistic,
// it's time to toss in a bunch of boxes of old junk!

        #declare Old_Junk = union {

                #declare X = 0 #while ( X <= 8 )
                #declare Y = 0 #while ( Y <= 3 )
                        box { < -12, 0, -6 > < 12, 18, 6 >
                                rotate <rand(R)*10,rand(R)*10,rand(R)*10>
                                translate < (X+1)*12, Y*12, 6 >
                                #declare TEMP = (rand(R)*0.25) + 0.25
                                pigment { color rgb < 0.5, TEMP, 0 > }
                                normal { bumps 0.5 scale 3 }
                                } // End of box.
                #declare Y = Y + 1.5 #end
                #declare X = X + 2   #end

                } // End of union.

// Put it all together.

        #declare Entire_Garage = union {

                object { Old_Junk translate < 0.5, 0, 18*12 > }
                object { Old_Junk rotate y*-90 translate <18, 0, 10*12 > }
                object { House_Two_Garage }
                object { Garage_Roof }

                // This light is here to brighten the garage (doh!).
                        light_source { < 6*12, 8*12, 8*12 >
                                color White shadowless }

                } // End of union.

// Now, finally, show the garage!

        object { Entire_Garage translate < 116*12, 6, 39*12 > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The house on the left (36 feet wide by 24 feet deep).

#if ( Show_House_Left = on )

        #include "house-2.inc"

        object { House_Two
                translate < 0, 9, 0 >
                translate < (24-2)*12, 0, (36+2)*12 > }

#end


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The house on the right (36 feet wide by 24 feet deep).

#if ( Show_House_Right = on )

        #include "house-1.inc"

        object { House_One
                translate < 0, 9, 0 >
                translate < 80*12, 0, 36*12 > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// This is the mailbox, with one flowerpot full of flowers.

#if ( Show_Mailbox = on )

// Stop if there is no flowerpot!

        #ifndef ( Fancy_Flowerpot )
                #error "PLEASE TURN ON Show_Flowers SWITCH!\n"
        #end

#declare Entire_Mailbox = union {

        object { Fancy_Flowerpot
                        scale 0.5
                        translate < 0, 33, -7 > }

        // Connector to hold flowerpot on.
                sphere { 0, 3 scale < 1, 0.2, 1 >
                        pigment { Black }
                        translate < 0, 38, -7 > }
                cylinder { < 0, 38, -7 > < 0, 38, 0 >, 0.3
                        pigment { Black } }

        // Connector to hold flowerpot on.
                sphere { 0, 2.4 scale < 1, 0.2, 1 >
                        pigment { Black }
                        translate < 0, 35, -7 > }
                cylinder { < 0, 35, -7 > < 0, 35, 0 >, 0.3
                        pigment { Black } }

        // The post for the mailbox.

        #declare Post_Texture = texture {
                pigment { DMFDarkOak scale 0.1 }
                normal { bumps 1 scale 1 } }

        union {

                // Upright.
                box { < -2, 0, -2 > < 2, 48,  2 >
                texture { Post_Texture } }

                // Sideways - to put mailbox on. It starts at z=2.2
                // instead of z=2, to leave a little [sloppy] gap.
                        box { < -2,36, 2.2 > < 2, 40, 18 >
                        texture { Post_Texture rotate z * 90 } }

                // Point on upright.
                mesh {
                        triangle { <-2,48,-2><0,51,0>< 2,48,-2> }
                        triangle { < 2,48,-2><0,51,0>< 2,48, 2> }
                        triangle { < 2,48, 2><0,51,0><-2,48, 2> }
                        triangle { <-2,48, 2><0,51,0><-2,48,-2> }
                        texture { Post_Texture }
                } // End of mesh.

                // Diagonal brace.
                box { < -1, 0, -1 > < 1, 20, 1 >
                        rotate x * 45
                        translate y * 24
                        texture { Post_Texture } }

        } // End of union.

        // The actual mailbox, with paint on it.
                union {

                cylinder { < 0, 0.5, 0.5 > < 1, 0.5, 0.5 >, 0.5 }
                box { < 0, 0, 0 > < 1, 0.5, 1 > }

                        pigment {
                                image_map { gif "mailbox1.gif"
                                        interpolate 2
                                } // end of image_map
                        } // end of pigment

                scale < 18, 8, 8 >

                // Move it in front of center.
                        translate z * -4
                // Swing it around.
                        rotate y * -90
                // Raise it.
                        translate < 0, 40, 2.2 >

                } // End of union.

        // Slightly larger door pieces.
                union {
                box { < -4.2, 0, 18 > < 4.2, 4, 19 > }
                cylinder { < 0, 4, 18 > < 0, 4, 19 >, 4.2 }
                pigment { SteelBlue }
                translate < 0, 40, 2.2 >
                } // End of union

        } // End of union.

// Show the mailbox - back 8 feet from center of road, then another
// 15.5 inches, to leave 0.5 inches of grass between post and sidewalk!

        object {Entire_Mailbox translate < (116)*12, 5, (-8*12)-15.5 > }

// Since this is the mailbox section, why not make another one for the
// other side of the street? Oh, ok, here it is...

        #declare Second_Mailbox = union {

        union {

                cylinder { < 0, 0.5, 0.5 > < 1, 0.5, 0.5 >, 0.5 }
                box { < 0, 0, 0 > < 1, 0.5, 1 > }

                        // Super-sloppy GIF, sorry!!!
                        pigment {
                                image_map { gif "mailbox2.gif"
                                        interpolate 2
                                } // end of image_map
                        } // end of pigment

                scale < 20, 8, 8 >
                translate < -10, 36, -4 >
                rotate y * -90

                } // End of union

                // Post.
                cylinder { < 0, 0, 0 > < 0, 36, 0 >, 3
                        pigment { SlateBlue }
                        normal { bumps 1 scale 1 } }

                } // End of union.

// Show the second mailbox.

        object { Second_Mailbox translate < 102*12, 6, 13*12 > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now for some people. This section calls several "p4def_??.inc" files,
// which contain the parameters for each person. Then those files call
// the big "p4_main.inc", which creates the "One_Person" object. Then
// that object is positioned right here (look down a few lines!).
//
// This system is called "Paul's Primitive POV People", or "P4".

#if ( Show_People = on )

        // Skating girl.
        #include "p4def_01.inc"
        object { One_Person rotate y*95 translate < 125*12, 0, 2*12 > }

        // Spatula boy.
        #include "p4def_02.inc"
        object { One_Person rotate y*45 translate < 134*12, 6, -10*12 > }

        // Mailman.
        #include "p4def_03.inc"
        union {
                object { One_Person }
                object { Mailbag }
                rotate y*-90 translate < 96*12, 6, 10.5*12 > }

        // Woman clipping hedges.
        #include "p4def_04.inc"
        object { One_Person rotate y*-60 translate < 130.5*12, 8, 20*12 > }

        // Skating guy with funny hair.
        #include "p4def_05.inc"
        object { One_Person rotate y*-90 translate < 100*12, 0, -4*12 > }

        // Person inside house watching tee-vee.
        #include "p4def_06.inc"
        object { One_Person rotate y*130 translate < 108.5*12, 9+12, 44*12 > }

        // Second person inside house watching tee-vee.
        #include "p4def_07.inc"
        object { One_Person rotate y*110 translate < 107*12, 9+12, 42*12 > }

        // Girl looking at spatula boy.
        #include "p4def_08.inc"
        object { One_Person rotate y*-100 translate < 129*12, 6, -13*12 > }

        // Woman with flowerpot.
        #include "p4def_09.inc"
        object { One_Person rotate y*-20 translate < 126.75*12, 6, -16.5*12 > }

        // Show the skateboard for the next person.
        object { Skateboard
                rotate < 40, 20, 20 >
                translate < 118*12, 4.5*12, 10*12 > }

        // Kid flying through the air.
        #include "p4def_10.inc"
        object { One_Person
                // Tilt head towards camera.
                        rotate x * -40
                // Turn around.
                        rotate y * 100
                // Move it.
                        translate < 115*12, 48, 10*12 > }

        // Kid playing in yard.
        #include "p4def_11.inc"
        object { One_Person rotate y*20 translate < 67*12, 9, 22*12 > }

        // Another kid playing in yard.
        #include "p4def_12.inc"
        object { One_Person rotate y*30 translate < 70*12, 9, 25*12 > }

        // Hoop kid..
        #include "p4def_13.inc"
        union {
                object { One_Person }
                torus { 18, 0.5 translate < 9, 24, 0 > pigment{White} }
                rotate y*-30 translate < 131*12, 0, 6.5*12 > }

        // Second skateboarder.
        #include "p4def_14.inc"
        union {
                object { One_Person translate < 0, 5.0, 14 > }
                object { Skateboard translate y * 1.5 }
                rotate y*40 translate < 116*12, 0, -3*12 > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build one piece of "sod", 12 inches by 12 inches. This eats about
// 450,000 bytes, but you can make as many copies as you need, without
// using (almost) any more memory!

#if ( Show_Real_Grass = on )

        #declare Square_Of_Sod = union {

        box { <0,0,0><12,-1,12> pigment{White} }

        mesh {

        #declare X = 0 #while (X<=11.5)
        #declare Z = 0 #while (Z<=11.5)

                // Calculate random location of top of blade.
                #declare Wiggle_X = X+0.25 + ( (rand(R)*1 ) - 0.5 )
                #declare Wiggle_Y = 3      + ( (rand(R)*1 ) - 0.5 )
                #declare Wiggle_Z = Z+0.25 + ( (rand(R)*1 ) - 0.5 )
                #declare TOP = < Wiggle_X, Wiggle_Y, Wiggle_Z >

                // Front of blade.
                triangle { <X, 0, Z>, TOP, <X+0.5, 0, Z> }

                // Left rear of blade.
                triangle { <X, 0, Z>, TOP, <X+0.25, 0, Z+0.5> }

                // Right rear of blade.
                triangle { <X+0.25, 0, Z+0.5>, TOP, <X+0.5, 0, Z> }

        #declare Z=Z+0.5 #end
        #declare X=X+0.5 #end

        texture { pigment{Jade scale 0.1 } finish{Shiny} }

        } // End of mesh.

        } // End of union.

// Now glue 10 squares of sod together for a nice big sod-a-rama.

        #declare Giant_Sod = union {

                #declare X = 0 #while ( X<=9 )

                        object { Square_Of_Sod translate < X*12, 0, 0 > }

                #declare X = X + 1 #end

                } // End of union.


// Plant grass on right side of near driveway.

        object { Giant_Sod translate < 127*12, 6, (-13.5*12) > }
        object { Giant_Sod translate < 127*12, 6, (-14.5*12) > }
        object { Giant_Sod translate < 127*12, 6, (-15.5*12) > }
        object { Giant_Sod translate < 127*12, 6, (-16.5*12) > }
        object { Giant_Sod translate < 127*12, 6, (-17.5*12) > }

// Plant grass on left side of near driveway.

        object { Giant_Sod translate < 107*12, 6, (-13.5*12) > }
        object { Giant_Sod translate < 107*12, 6, (-14.5*12) > }
        object { Giant_Sod translate < 107*12, 6, (-15.5*12) > }

// Plant grass between NEAR curbs and sidewalk.

        object { Giant_Sod translate < ( 97*12)-6, 6, ( -9.5*12) > }
        object { Giant_Sod translate < (107*12)-6, 6, ( -9.5*12) > }
        object { Giant_Sod translate < (127*12)+6, 6, ( -9.5*12) > }

// Plant grass between FAR curbs and sidewalk.

        #declare A=47 #while(A<=107)
                object { Giant_Sod translate < ( A*12)-6, 6, ( 8.5*12) > }
        #declare A=A+10 #end

        object { Giant_Sod translate < (127*12)+6, 6, ( 8.5*12) > }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The road (16 feet wide).

#if ( Show_Road = on )

// Make road with a hole in it.

        difference {

                box { < -200*12, -2, -8*12 > < 200*12, 0.05, 8*12 > }

                cylinder { < 127*12, -3, -2*12 > < 127*12, 1, -2*12 >, 14 }

                pigment { Gray40 }
                normal { crackle 2 scale 1 }

                } // End of difference.

// Put manhole cover in hole.

        cylinder { < 127*12, -1, -2*12 > < 127*12, -2, -2*12 >, 14

                pigment { checker Black, MidnightBlue scale 4 }
                normal { quilted 4 scale 4 }

                } // End of cylinder.


#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build some shrubs.

#if ( Show_Shrubs = on )

        #declare Shrub = union {

                superellipsoid { <0.25, 0.25 >
                        scale < 6, 15, 6 >
                        translate y * 21
                        pigment { color rgb < 0, 0.2, 0 > }
                        normal{crackle 4 scale 1} }

                cone { <0,0,0>,1.5 <0,16,0>,1 pigment{Brown} }

        } // End of union.

        #declare Needs_To_Be_Trimmed_Shrub = union {

                superellipsoid { <0.6, 0.6 >
                        scale < 10, 25, 5 >
                        translate y * 21
                        pigment { color rgb < 0, 0.15, 0 > }
                        normal{crackle 4 scale 2} }

                cone { <0,0,0>,1.5 <0,16,0>,1 pigment{Brown} }

        } // End of union.

// Plant all of the shrubs.

// Left side house. House starts at x=22*12, z=38*12.

        // On left of door.
        #declare X = 22
        #while ( X <= 32 )
                object{Shrub translate < X*12, 8.5, 37*12 > }
        #declare X = X + 1
        #end

        // On right of door.
        #declare X = 41
        #while ( X <= 58 )
                object{Shrub translate < X*12, 8.5, 37*12 > }
        #declare X = X + 1
        #end

        // Around on right side.
        #declare Z = 37
        #while ( Z <= 63 )
                object{Shrub translate < 59*12, 8.5, Z*12 > }
        #declare Z = Z + 1
        #end

// Mulch and railroad ties for left side house (sloppy!).
// These actually go all the way around the house.

        box { < 21*12, 0, 36*12 > < 59*12, 10, 64*12 >
                pigment { DarkBrown } }

        box { < 21.5*12, 0, 36.5*12 > < 58.5*12, 11, 63.5*12 >
                pigment { Copper } normal{crackle 4 }  }

// Mulch and railroad ties for right side house (also sloppy!).
// The garage starts at z=39*12, so just have the mulch go back that far.

        box { < 79*12, 0, 34*12 > < 118*12, 10, 39*12 >
                pigment { DarkBrown } }

        box { < 79.5*12, 0, 34.5*12 > < 117.5*12, 11, 38.5*12 >
                pigment { Copper } normal{crackle 4 }  }

// Right side house - in front. House starts at x=80*12, z=36*12.

        #declare X = 80
        #while ( X <= 95 )
                object{Shrub translate < X*12, 8.5, 35*12 > }
        #declare X = X + 1
        #end

        #declare X = 102
        #while ( X <= 117 )
                object{Shrub translate < X*12, 8.5, 35*12 > }
        #declare X = X + 1
        #end

// Around corner between house and garage.

        object { Shrub translate < 117*12, 8.5, 36*12 > }
        object { Shrub translate < 117*12, 8.5, 37*12 > }
        object { Shrub translate < 117*12, 8.5, 38*12 > }

// Nice trimmed shrubs - over past right side of garage.

        #declare Z =  14*12
        #while ( Z <= 20*12 )

                object{Shrub translate < 133*12, 8.5, Z > }

        #declare Z = Z + 12
        #end

// UNtrimmed shrubs - over past right side of garage.

        #declare Z =  21*12
        #while ( Z <= 60*12 )

                object { Needs_To_Be_Trimmed_Shrub

                        rotate y * ( P4_RAND*360 )
                        translate < 133*12, 8.5, Z >

                        } // End of object.

        #declare Z = Z + 12
        #end

// Mulch (with brick border) - over past right side of garage.

        box { < 132.3*12, 0, 12.8*12 > < 133.7*12, 10, 61.2*12 >
                pigment { Firebrick } }

        box { < 132.5*12, 0, 13.0*12 > < 133.5*12, 11, 61.0*12 >
                pigment { Copper } normal{crackle 4 } }


#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build each section of sidewalk one-at-a-time. The variable YYY puts
// one section on each side of the street. XXX goes left-to-right.
// In other words, YYY is actually the "z" variable (SLOPPY!).

#if ( Show_Sidewalks = on )

        #declare YYY = -132 #while ( YYY <= 132 )
        #declare XXX =   54 #while ( XXX <= 138 )

        difference{

                union {

                // The big sidewalk section.
                box { < -17.75, 0, -17.75 > < 17.75, 6, 17.75 > }

                // Add some connector grout-goo-whatever stuff.
                        box { <-18, 0,-18><18,5.5,18>
                        pigment { Gray20 }
                        } // End of box.

                } // End of union.

                // Now cut out some random chunks (this is a realistic
                // sidewalk, not a perfectly flat one!).

                #declare A=1 #while(A<=20)
                box { < -9, -0.03, -9 > < 9, 5, 9 >
                        rotate < (rand(R)*6)-3, 0, (rand(R)*6)-3 >
                        rotate y * (rand(R)*360)
                        translate< (rand(R)*44)-22,6,(rand(R)*44)-22> }
                #declare A=A+1 #end

                // Add some texture.
                        pigment { Gray60 }
                        normal { crackle 1 scale 0.5 }

                // Move it to the correct place.
                translate < XXX * 12, 0, YYY >

                } // End of difference.

        #declare XXX = XXX + 3   #end
        #declare YYY = YYY + 264 #end

// Build a walkway from the far sidewalk to the right side house.
// The house steps go from x=95 feet to x=102 feet, so make the walk
// centered on that (but narrower).

        box { < 96*12, 0, (12.5-0.001)*12 > < 101*12, 10, 36*12 >
                pigment { brick Gray30, Firebrick } }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The sky.

#if ( Show_Sky = on )

        sky_sphere { S_Cloud3 rotate y * 270 }

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Show all of the big trees.

#if ( Show_Trees = on )

// Include the masterpiece of a tree include file!

        #include "ptd_tree.inc"

// Between the houses.

        object { Complete_Tree scale 14
                translate < 70*12, 0, 38*12 > } // End of object.
        
// Over on left side.

        object { Complete_Tree scale 18 rotate y * 90
                translate < -20*12, 0, 50*12 > } // End of object.

        object { Complete_Tree scale 20 rotate y * 180
                translate < -20*12, 0, 75*12 > } // End of object.

        object { Complete_Tree scale 20 rotate y * 140
                translate < -20*12, 0, 100*12 > } // End of object.

// Behind the houses.

        object { Complete_Tree scale 20 rotate y * 240
                translate <  40*12, 0, 100*12 > } // End of object.

        object { Complete_Tree scale 20 rotate y * 300
                translate <  70*12, 0, 100*12 > } // End of object.

        object { Complete_Tree scale 20 rotate y * 60
                translate < 100*12, 0, 100*12 > } // End of object.

        object { Complete_Tree scale 16 rotate y * 180
                translate < 128*12, 0, 100*12 > } // End of object.

#end

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file - bye!

