//Macro Pattern Include File
//Samuel Benge, 1999
//Read the docs!

#declare Pi=3.14159265358979323846264338327950

//********************** Sine wave pattern **********************

#macro sine( sine_x, sine_y )
 function{
  cos( ( x*Pi )*sine_x*2 )*sine_y+y
 }  
#end

//********************** Organic pattern **********************

#macro organic( Turb )
 function{
  noise3d(
   x+noise3d( x*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   y*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   z*Turb+noise3d(x*Turb*2, y*Turb*2, z*Turb*2) ),

   y+noise3d( x*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   y*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   z*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2) ),

   z+noise3d( x*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   y*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2 ),
   z*Turb+noise3d( x*Turb*2, y*Turb*2, z*Turb*2) )
  )
 }
#end

//********************** Strata pattern **********************

#macro strata( freq, t_amnt, ht_amnt )
 function{
  noise3d( y*freq+noise3d( y+noise3d( x*4, y*4, z*4 ), x, z)*t_amnt, x*ht_amnt, z*ht_amnt )
 }
#end

//********************** Fabric pattern **********************

#macro fabric( strings )
 function{
  ( noise3d( x*strings, 0, 0 )/3 )+( noise3d( 0, y*strings,0 )/3 )+( noise3d( 0, 0, z*strings )/3 )
 }
#end

//********************** Lines pattern **********************

#macro lines( line_amnt )
 function{
  ( noise3d( x*line_amnt, 0, 0) )&( noise3d( 0, y*line_amnt, 0) )&( noise3d( 0, 0, z*line_amnt ) )
 }
#end

//********************** Lumps pattern **********************

#macro lumps( stretch )
 function{
  ( noise3d( x*stretch, y, z) )&
  ( noise3d( x, y*stretch, z) )&
  ( noise3d( x, y, z*stretch) )
 }
#end

//********************** Pigments combined to form new materials **********************
//*************************************************************************************
//***************** Comment out if using older version of superpatch ******************


//***************** Radial Sine Wave pattern *****************

#macro radsine( rsine_h, rsine_y )
 #local Rad = function{ pigment{ radial frequency rsine_h sine_wave color_map{[0 rgb 0][1 rgb 1]} } }
 function{
  Rad( x, 0, z )+( y/rsine_y )
 }
#end 

//***************** Spiral3 pattern *****************

#macro spiral3( nsp )
 #local NP = function{ pigment{ spiral1 nsp  sine_wave color_map{[0 rgb 0][1 rgb 1]} } }
 function{
  NP( x, y, z )|NP( -x, y, z )
 }
 rotate x*90
#end

//***************** Grid pattern *****************

#macro grid( grid_lines )
 #local Gx=function{ pigment{ gradient x triangle_wave color_map{ [1-grid_lines rgb 0][.9999999 rgb 1][1 rgb 0] } } }
 #local Gy=function{ pigment{ gradient y triangle_wave color_map{ [1-grid_lines rgb 0][.9999999 rgb 1][1 rgb 0] } } }
 #local Gz=function{ pigment{ gradient z triangle_wave color_map{ [1-grid_lines rgb 0][.9999999 rgb 1][1 rgb 0] } } }
 function{
  ( Gx( x, y, z ) )&( Gy( x, y, z ) )&( Gz( x, y, z ) )
 }
 translate< -.5, -.5, -.5 >
#end


 

 