#include "patterns.inc"

camera{ location<0,18,-22> look_at<-.65,0,0> rotate y*-30 angle 40 }

light_source{ <150,200,-100>, 1.3 }

//********************** Background **********************

sky_sphere{ pigment{ strata(4,.5,2) turbulence .5 scale .25 color_map{ [0 rgb<.8 .85 1>][.75 rgb<.1 .3 .7>] } } }

//********************** Table **********************

box{<-8,-3,-8>,<8,-1,8> pigment{rgb 1} normal{ lines(8) rotate y*45 }}


//********************** 9 Items on the Table **********************

box{ <-8,-1,4>, <-4,3,8>
 pigment{
  sine( 1,.2 )
 }
}

superellipsoid{ <.25,.25> scale 2 translate<0,1,6>
 pigment{
  organic(1)
  color_map{ [0 rgb 0][1 rgb<.2 1 .5>] }
 }
 finish{ phong 1 }
}

cone{ <6,-1,6>, 2, <6,3,6>, 1
 pigment{
  strata( 8, 1, .2 )
  color_map{ [0 rgb<.8 .5 .4>][1 rgb<.8 .5 .4>*.7] }
 }
}

superellipsoid{ <.25,.25> scale 2 translate<-6,1,0>
 pigment{ rgb 1 }
 normal{ fabric( 4 ) }
 finish{ phong 1 }
}

superellipsoid{ <.25,.25> scale 2 translate<0,1,0>
 pigment{
  lines( 8 ) rotate<45,45,0>
  color_map{ [.6 rgbf 1][.6 rgb 1] }
 }
 normal{
  lines( 8 ) rotate<45,45,0> bump_size 1
 }
}

sphere{ <6,1,0>,2
 pigment{
  lumps( 2 )
  color_map{ [0 rgb 0][.5 rgb<0 .5 1>][1 rgb 1] }
 }
 finish{ phong 1 }
} 

cylinder{<-6,-1,-6>, <-6,3,-6>, 2
 pigment{
  radsine( 14,.4 )
  translate<-6,1,-6>
  sine_wave
 }
}

superellipsoid{ <1,.25> scale 2 rotate x*90
 pigment{
  spiral3( 7 )
  color_map{ [0 rgb 0][.25 rgb<0 .5 1>][.6 rgb<1 1 0>][1 rgb 1] }
 }
 finish{ specular .2 }
 translate<0,1,-6>
}

box{ <4,-1,-8>, <8,3,-4>
 pigment{
  grid( .1 )
  color_map{ [0 rgb 1][1 rgb<0 .5 1>] }
 }
}