// Persistence of Vision Ray Tracer Scene Description File
// File: Torus.pov
// Vers: 3.1
// Desc: This file demonstrates the use of "SpiralTorus.inc". Read SpiralTorus.inc for details!!!
// Date: 30-1-1999 
// Auth: W. Dijk (Bugs74) wdijk@hotmail.com  

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

light_source {<0.0 , 10.0 , -20.0> color White}

camera {location  <0.0 , 0.0 ,-6.0> look_at  <0.0 , 0.0 , 0.0>}

#declare TestObject1 = 
        union {    
                #declare OuterRadiusX = 2.5 ;
                #declare OuterRadiusY = 2.5 ;
                #declare InnerRadiusX = 0.25 ;
                #declare InnerRadiusY = 0.25 ;
                #declare Revolutions = 50 ;
                #declare LineWidth = 0.1 ;
                #declare Steps = pi/2500 ;
                #declare Start = 0 ;
                #declare End = 2*pi ;
                #include "spiraltorus.inc"
                texture { pigment { Green } finish { Dull } }
              }

#declare TestObject2 = 
        union {    
                #declare OuterRadiusX = 1.5 ;
                #declare OuterRadiusY = 1.5 ;
                #declare InnerRadiusX = 0.1 ;
                #declare InnerRadiusY = 0.1 ;
                #declare Revolutions = 25 ;
                #declare LineWidth = 0.075 ;
                #declare Steps = pi/100 ;
                #declare Start = 0.5*pi ;
                #declare End = 1.5*pi ;
                #include "spiraltorus.inc"
                texture { pigment { Red } finish { Shiny } }
              }
              
#declare TestObject3 = 
        union {    
                #declare OuterRadiusX = 0.75 ;
                #declare OuterRadiusY = 1.5 ;
                #declare InnerRadiusX = 0.1 ;
                #declare InnerRadiusY = 0.25 ;
                #declare Revolutions = 25 ;
                #declare LineWidth = 0.05 ;
                #declare Steps = pi/1000 ;
                #declare Start = 0 ;
                #declare End = 2*pi ;
                #include "spiraltorus.inc"
                texture { DMFWood6 finish { Shiny } }
              }
              
object { TestObject1 }
object { TestObject2 rotate x*45 }
object { TestObject3 rotate x*-45 }