////////////////////////////////////////////////////////////////////////////////////////////                                                         
//                                                                                        //
//      SpiralTorus.inc by: Wouter 'Bugs74' Dijk, 30-1-1999                               //
//                          wdijk@telekabel.nl                                            //          
//                                                                                        //
//      This file creates a torus-like spiral.                                            //
//                                                                                        //
//      Syntax:                                                                           //
//      #declare MyObject =                                                               //
//                        union {                                                         //
//                              #declare OuterRadiusX = 2.5 ;                             //
//                              #declare OuterRadiusY = 2.5 ;                             //
//                              #declare InnerRadiusX = 0.5 ;                             //
//                              #declare InnerRadiusY = 0.5 ;                             //
//                              #declare Revolutions = 10 ;                               //
//                              #declare LineWidth = 0.05 ;                               //
//                              #declare Steps = 0.01 ;                                   //
//                              #declare Start = 0 ;                                      //
//                              #declare End = 2*pi ;                                     //
//                              #include "spiraltorus.inc"                                //
//                              texture { MyTexture }                                     //
//                              }                                                         //
//                                                                                        //
//      object { MyObject }                                                               //
//                                                                                        //
//                                                                                        //
//      OuterRadiusX defines the so-called MajorRadius of X      [2.5]  by default        //
//      OuterRadiusY defines the so-called MajorRadius of Y      [2.5]  by default        //
//      InnerRadiusX defines the so-called MinorRadius of X      [0.25] by default        //
//      InnerRadiusY defines the so-called MinorRadius of Y      [0.25] by default        //
//      Start        defines the starting point of the object    [0] by default           //
//      End          defines the ending point of the object      [2*pi] by default        //
//      Steps        defines the number of steps between the                              //
//                                            calculated points [pi/(pi*100)] by default  //
//      Revolutions  defines the number of revolutions around                             //
//                                      the imaginary torus     [25] by default           //
//      LineWidth    defines the thickness of the line           [0.1] by default         //
//                                                                                        //
//      All variables must be >=0                                                         //
//                                                                                        //
//      Try all different variables, it can get you some real cool shapes!                //
//                                                                                        //
////////////////////////////////////////////////////////////////////////////////////////////  

        
#ifndef (OuterRadiusX)           #declare OuterRadiusX = 2.5 ; #end
#ifndef (OuterRadiusY)           #declare OuterRadiusY = 2.5 ; #end
#ifndef (InnerRadiusX)           #declare InnerRadiusX = 0.25 ; #end
#ifndef (InnerRadiusY)           #declare InnerRadiusY = 0.25 ; #end
#ifndef (Start)                 #declare Start = 0 ; #end
#ifndef (End)                   #declare End = 2*pi ; #end
#ifndef (Steps)                 #declare Steps = pi/(pi*100) ; #end
#ifndef (Revolutions)           #declare Revolutions = 25 ; #end
#ifndef (LineWidth)             #declare LineWidth = 0.1 ; #end

#declare InnerRadius = (InnerRadiusX + InnerRadiusY) / 2 ;

#while ( Start < End )
        #declare U = Revolutions * Start ;
        #declare XTorus = ( OuterRadiusX + InnerRadiusX * cos ( U ) ) * cos ( Start ) ;
        #declare YTorus = ( OuterRadiusY + InnerRadiusY * cos ( U ) ) * sin ( Start ) ;
        #declare ZTorus = InnerRadius * sin ( U ) ;
        sphere { < XTorus , YTorus , ZTorus > ,LineWidth }
        #declare Start = Start + Steps ; 
#end
