// Persistence of Vision Ray Tracer Scene Description File
// File: Arch.pov
// Vers: 3.1
// Desc: Demonstration of the Arch.inc file 
// Date: 8-feb-1999         
// Auth: Wouter Dijk, The Netherlands 

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions 
#include "metals.inc"

light_source {< 10.0 , 10.0 , -20.0> color White}
light_source {<-10.0 , 10.0 , -20.0> color White}

camera {location  <0.0 , 0.0 , -25> look_at   <0.0 , 0.0 , 0.0 >}

#declare Arch =
union  { #declare Start = -0.5*pi;
         #declare AbsoluteEnd = 0.5*pi;
         #declare Segments = 10 ;
         #declare OuterRadiusY = 10 ;
         #declare InnerRadiusY = 9 ;
         #declare OuterRadiusX = 10 ;
         #declare InnerRadiusX = 9 ;
         #include "arch.inc"
         pigment { Gray65 } 
         finish { F_MetalB }
       }

   
object { Arch }
        
