
//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //
//      "Arch.inc"      by Wouter Dijk                                                  //
//                      wdijk@telekabel.nl                                              //
//                      8-feb-1999                                                      //
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
//                                                                                      //        
//      Syntax:                                                                         //
//      #declare MyObject =                                                             //
//                        union {                                                       //
//                              #declare OuterRadiusX = 2.5 ;                           //
//                              #declare OuterRadiusY = 2.5 ;                           //
//                              #declare InnerRadiusX = 0.5 ;                           //
//                              #declare InnerRadiusY = 0.5 ;                           //
//                              #declare Segments = 10 ;                                //
//                              #declare Start = -0.5 * pi                              //
//                              #declare AbsoluteEnd = 0.5 * pi ;                       //
//                              #declare TubeRadius = 0.1 ;                             //
//                              #declare Width = 2 ;                                    //
//                              #include "arch.inc"                                     //
//                              texture { MyTexture }                                   //
//                              }                                                       //
//                                                                                      //
//      object { MyObject }                                                             //
//                                                                                      //
//      You can declare these variables:                                                //
//                                                                                      //
//      Segments        = Number of segments constructed in the Arch, default = 10  (>1)//
//      Start           = Starting point of the Arch, default = -0.5 * pi               //
//      AbsoluteEnd     = The end of the Arch, default = 0.5 * pi                       //
//      InnerRadiusX    = The X-radius of the inner tube, default = 8.0                 //
//      OuterRadiusX    = The X-radius of the two outer tubes, default = 10             //
//      InnerRadiusY    = The Y-radius of the inner tube, default = 8.0                 //
//      OuterRadiusY    = The Y-radius of the two outer tubes, default = 10             //
//      TubeRadius      = The radius of the tubes, default = 0.1                        //
//      Width           = The distance between the two outer tubes, default = 2         //
//                                                                                      //
//      The Arch has no texture, so you have to declare one...                          //
//      See Arch.pov for a sample                                                       //      
//                                                                                      //
//////////////////////////////////////////////////////////////////////////////////////////
       
#ifndef (Segments)              #declare Segments = 10 ;                #end
#ifndef (Start)                 #declare Start = - 0.5 * pi ;           #end
#ifndef (AbsoluteEnd)           #declare AbsoluteEnd = 0.5 * pi ;       #end
#ifndef (InnerRadiusX)          #declare InnerRadiusX = 8.0 ;           #end
#ifndef (OuterRadiusX)          #declare OuterRadiusX = 10 ;            #end 
#ifndef (InnerRadiusY)          #declare InnerRadiusY = 8.0 ;           #end
#ifndef (OuterRadiusY)          #declare OuterRadiusY = 10 ;            #end
#ifndef (TubeRadius)            #declare TubeRadius = 0.1 ;             #end
#ifndef (Width)                 #declare Width = 2 ;                    #end

#declare Count = Start ;
#declare Steps = ( AbsoluteEnd - Start) / Segments ;
#declare Z1 = 0.5 * Width ;
#declare Z2 = -0.5 * Width ;
#declare End = AbsoluteEnd - ( pi / Segments ) ;

//Arch object
union {
#while ( Count <= End )
        #declare X1 = OuterRadiusX * sin ( Count ) ;
        #declare Y1 = OuterRadiusY * cos ( Count ) ;
        
        #declare XX1 = InnerRadiusX * sin ( Count ) ;
        #declare YY1 = InnerRadiusY * cos ( Count ) ;
        
        #declare X2 = OuterRadiusX * sin ( Count + Steps ) ;
        #declare Y2 = OuterRadiusY * cos ( Count + Steps ) ;
        
        #declare XX2 = InnerRadiusX * sin ( Count + Steps ) ;
        #declare YY2 = InnerRadiusY * cos ( Count + Steps ) ;
                
        cylinder { < X1 , Y1 , Z2 > < XX1 , YY1 , 0 > ,TubeRadius }
        cylinder { < X2 , Y2 , Z2 > < XX1 , YY1 , 0 > ,TubeRadius }
        cylinder { < X1 , Y1 , Z2 > < X2 , Y2 , Z2 > ,TubeRadius }
        
        cylinder { < XX1 , YY1 , 0 > < XX2 , YY2 , 0 > ,TubeRadius }

        cylinder { < X1 , Y1 , Z1 > < XX1 , YY1 , 0 > ,TubeRadius }
        cylinder { < X2 , Y2 , Z1 > < XX1 , YY1 , 0 > ,TubeRadius }
        cylinder { < X1 , Y1 , Z1 > < X2 , Y2 , Z1 > ,TubeRadius }
        
        cylinder { < X1 , Y1 , Z1 > < X2 , Y2 , Z2 > ,TubeRadius }
        
        cylinder { < X1 , Y1 , Z1 > < X1 , Y1 , Z2 > ,TubeRadius }
        
        sphere { < X1 , Y1 , Z1 > ,TubeRadius }
        sphere { < X2 , Y2 , Z1 > ,TubeRadius }
        sphere { < X1 , Y1 , Z2 > ,TubeRadius }
        sphere { < X2 , Y2 , Z2 > ,TubeRadius }                
                                
        sphere { < XX1 , YY1 , 0 > ,TubeRadius }
        sphere { < XX2 , YY2 , 0 > ,TubeRadius }
        sphere { < XX1 , YY1 , 0 > ,TubeRadius }
        sphere { < XX2 , YY2 , 0 > ,TubeRadius }                                      
        
        #declare Count = Count + Steps ;
#end                      

        #declare X1 = OuterRadiusX * sin ( AbsoluteEnd ) ;
        #declare Y1 = OuterRadiusY * cos ( AbsoluteEnd ) ;
        
        #declare XX1 = InnerRadiusX * sin ( AbsoluteEnd ) ;
        #declare YY1 = InnerRadiusY * cos ( AbsoluteEnd ) ;
        
cylinder { < X1 , Y1 , Z2 > < XX1 , YY1 , 0 > ,TubeRadius }
cylinder { < X1 , Y1 , Z1 > < X1 , Y1 , Z2 > ,TubeRadius }
cylinder { < X1 , Y1 , Z1 > < XX1 , YY1 , 0 > ,TubeRadius }
}
