/*
And now for something completely useless....
life.inc --> A version of Conway's Life for POV-Ray, makes a "Life"-tower, where objects are placed
             in the "live cells" positions. 
Written By S.R. Hall, of Ground-Net Graphics
version 1.0, Mar, 1999

To use life.inc:

  a.  make the mandatory declare statements, which are:
      
        #declare maxt=[some positive integer here];
        #declare maxi=[some positive integer greater than two, at least 7 recommended];
        #declare maxj=[some positive integer greater than two, at least 7 recommended];
        
        maxt is height (or duration) of "Life"-tower.  Initial state is at the bottom of the tower.
        maxi and maxj are the dimensions of the "Life"-grid at any particular time (height).
        
  b.  choose either the first or second options below:
  
        1.  for a random tower, declare the following:
                #declare seedo=[some random number integer seed];
        2.  for a planned initial grid, declare and initialize a two-dimensional array called init.
            the dimensions must be maxi by maxj (see above).  here is an example, where maxi and maxj
            are equal to 9 and 7 respectively.
             
                  #declare init= array[maxi][maxj]
                  { 
                   {0,0,0,0,0,0,0},
                   {1,1,1,1,1,1,1}, 
                   {1,0,0,0,0,0,1},
                   {1,0,0,1,0,0,1},
                   {1,0,1,1,1,0,1},
                   {1,0,0,1,0,0,1},
                   {1,0,0,0,0,0,1},
                   {1,1,1,1,1,1,1},
                   {0,0,0,0,0,0,0}   
                  }

            keep in mind, for computational simplicity the outside rows and columns assume values of 
            zero for the rest of the tower.  values of 1 mean a live cell (or an object is placed there)
            and values of 0 mean a dead cell (no object).
                

  c.  make the optional declare statements (if you want).

        #declare solid_pigment = pigment(color [Some Color Here])      
        #declare rgb1 = <w,x,y,z>; // a rgbf vector, put your own values in for w,x,y,z 
        #declare rgb2 = <a,b,c,d>; // a rgbf vector, put your own values in for a,b,c,d 
        #declare cell = object {[Your choice of object here]}
        
        if you declare solid_pigment, all the "cell" objects will have the same color.
        if you don't declare solid_pigment or rgb1 and rbg2, the cells will transition
        from red to blue.
        the default for rgb1 is red.
        the default for rgb2 is blue.
        If you declare rgb1 and/or rgb2 (and DON'T declare solid_pigment) the "cells" at the
        bottom will be colored rgb1 and transition smoothly to rgb2.
        the object{cell} is what will be placed in the live cell spots, default is a sphere. 
*/
#ifndef (cell)
  #declare cell = sphere { <0,0,0>,.5 }
#end
#ifndef (solid_pigment)
  #ifndef (rgb1)
    #declare rgb1=<1,0,0,0>;
  #end
  #ifndef (rgb2)
    #declare rgb2=<.3,.3,1,0>;
  #end  
#end
#ifndef (init)
  #declare life=array[maxt][maxi][maxj]
  #declare seeder=seed(seedo);
  #declare loopa=0;
  #while (loopa<maxi)
    #declare loopb=0;
    #while (loopb<maxj)
      #declare state=int(rand(seeder)*2);
      #declare life[0][loopa][loopb]=state;
      #declare loopb=loopb+1;
    #end
    #declare loopa=loopa+1;
  #end
#else
   #declare life=array[maxt][maxi][maxj]
   #declare loopa=0;
   #while (loopa<maxi)
    #declare loopb=0;
    #while (loopb<maxj)
     #declare life[0][loopa][loopb]=init[loopa][loopb];
     #declare loopb=loopb+1;
    #end
    #declare loopa=loopa+1;
   #end  
#end
#declare loopa=1;
#while (loopa<maxt)
 #declare loopb=1;
 #while (loopb<(maxi-1))
  #declare loopc=1;
  #while (loopc<(maxj-1))
   #declare s=life[loopa-1][loopb-1][loopc-1]+life[loopa-1][loopb-1][loopc]+life[loopa-1][loopb-1][loopc+1];
   #declare s=s+life[loopa-1][loopb][loopc-1]+life[loopa-1][loopb][loopc+1]; 
   #declare s=s+life[loopa-1][loopb+1][loopc-1]+life[loopa-1][loopb+1][loopc]+life[loopa-1][loopb+1][loopc+1];
   #if (life[loopa-1][loopb][loopc]=0) 
    #if (s=3)
     #declare life[loopa][loopb][loopc]=1;
    #else
     #declare life[loopa][loopb][loopc]=0; 
    #end
   #else
    #if (s<4)
     #if (s>1)
      #declare life[loopa][loopb][loopc]=1;
     #else
      #declare life[loopa][loopb][loopc]=0;
     #end
    #else
     #declare life[loopa][loopb][loopc]=0;
    #end
   #end
   #declare loopc=loopc+1;
  #end 
  #declare loopb=loopb+1;
 #end
 #declare loopb=0;
 #while (loopb<maxi)
  #declare life[loopa][loopb][0]=0;
  #declare life[loopa][loopb][(maxj-1)]=0;
  #declare loopb=loopb+1;      
 #end
 #declare loopb=0;
 #while (loopb<maxj)
  #declare life[loopa][0][loopb]=0;
  #declare life[loopa][(maxi-1)][loopb]=0;
  #declare loopb=loopb+1;      
 #end 
 #declare loopa=loopa+1;
#end

union
{
#declare loopa=0;
#while (loopa<maxt)
 #declare counter=0;
 #declare loopb=0;
 #while (loopb<maxi)
  #declare loopc=0;
  #while (loopc<maxj)
   #if (life[loopa][loopb][loopc]=1)
    object
     {
      cell
      pigment
        {
         #ifdef (solid_pigment)
           solid_pigment
         #else
           color rgbf ( ( ( ( maxt-loopa )*rgb1 ) + ( loopa*rgb2 ) ) / maxt )
         #end
        }
      translate <loopb,loopa,loopc>
     }
    #declare counter=counter+1;
   #end
   #declare loopc=loopc+1;
  #end 
  #declare loopb=loopb+1;
 #end
 #if (counter=0)
  #declare loopa=maxt;
 #end
 #declare loopa=loopa+1;
#end
}