global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            1000
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

#include "montre.inc"

#declare anti= //   antimatiere pour arrondi des crochets
difference {
                 cylinder { <0,-4,0>,<0,4,0>,18 }
                 torus { 18,1.5 scale <1,2,1> }
bounded_by { box { <-20,-3,-20>,<20,3,20> }}
scale <1,1,2.3> }



camera {
       location <25,30,-32> // <25,30,-32>
       look_at  <0,0,-10> } // <0,0,-10>



light_source { <800,1500,-400> color rgb 1
             area_light <-53.3429, 69.982, 155.747>, <149.799, -59.1266, 77.8734>, 8, 8  adaptive 1
atmosphere off
}

light_source { <-140,150,-80> color rgb <0.6,0.5,0.4>*1.7
      area_light <-42.9371, -5.29165, 65.2181>, <42.4988, 57.057, 32.6091>, 8, 8  adaptive 1
atmosphere off
 }


light_source
{
  <0,-10000,0>             // light's position (translated below)
  color rgb <0.6,0.9,1.5>*2       // light's color
  spotlight               // this kind of light source
  point_at <0, 0, 0>      // direction of spotlight
  radius 0.17                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 0.18               // intensity falloff radius (outer, in degrees)
//scale <1,1,10>
  jitter
}



atmosphere
{
  type 4            // Mie scattering     //4>0.005   3>0.08
  samples 80    // 80     // Number of samples in first distance interval
  distance 200000       // Atmosphere density, similar to fog
  scattering 0.004    // Reflectivity of atmosphere, determines brightness
  aa_level 1        // Level of binary subdivision in case of aa
  aa_threshold 0.001  // Threshold for aa to push in
  jitter 0.5        // Amount of sample jittering
  color rgbt <1,1,1,1>
}



#declare rondeur_gauche=
difference {
torus { 18,1.5 scale <1,2,1> }
plane { x,-11 inverse }
plane { y,0 }
bounded_by { box { <-20,0,-20>,<-11,3,20> }}
}

#declare rondeur_droite=
difference {
torus { 18,1.5 scale <1,2,1> }
plane { x,11 }
plane { y,0 }
box { <14,-1,-2>,<20,4,2> }
bounded_by { box { <11,0,-18>,<20,3,18> }}
}

#declare bloc=
difference {
cylinder { <0,0,0>,<0,3,0>,18 }
cylinder { <0,2.5,0>,<0,4,0>,14 pigment { color rgb 1 }}    //trou blanc pour l'heure
box { -0.5,0.5 scale <1.85,1,1.85> translate <10.4,2.5,0> pigment { color rgb 1 }}
bounded_by { box { <-18,0,-18>,<18,3,18> }}
}




#declare lorus=texture {
pigment { image_map { gif "lorus.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <10,5.74,1>*0.5
rotate x*90
translate z*7 }


#declare sports=texture {
pigment { image_map { gif "sports.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <10,2.5,1>*0.4
rotate x*90
translate z*5 }



#declare quartz=texture {
pigment { image_map { gif "quartz.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <10,2.5,1>*0.35
rotate x*90
translate z*-7.5 }


#declare cinquante=texture {
pigment { image_map { gif "50m.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <12,1.66666,1>*0.7
rotate x*90
translate z*-6 }


#declare trait=texture {
pigment { image_map { gif "trait.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <0.12,1.1,1>
rotate x*90
translate z*12.2
}

#declare cadate=texture {
pigment { image_map { gif "cadate.gif" interpolate 2 once filter 255,1 } }
translate <-0.5,-0.5,0>
scale <2.6,2.6,1>
rotate x*90
translate x*10.4
}


#declare inscriptions=
disc {
    <0,2.50001,0>, <0,1,0>, 14
        texture { lorus }
        texture { sports }
        texture { quartz }
        texture { cinquante }
        texture { cadate }
#declare rot=0
#while(rot<360)
#switch (rot)
#case (90)
#declare rot=rot+360/60
#end
        texture { trait rotate y*rot}
#declare rot=rot+360/60
#end
        }


#declare durdur=
difference {
lathe {
  cubic_spline
 11  // control points
 <17.138216, 0.427365>,
  <18.0, 0.0>,
  <21.327857, 0>,
  <22.522896, -0.851883>,
  <23.172621, -1.92142>,
  <24.6508, -1.817675>,
  <24.281828, -0.451297>,
  <22.972721, 1.481883>,
  <20.347647, 2.841165>,
  <17.580964, 3.0>,
  <17.580964, 3.0>}
plane { y,3 inverse}
plane { x,10  }
object { anti translate x*36 rotate y*25 }
plane { z,-8 inverse }
bounded_by { box { <10,-3,-25>,<17,3,-8> }}
  }


#declare durdur2=
difference {
lathe {
  cubic_spline
 11  // control points
  <17.138216, 0.427365>,
  <18.0, 0.0>,
  <21.327857, 0>,
  <22.522896, -0.851883>,
  <23.172621, -1.92142>,
  <24.6508, -1.817675>,
  <24.281828, -0.451297>,
  <22.972721, 1.481883>,
  <20.347647, 2.841165>,
  <17.580964, 3.0>,
  <17.580964, 3.0>}
plane { y,3 inverse}
plane { x,-10 inverse}
object { anti translate -x*36 rotate y*-25 }
plane { z,-8 inverse }
bounded_by { box { <-17,-3,-25>,<-10,3,-8> }}
  }


#declare arrondi=
difference {
union {
      torus { 2,1 scale <1.5,2.5,2.9> }
      cylinder { <0,-1,0>,<0,1,0>,2 scale <1.5,2.5,2.9> }
      }
box { <-10,-5,-2>,<10,5,2> }
plane { y,0 }
plane { x,0 }
bounded_by { box { <0,0,-9>,<5,2.5,9> }}
translate x*16
 }


#declare base=
union {
      object { durdur }
      object { durdur rotate y*180 }
      object { durdur2 }
      object { durdur2 rotate y*180 }
      object { bloc }
      object { rondeur_gauche }
      object { rondeur_droite }
      object { arrondi }
texture { met }
}

#declare molette=
union {
cylinder { <0,0,0>,<2,0,0>,1.5 }
cylinder { <2,0,0>,<2.1,0,0>,1.4}
torus { 1.4,0.1 sturm rotate z*90 translate <2,0,0> }
sphere { <-5,0,0>,7.23846 clipped_by { plane { x,2.1 inverse }}}
}


#declare boite=
intersection {
box { <0,-1.15,-1.15>,<2,1.15,1.15> }
cone { <0,0,0>,3,<2,0,0>,1.5 }
bounded_by { box { <0,-1.15,-1.15>,<2,1.15,1.15> } }
}



#declare cran=union {
#declare compte=0
#while (compte<360)
object { boite rotate x*compte }
#declare compte=compte+360/18
#end
}


#declare remontoir=union {
object { molette }
object { cran }
cylinder { <-1,0,0>,<1,0,0>,0.05 }
pigment { color rgb <0.65,0.6,0.2> }
finish { specular 0.2 roughness 0.3
        ambient 0.05 brilliance 8
        diffuse 0.8 metallic
        }
translate <18.2,0.2,0>
}


#declare creux=union {
#declare rot=0
#while(rot<360)
difference {
             sphere { <0,0,0>,0.85 scale <1.2,1,1>}
             plane { y,0 }
             bounded_by { sphere { 0,1.1 }}
translate <16.33,1.0,0> rotate y*rot}
#declare rot=rot+360/12
#end
}



#declare cylindre_noir=
cylinder { <0,0,0>,<0,1,0>,0.6
pigment { color rgb <0.05,0.05,0.05> }
finish { phong 0.4 roughness 0.01 }
}


#declare pointe=
difference {
lathe {
  linear_spline
  7  // control points
  <0.0, 0.0>,
  <1.123826, 2.024727>,
  <1.255262, 2.7>,
  <1.028125, 2.7>,
  <0.15  , 2.7>,
  <0.15  , 1.2>,
  <0.0, 1.2>
  scale <1,1,10000>}
//plane { z,0 }
plane { y,-0.01  }
bounded_by { box { <-1.5,0,0>,<1.5,3,0.01> }}
scale <1,1,100>
rotate x*90
translate <0,2,14.3>
pigment { color rgb <0.05,0.05,0.05> }
finish { phong 0.4 roughness 0.01 }
}





#declare ja=
union {
lathe {
  cubic_spline
  6  // control points
  <16.375119, -0.641619>,
  <17.0, 0.0>,
  <16.673812, 1.333236>,
  <15.561641, 1.833044>,
  <14.3, 2.0>,
  <13.9, 2.080317>
scale <0.985,0.97,0.985>
}
difference  {
lathe {
  cubic_spline
  6  // control points
  <16.375119, -0.641619>,
  <17.0, 0.0>,
  <16.673812, 1.333236>,
  <15.561641, 1.833044>,
  <14.0, 2.0>,
  <13.718005, 2.080317> }
object { creux }
bounded_by { box { <-18,0,-18>,<18,2.1,18> }}
}
scale <1.03,1,1.03>
translate y*3
texture { couleur_jaune }
}

#declare jaune=
difference {
           object { ja }
object { cylindre_noir translate <15.1,4.9,0> }
object { cylindre_noir translate <-15.1,4.9,0> }
object { cylindre_noir translate <0,4.9,-15.1> }
object { pointe  translate y*3}
bounded_by { box { <-19,3,-19>,<19,6,19> }}
}


#declare moins=union {
#declare rot=0
#while(rot<360)
prism {
linear_sweep
  cubic_spline
  -0.1,3
  12  // control points
  <-10.97061, 0.0>,
  <-5.895695, -3.867063>,
  <-1.735573, -5.021145>,
  <1.656371, -5.021145>,
  <5.764115, -3.867063>,
  <10.97061, 0.0>,
  <8.479862, 2.515808>,
  <0.0, 1>, // 0,0
  <-8.479862, 2.515808>,
  <-10.97061, 0.0>,
  <-5.895695, -3.867063>,
  <-1.735573, -5.021145>
  scale <0.9,1,1>
  translate z*-15.9
  rotate y*rot }
  #declare rot=rot+360/4
  #end
rotate y*45
  }




#declare brilliant=
union {
cylinder { <0,0.5,0>,<0,5.05,0>,13.99999 open
        texture { met1
        finish { reflection 0.25 brilliance 1 }
        normal { bumps 0 }
        }
        translate y*-2.75}
difference {
lathe {
  cubic_spline
  7  // control points
  <17.856999, -0.844815>,
  <17.804459, 0.018904>,
  <17.721254, 1.583199>,
  <17.347285, 1.947941>,
  <15.924539, 2.259127>,
  <13.330075, 2.3>,
  <12.345893, 2.219365>
  }
cylinder { <0,-0.1,0>,<0,3,0>,14 }
object { moins }
object { cylindre_noir translate <15.1,2,0> }
object { cylindre_noir translate <-15.1,2,0> }
object { cylindre_noir translate <0,2,-15.1> }
object { pointe }
bounded_by { box { <-18,0,-18>,<18,3,18> }}}
texture { met1 } translate y*2.75
}





#declare verre=
merge {
cylinder { <0,-0.8,0>,<0,0,0>,13.6 }
torus { 6.8,0.2 scale <2,1,2> translate y*-0.2 }
cylinder { <0,-0.8,0>,<0,-0.2,0>,14 }
texture { glass }
translate y*5.35
}


#declare plat=
object {
superellipsoid {
<0.1,0.1>}
scale <0.285,0.08,1.155>
texture { sous_phospho }
}


#declare plat3=
object {
superellipsoid {
<0.1,0.1>}
scale <0.285,0.08,0.522>
texture { sous_phospho }
}


#declare elli=
object {
superellipsoid {
<0.1,0.3>}
scale <0.25,0.1,1.1>
texture { phospho }
}

#declare elli3=
object {
superellipsoid {
<0.1,0.3>}
scale <0.25,0.1,0.5>
texture { phospho }
}



#declare point=
union {
      object { elli }
      object { plat }
translate <0,2.5,12>
}


#declare point3=
union {
      object { elli3 }
      object { plat3 }
translate <0,2.5,12>
}


#declare point_de_midi=
intersection {
lathe {
  cubic_spline
  9  // control points
  <0.0, 0.0>,
  <0.0, 0.0>,
  <0.7, 0.4>,
  <0.961718, 0.9>,
  <1.0, 1.6>,
  <1.0, 2.6>,
  <0.805469, 2.956249>,
  <0.0, 3.0>,
  <0.0, 3.0>
  scale <1,1,1000000> }
  plane { z,-0.00001 inverse}
  plane { z, 0.00001 }
bounded_by { box { <-3,0,-0.00001>,<3,3,0.00001> }}
scale <0.8,1,1>
  }

#declare midi=
union {
      object { point_de_midi texture { sous_phospho }}
      object { point_de_midi scale <0.93,0.93,1.2> texture { phospho }translate y*0.07 }
rotate x*90
translate <0,2.501,10.0>
}


#declare point_heure=union {
object { midi }
object { point rotate y*30  }
object { point rotate y*60  }
object { point3 rotate y*90  translate x*0.3 }
object { point rotate y*120 }
object { point rotate y*150 }
object { point rotate y*180 }
object { point rotate y*210 }
object { point rotate y*240 }
object { point rotate y*270 }
object { point rotate y*300 }
object { point rotate y*330 }
}


#declare date=
disc { <0,2.1,0>,<0,1,0>,14
texture {
pigment { image_map { gif "9.gif" interpolate 2 once }
translate <-0.5,-0.5,0> }
scale 1.7 rotate x*90 translate x*10.4 }
}


#include "aiguille.inc"


object { verre translate y*-0.2}
object { base }
object { remontoir }
object { jaune }
object { inscriptions }
object { date }
object { point_heure }
object { brilliant  }
#include "ud.pov"
//plane { y,0 texture { plancher1 } texture { plancher2 } translate y*-5.15 }
object { aiguille_des_secondes rotate y*120 }
object { aiguille_m translate y*3.1 rotate y*75 }
object { aiguille_h translate y*2.8 rotate y*246.25 }
cylinder { <0,2.5,0>,<0,3.5,0>,0.1 texture { sous_phospho }}


plane { z,0 // inverse
pigment { image_map { gif "toit.gif" interpolate 2 } scale 2000 }
finish { ambient 0.7 }
rotate x*90
translate y*1700}

/*
plane { z,0
pigment { image_map { gif "centi.gif" interpolate 2 } scale 10 }
normal { bump_map { tga "rell.tga" interpolate 2 once bump_size 2} translate <-0.5,-0.5,0> scale 36.65 }
finish { brilliance 4 ambient 0.05 phong 1 phong_size 10 }
rotate x*90
}
*/

