/*
camera {
       location <5,25,-42> // <25,30,-32>
       look_at  <0,20,-10> } // <0,0,-10>



light_source { <1000,1500,-1000> color rgb 0.85 }
light_source { <-2000,1500,-1000> color rgb 0.85 }
light_source { <200,500,100> color rgb 0.85 }


#declare phospho=texture { pigment { color rgb <1,0,1> }}
#declare sous_phospho=texture { pigment { color rgb <1,1,0> }}


*/


#declare anti_matiere_des_aiguilles=
intersection {
lathe {
  cubic_spline
  5
  <0.0 , 0.03>,
  <0.0 , 0.03>,
  <0.22, 0.1> ,
  <0   , 0.6> ,
  <0   , 0.8>
  scale <1,1,1000000000>}
plane { z, 0.02 }
plane { z,-0.02 inverse }
bounded_by { box { <-0.25,0,-0.02>,<0.25,1,0.02> }}
}



#declare bas_des_secondes=
intersection {
lathe {
  cubic_spline
  10  // control points
  <0.023234, -5.010561>,
  <0.0, -5.0>,
  <0.298357, -4.979014>,
  <0.35, -4.8>,
  <0.35, -3.65>,
  <0.35, -1.45>,
  <0.291153, -0.843218>,
  <0.197469, -0.491989>,
  <0.079163, -0.096841>,
  <0.0, 0.0> scale <1,1,100000> }
  plane { z, 0.01 }
  plane { z,-0.01 inverse }
  bounded_by { box { <-0.4,-5.2,-0.01>,<0.4,0,0.01> }}
  rotate x*90
  }


#declare centre=
cylinder { <0,-0.01,0>,<0,0.01,0>,0.5 }


#declare tige=
prism {
    linear_sweep
    linear_spline
    0.01,
    0.01,
    5,
    <-0.15,0>,
    <-0.05,7.5>,
    <0.05,7.5>,
    <0.15,0>,
    <-0.15,0>
    }


#declare arrondi_du_haut=
difference {
lathe {
  cubic_spline
  9  // control points
  <0.0, 0.0>,
  <0.0, 0.0>,
  <0.25, 0.1>,
  <0.054953, 0.753024>,
  <0.03, 1.63>,
  <0.03, 2.36>,
  <0.03, 3.6>,
  <0.0, 4.0>,
  <0.0, 4.0>
  scale <1,1,10000000>}
plane { z, 0.01 inverse}
plane { z,-0.01 }
object { anti_matiere_des_aiguilles }
bounded_by { box { <-0.3,0,-0.01>,<0.3,4,0.01> }}
rotate x*90
translate z*7.5
}


#declare aiguille_des_secondes=
union {
      union {
            object { bas_des_secondes }
            object { centre }
            object { tige }
            object { arrondi_du_haut }
            texture { sous_phospho }
            }
object { anti_matiere_des_aiguilles
scale <1,1,0.5>
rotate x*90
translate z*7.5
texture { phospho }
}
translate y*3.4
}


#declare Corps_des_heures=
intersection {
lathe {
  cubic_spline
  8  // control points
  <0.5, -0.5>,
  <0.5, 0.0>,
  <0.534607, 0.908652>,
  <0.8, 1.1>,
  <0.788218, 2.186309>,
  <0.548358, 6.444156>,
  <0.0, 8.0>,
  <0.023147, 5.537055>
  sturm
 }
plane { z,0 }
bounded_by { box { <-1,0,-1>,<1,9,0.1> }}
  }


#declare aiguilles_des_heures=
union {
object { Corps_des_heures }
cylinder { <0,0,-0.5>,<0,0,0>,0.6 }
}


#declare antimatiere_des_heures=
object {
intersection {
object { Corps_des_heures }
cylinder { <0,0,-1>,<0,0,1>,1 scale <2,4,1> translate y*5 }
bounded_by { box { <-1,-1,-1>,<1,9,1> }}
}
scale <0.65,0.8,100>
translate z*0.5
translate y*0.6
}


#declare matiere_des_heures=
difference {
           object { aiguilles_des_heures }
           object { antimatiere_des_heures  }
           bounded_by { box { <-1,-1,-1>,<1,9,0>}}
           }




#declare fluo_des_heures=
union {
intersection {
object { aiguilles_des_heures }
box { <-1,4.8,-1>,<1,5,0> }
bounded_by { box { <-1,4.8,-1>,<1,5,0> } }
}
object { matiere_des_heures  }
texture { sous_phospho }
}



#declare aiguille_h=
union {
object { fluo_des_heures }
intersection {
             object { antimatiere_des_heures }
             plane { z,-0.1 inverse }
             bounded_by { box { <-1,-1,-1>,<1,8,0> } }
texture { phospho }
}
scale <1,1,1/40>
rotate x*90
}


#declare Corps_des_minutes=
intersection {
lathe {
  cubic_spline
  9  // control points
  <0.237839, -0.5>,
  <0.237839, 0.0>,
  <0.290206, 0.923816>,
  <0.5, 1.5>,
  <0.50375, 5.6>,
  <0.473243, 9.138215>,
  <0.343276, 10.850569>,
  <0.0, 11.993846>,
  <0.024573, 9.716869>
  sturm
 }
plane { z,0 }
bounded_by { box { <-0.6,0,-0.6>,<0.6,12,0.1> }}
  }



#declare aiguilles_des_minutes=
union {
object { Corps_des_minutes }
cylinder { <0,0,-0.25>,<0,0,0>,0.5 }
}


#declare antimatiere_des_minutes=
object {
intersection {
object { Corps_des_minutes }
cylinder { <0,0,-1>,<0,0,1>,1 scale <2.75,5.5,1> translate y*6.5 }
bounded_by { box { <-0.6,-1,-0.6>,<0.6,12,0.6> }}
}
scale <0.65,0.8,100>
translate z*0.5
translate y*0.8
}



#declare matiere_des_minutes=
difference {
           object { aiguilles_des_minutes }
           object { antimatiere_des_minutes  }
           bounded_by { box { <-1,-1,-1>,<1,12,0>}}
           }


#declare fluo_des_minutes=
union {
intersection {
object { aiguilles_des_minutes }
box { <-1,7.8,-1>,<1,8,0> }
bounded_by { box { <-1,7.8,-1>,<1,8,0> } }
}
object { matiere_des_minutes  }
texture { sous_phospho }
}


#declare aiguille_m=
union {
object { fluo_des_minutes }
intersection {
             object { antimatiere_des_minutes }
             plane { z,-0.1 inverse }
             bounded_by { box { <-1,-1,-1>,<1,12,0> } }
texture { phospho }
}
scale <1,1,1/40>
rotate x*90
}
