// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "STONES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak
#include "polyhedral.inc"

light_source { <0,100,-100> rgb<1,1,1> }

camera
{
  location  <0.0, 5.0, -10.0>
  look_at   <0.0, 0.0,  0.0>
}

#declare teta=texture{T_Wood9}
#declare tetb=texture{T_Stone25}
#declare tetc=texture{pigment{color Yellow}}

union
{
#declare looper=0;
#while (looper<36)
 #declare arot=90;
 #declare brot=240*(looper/36);
 #declare crot=360*(looper/36);
 object
  {
   polyhedron(6,teta,tetb,tetc,"s",.9)
   scale .75
   rotate <arot,0,0>
   rotate <0,0,brot>
   translate <5,0,0>
   rotate <0,crot,0>
  }
 object
  {
   polyhedron(6,tetc,tetb,tetc,"f",.06)
   scale .75
   rotate <arot,0,0>
   rotate <0,0,brot>
   translate <5,0,0>
   rotate <0,crot,0>
  }  
 #declare looper=looper+1;
#end
}
