/* polyhedral.inc --> A Platonic and Archimedean Solid Include File */
/* Written By S.R. Hall, of Ground-Net Graphics*/
/* version 1.0, Feb, 1999 */

//For instructions on how to use, read "read_this.txt" from the polyhedral.zip archive.

#macro polyhedron(tiipe,tex1,tex2,tex3,verzion,radiuss)

#if (radiuss<=0)
 #error
  "polyhedral.inc error: radiuss must be greater than zero\n"
#end

#if (asc(verzion)=115)
 #render "doing the solid version\n"
#else 
 #if (asc(verzion)=102)
  #render "doing the frame version\n"
 #else 
  #error
   "polyhedral.inc error: invalid verzion typed in, must be 'frame' or 'solid'\n"
 #end
#end   

#switch(tiipe)

#case(1)
//tetrahedron 
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,.612372}
   plane{<0,.068041,-.192450>,.204124 inverse}
   plane{<-.166667,.068041,.096225>,.204124 inverse}
   plane{<.166667,.068041,.096225>,.204124 inverse}
   plane{<0,-.204124,0>,.204124 inverse}   
   
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {<-0.5,-0.204124,-0.288675> < 0.5,-0.204124,-0.288675> radiuss }
     cylinder {<-0.5,-0.204124,-0.288675> < 0.0,-0.204124, 0.577350> radiuss }
     cylinder {< 0.5,-0.204124,-0.288675> < 0.0,-0.204124, 0.577350> radiuss }
     cylinder {<-0.5,-0.204124,-0.288675> < 0.0, 0.612372, 0.000000> radiuss }
     cylinder {< 0.5,-0.204124,-0.288675> < 0.0, 0.612372, 0.000000> radiuss }
     cylinder {< 0.0,-0.204124, 0.577350> < 0.0, 0.612372, 0.000000> radiuss }
     sphere {<-0.5000,-0.204124,-0.288675> radiuss}
     sphere {< 0.5000,-0.204124,-0.288675> radiuss}
     sphere {< 0.0000,-0.204124, 0.577350> radiuss}
     sphere {< 0.0000, 0.612372, 0.000000> radiuss}
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(2)
//hexahedron 
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,.866025}
   plane{<0,0,-.5>,.5 inverse}
   plane{<0,0,.5>,.5 inverse}
   plane{<0,-.5,0>,.5 inverse}
   plane{<0,.5,0>,.5 inverse}   
   plane{<-.5,0,0>,.5 inverse}
   plane{<.5,0,0>,.5 inverse}     

   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {<.5,.5,.5><-.5,.5,.5> radiuss}
     cylinder {<-.5,.5,.5><-.5,-.5,.5> radiuss}
     cylinder {<-.5,-.5,.5><.5,-.5,.5> radiuss}
     cylinder {<.5,-.5,.5><.5,.5,.5> radiuss}
     cylinder {<.5,.5,-.5><-.5,.5,-.5> radiuss}
     cylinder {<-.5,.5,-.5><-.5,-.5,-.5> radiuss}
     cylinder {<-.5,-.5,-.5><.5,-.5,-.5> radiuss}
     cylinder {<.5,-.5,-.5><.5,.5,-.5> radiuss}
     cylinder {<.5,.5,.5><.5,.5,-.5> radiuss}
     cylinder {<-.5,.5,.5><-.5,.5,-.5> radiuss}
     cylinder {<.5,-.5,.5><.5,-.5,-.5> radiuss}
     cylinder {<-.5,-.5,.5><-.5,-.5,-.5> radiuss}                                
     sphere {<.5,.5,.5> radiuss}
     sphere {<-.5,.5,.5> radiuss}  
     sphere {<.5,-.5,.5> radiuss}
     sphere {<-.5,-.5,.5> radiuss}
     sphere {<.5,.5,-.5> radiuss}
     sphere {<-.5,.5,-.5> radiuss}  
     sphere {<.5,-.5,-.5> radiuss}
     sphere {<-.5,-.5,-.5> radiuss}
          
     texture{tex1} 
    }
  #end   
 #end
#break

#case(3)
//octahedron 
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,.707107}
   plane{<.333333,.235702,0>,0.408248 inverse}
   plane{<-.333333,.235702,0>,0.408248 inverse}  
   plane{<0,.235702,.333333>,0.408248 inverse}
   plane{<0,.235702,-.333333>,0.408248 inverse}   
   plane{<.333333,-.235702,0>,0.408248 inverse}
   plane{<-.333333,-.235702,0>,0.408248 inverse}  
   plane{<0,-.235702,.333333>,0.408248 inverse}
   plane{<0,-.235702,-.333333>,0.408248 inverse}     
   
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {<0,.707107,0> <.5,0,.5> radiuss}
     cylinder {<0,.707107,0> <-.5,0,.5> radiuss}   
     cylinder {<0,.707107,0> <.5,0,-.5> radiuss}
     cylinder {<0,.707107,0> <-.5,0,-.5> radiuss} 
     cylinder {<.5,0,.5> <.5,0,-.5> radiuss}
     cylinder {<.5,0,-.5> <-.5,0,-.5> radiuss}
     cylinder {<-.5,0,-.5> <-.5,0,.5> radiuss}
     cylinder {<-.5,0,.5> <.5,0,.5> radiuss}   
     cylinder {<0,-.707107,0> <.5,0,.5> radiuss}
     cylinder {<0,-.707107,0> <-.5,0,.5> radiuss} 
     cylinder {<0,-.707107,0> <.5,0,-.5> radiuss}
     cylinder {<0,-.707107,0> <-.5,0,-.5> radiuss}                      
     sphere {<.5,0,.5> radiuss}
     sphere {<-.5,0,.5> radiuss} 
     sphere {<.5,0,-.5> radiuss}
     sphere {<-.5,0,-.5> radiuss} 
     sphere {<0,.707107,0> radiuss}
     sphere {<0,-.707107,0> radiuss} 
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(4)
//dodecahedron 
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,1.401260}
   plane{<0,1.113517,0>,1.113517 inverse}
   plane{<0,-1.113517,0>,1.113517 inverse}
   plane{<0,.497980,-.995960>,1.113517 inverse}
   plane{<-.947214,.497980,-.307768>,1.113517 inverse}
   plane{<-.585410,.497980,.805749>,1.113517 inverse}   
   plane{<.585410,.497980,.805749>,1.113517 inverse}  
   plane{<.947214,.497980,-.307768>,1.113517 inverse}
   plane{<0,-.497980,.995960>,1.113517 inverse}
   plane{<.947214,-.497980,.307768>,1.113517 inverse}
   plane{<.585410,-.497980,-.805749>,1.113517 inverse}  
   plane{<-.585410,-.497980,-.805749>,1.113517 inverse}  
   plane{<-.947214,-.497980,.307768>,1.113517 inverse}
      
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {<0,1.113517,.850651> <.809017,1.113517,.262866> radiuss }
     cylinder {<.809017,1.113517,.262866> <.5,1.113517,-.688191> radiuss }
     cylinder {<.5,1.113517,-.688191> <-.5,1.113517,-.688191> radiuss }
     cylinder {<-.5,1.113517,-.688191> <-.809017,1.113517,.262866> radiuss }
     cylinder {<-.809017,1.113517,.262866> <0,1.113517,.850651> radiuss }               
     cylinder {<0,1.113517,.850651> <0,.262866,1.376383> radiuss }
     cylinder {<.809017,1.113517,.262866> <1.309018,.262866,.425326> radiuss }
     cylinder {<-.809017,1.113517,.262866> <-1.309018,.262866,.425326> radiuss }
     cylinder {<.5,1.113517,-.688191> <.809017,.262866,-1.113517> radiuss }
     cylinder {<-.5,1.113517,-.688191> <-.809017,.262866,-1.113517> radiuss }               
     cylinder {<0,.262866,1.376383> <.809017,-.262866,1.113517> radiuss}
     cylinder {<.809017,-.262866,1.113517> <1.309018,.262866,.425326> radiuss}
     cylinder {<1.309018,.262866,.425326> <1.309018,-.262866,-.425326> radiuss}
     cylinder {<1.309018,-.262866,-.425326> <.809017,.262866,-1.113517> radiuss}
     cylinder {<.809017,.262866,-1.113517> <0,-.262866,-1.376383> radiuss}
     cylinder {<0,-.262866,-1.376383> <-.809017,.262866,-1.113517> radiuss}
     cylinder {<-.809017,.262866,-1.113517> <-1.309018,-.262866,-.425326> radiuss}
     cylinder {<-1.309018,-.262866,-.425326> <-1.309018,.262866,.425326> radiuss}
     cylinder {<-1.309018,.262866,.425326> <-.809017,-.262866,1.113517> radiuss}
     cylinder {<-.809017,-.262866,1.113517> <0,.262866,1.376383> radiuss}                     
     cylinder {<0,-1.113517,-.850651> <0,-.262866,-1.376383> radiuss }
     cylinder {<-.809017,-1.113517,-.262866> <-1.309018,-.262866,-.425326> radiuss }
     cylinder {<.809017,-1.113517,-.262866> <1.309018,-.262866,-.425326> radiuss }
     cylinder {<-.5,-1.113517,.688191> <-.809017,-.262866,1.113517> radiuss }
     cylinder {<.5,-1.113517,.688191> <.809017,-.262866,1.113517> radiuss }           
     cylinder {<0,-1.113517,-.850651> <-.809017,-1.113517,-.262866> radiuss }
     cylinder {<-.809017,-1.113517,-.262866> <-.5,-1.113517,.688191> radiuss }
     cylinder {<-.5,-1.113517,.688191> <.5,-1.113517,.688191> radiuss }
     cylinder {<.5,-1.113517,.688191> <.809017,-1.113517,-.262866> radiuss }
     cylinder {<.809017,-1.113517,-.262866> <0,-1.113517,-.850651> radiuss }  
     sphere {<0,1.113517,.850651> radiuss}
     sphere {<.809017,1.113517,.262866> radiuss}
     sphere {<.5,1.113517,-.688191> radiuss}
     sphere {<-.5,1.113517,-.688191> radiuss}
     sphere {<-.809017,1.113517,.262866> radiuss}
     sphere {<0,.262866,1.376383> radiuss}
     sphere {<1.309018,.262866,.425326> radiuss}
     sphere {<.809017,.262866,-1.113517> radiuss}
     sphere {<-.809017,.262866,-1.113517> radiuss}
     sphere {<-1.309018,.262866,.425326> radiuss}
     sphere {<0,-.262866,-1.376383> radiuss}
     sphere {<-1.309018,-.262866,-.425326> radiuss}
     sphere {<-.809017,-.262866,1.113517> radiuss}
     sphere {<.809017,-.262866,1.113517> radiuss}
     sphere {<1.309018,-.262866,-.425326> radiuss}                 
     sphere {<0,-1.113517,-.850651> radiuss}
     sphere {<-.809017,-1.113517,-.262866> radiuss}
     sphere {<-.5,-1.113517,.688191> radiuss}
     sphere {<.5,-1.113517,.688191> radiuss}
     sphere {<.809017,-1.113517,-.262866> radiuss}  


     texture{tex1} 
    }
  #end   
 #end
#break

#case(5)
//icosahedron 
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,.951057}
   #declare loop=0;
   #declare plane_rotate=72;
   #declare top_vector=<0,0.600570,-0.458794>;
   #declare mid_vector=<0,0.141775,-.742344>;
   #while (loop<5)
    plane{top_vector,0.755762 inverse rotate <0,plane_rotate*loop,0>}     
    plane{top_vector,0.755762 inverse rotate <0,plane_rotate*loop,0> scale -1}
    plane{mid_vector,0.755762 inverse rotate <0,plane_rotate*loop,0>}     
    plane{mid_vector,0.755762 inverse rotate <0,plane_rotate*loop,0> scale -1}       
   #declare loop=loop+1;
   #end
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {<0,.951057,0> <0,.425326,.850651> radiuss }
     cylinder {<0,.951057,0> <.809017,.425326,.262866> radiuss }
     cylinder {<0,.951057,0> <.5,.425326,-.688191> radiuss }
     cylinder {<0,.951057,0> <-.5,.425326,-.688191> radiuss }
     cylinder {<0,.951057,0> <-.809017,.425326,.262866> radiuss }        
     cylinder {<-.809017,.425326,.262866> <0,.425326,.850651> radiuss }
     cylinder {<0,.425326,.850651> <.809017,.425326,.262866> radiuss }
     cylinder {<.809017,.425326,.262866> <.5,.425326,-.688191> radiuss }
     cylinder {<.5,.425326,-.688191> <-.5,.425326,-.688191> radiuss }
     cylinder {<-.5,.425326,-.688191> <-.809017,.425326,.262866> radiuss }   
     cylinder {<0,.425326,.850651> <.5,-.425326,.688191> radiuss }
     cylinder {<.809017,.425326,.262866> <.809017,-.425326,-.262866> radiuss }
     cylinder {<.5,.425326,-.688191> <0,-.425326,-.850651> radiuss }
     cylinder {<-.5,.425326,-.688191> <-.809017,-.425326,-.262866> radiuss }
     cylinder {<-.809017,.425326,.262866> <-.5,-.425326,.688191> radiuss }
     cylinder {<0,.425326,.850651> <-.5,-.425326,.688191> radiuss }
     cylinder {<.809017,.425326,.262866> <.5,-.425326,.688191> radiuss }
     cylinder {<.5,.425326,-.688191> <.809017,-.425326,-.262866> radiuss }
     cylinder {<-.5,.425326,-.688191> <0,-.425326,-.850651> radiuss }
     cylinder {<-.809017,.425326,.262866> <-.809017,-.425326,-.262866> radiuss }              
     cylinder {<-.809017,-.425326,-.262866> <0,-.425326,-.850651> radiuss }
     cylinder {<0,-.425326,-.850651> <.809017,-.425326,-.262866> radiuss }
     cylinder {<.809017,-.425326,-.262866> <.5,-.425326,.688191> radiuss }
     cylinder {<.5,-.425326,.688191> <-.5,-.425326,.688191> radiuss }
     cylinder {<-.5,-.425326,.688191> <-.809017,-.425326,-.262866> radiuss }  
     cylinder {<0,-.951057,0> <0,-.425326,-.850651> radiuss }
     cylinder {<0,-.951057,0> <-.809017,-.425326,-.262866> radiuss }
     cylinder {<0,-.951057,0> <-.5,-.425326,.688191> radiuss }
     cylinder {<0,-.951057,0> <.5,-.425326,.688191> radiuss }
     cylinder {<0,-.951057,0> <.809017,-.425326,-.262866> radiuss } 
     sphere {<0,.951057,0> radiuss}
     sphere {<0,.425326,.850651> radiuss}
     sphere {<.809017,.425326,.262866> radiuss}
     sphere {<.5,.425326,-.688191> radiuss}
     sphere {<-.5,.425326,-.688191> radiuss}
     sphere {<-.809017,.425326,.262866> radiuss}          
     sphere {<0,-.951057,0> radiuss}
     sphere {<0,-.425326,-.850651> radiuss}
     sphere {<-.809017,-.425326,-.262866> radiuss}
     sphere {<-.5,-.425326,.688191> radiuss}
     sphere {<.5,-.425326,.688191> radiuss}
     sphere {<.809017,-.425326,-.262866> radiuss} 
   
     texture{tex1} 
    }
  #end   
 #end
#break

#case(6)
//truncated tetrahedron 
 #declare tta=1.020621;
 #declare ttb=.204124; 
 #declare ttc=-.612372; 
 #declare tt1=<-.5,tta,-.288675>;
 #declare tt2=<0,tta,.577350>;
 #declare tt3=<.5,tta,-.288675>;
 #declare tt4=<-1,ttb,-.577350>;
 #declare tt5=<0,ttb,1.154701>;
 #declare tt6=<1,ttb,-.577350>;
 #declare tt7=<-.5,ttc,-.866025>;
 #declare tt8=<-1,ttc,0>;
 #declare tt9=<-.5,ttc,.866025>;
 #declare tt10=<.5,ttc,.866025>;
 #declare tt11=<1,ttc,0>;
 #declare tt12=<.5,ttc,-.866025>;           
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,1.172604}
   plane{((tt1+tt2+tt3)/3) tta inverse texture{tex1}}
   plane{((tt4+tt7+tt8)/3) tta inverse texture{tex1}}
   plane{((tt5+tt9+tt10)/3) tta inverse texture{tex1}}
   plane{((tt6+tt11+tt12)/3) tta inverse texture{tex1}}         
   plane{((tt1+tt2+tt4+tt5+tt8+tt9)/3) (-1*ttc) inverse texture{tex2}}   
   plane{((tt2+tt3+tt5+tt6+tt10+tt11)/3) (-1*ttc) inverse texture{tex2}}
   plane{((tt1+tt3+tt4+tt6+tt7+tt12)/3) (-1*ttc) inverse texture{tex2}}
   plane{((tt7+tt8+tt9+tt10+tt11+tt12)/3) (-1*ttc) inverse texture{tex2}}      

   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {tt1 tt2 radiuss }
     cylinder {tt2 tt3 radiuss }
     cylinder {tt3 tt1 radiuss }
     cylinder {tt1 tt4 radiuss }
     cylinder {tt2 tt5 radiuss }
     cylinder {tt3 tt6 radiuss }
     cylinder {tt4 tt7 radiuss }
     cylinder {tt4 tt8 radiuss }
     cylinder {tt5 tt9 radiuss }
     cylinder {tt5 tt10 radiuss }
     cylinder {tt6 tt11 radiuss }
     cylinder {tt6 tt12 radiuss }
     cylinder {tt7 tt8 radiuss }
     cylinder {tt8 tt9 radiuss }
     cylinder {tt9 tt10 radiuss }
     cylinder {tt10 tt11 radiuss }
     cylinder {tt11 tt12 radiuss }
     cylinder {tt12 tt7 radiuss }                             
     sphere {tt1 radiuss}
     sphere {tt2 radiuss}
     sphere {tt3 radiuss}
     sphere {tt4 radiuss}
     sphere {tt5 radiuss}
     sphere {tt6 radiuss}
     sphere {tt7 radiuss}
     sphere {tt8 radiuss}
     sphere {tt9 radiuss}
     sphere {tt10 radiuss}
     sphere {tt11 radiuss}
     sphere {tt12 radiuss}              
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(7)
//cuboctahedron 
 #declare co=.707107;
 #declare coa=.816497;          
 #declare co1=<-1*co,co,0>;
 #declare co2=<0,co,-1*co>;
 #declare co3=<co,co,0>;
 #declare co4=<0,co,co>;
 #declare co5=<-1*co,0,-1*co>;
 #declare co6=<co,0,-1*co>;
 #declare co7=<co,0,co>;
 #declare co8=<-1*co,0,co>;
 #declare co9=<-1*co,-1*co,0>;
 #declare co10=<0,-1*co,-1*co>;
 #declare co11=<co,-1*co,0>;
 #declare co12=<0,-1*co,co>;           
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>,1}
   plane{<1,0,0>, co inverse texture{tex1}}
   plane{<-1,0,0>, co inverse texture{tex1}}
   plane{<0,1,0>, co inverse texture{tex1}}
   plane{<0,-1,0>, co inverse texture{tex1}}
   plane{<0,0,1>, co inverse texture{tex1}}
   plane{<0,0,-1>, co inverse texture{tex1}}                 
   plane{<1,1,1>, coa inverse texture{tex2}}
   plane{<1,-1,1>, coa inverse texture{tex2}}
   plane{<-1,1,1>, coa inverse texture{tex2}}
   plane{<-1,-1,1>, coa inverse texture{tex2}}
   plane{<1,1,-1>, coa inverse texture{tex2}}
   plane{<1,-1,-1>, coa inverse texture{tex2}}
   plane{<-1,1,-1>, coa inverse texture{tex2}}
   plane{<-1,-1,-1>, coa inverse texture{tex2}}  
                              
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {co1 co2 radiuss }
     cylinder {co2 co3 radiuss }
     cylinder {co3 co4 radiuss }
     cylinder {co4 co1 radiuss }
     cylinder {co1 co8 radiuss }
     cylinder {co1 co5 radiuss }
     cylinder {co2 co5 radiuss }
     cylinder {co2 co6 radiuss }
     cylinder {co3 co6 radiuss }
     cylinder {co3 co7 radiuss }
     cylinder {co4 co7 radiuss }
     cylinder {co4 co8 radiuss }
     cylinder {co9 co8 radiuss }
     cylinder {co9 co5 radiuss }
     cylinder {co10 co5 radiuss }
     cylinder {co10 co6 radiuss }
     cylinder {co11 co6 radiuss }
     cylinder {co11 co7 radiuss }
     cylinder {co12 co7 radiuss }
     cylinder {co12 co8 radiuss }
     cylinder {co9 co10 radiuss }
     cylinder {co10 co11 radiuss }
     cylinder {co11 co12 radiuss }
     cylinder {co12 co9 radiuss }                               
     sphere {co1 radiuss}
     sphere {co2 radiuss}
     sphere {co3 radiuss}
     sphere {co4 radiuss}
     sphere {co5 radiuss}
     sphere {co6 radiuss}
     sphere {co7 radiuss}
     sphere {co8 radiuss}
     sphere {co9 radiuss}
     sphere {co10 radiuss}
     sphere {co11 radiuss}
     sphere {co12 radiuss}     

     texture{tex1} 
    }
  #end   
 #end
#break

#case(8)
//truncated octahedron
 #declare toa=1.414214;
 #declare tob=.707107;
 #declare toc=1.224745;  
 #declare to1=<-.5,toa,-.5>;
 #declare to2=<.5,toa,-.5>;
 #declare to3=<.5,toa,.5>;
 #declare to4=<-.5,toa,.5>;
 #declare to5=<-1,tob,-1>;
 #declare to6=<1,tob,-1>;
 #declare to7=<1,tob,1>;
 #declare to8=<-1,tob,1>;
 #declare to9=<-1.5,0,-.5>;
 #declare to10=<-.5,0,-1.5>;
 #declare to11=<.5,0,-1.5>;
 #declare to12=<1.5,0,-.5>;
 #declare to13=<1.5,0,.5>;
 #declare to14=<.5,0,1.5>;
 #declare to15=<-.5,0,1.5>;
 #declare to16=<-1.5,0,.5>;
 #declare to17=<-1,-1*tob,-1>;
 #declare to18=<1,-1*tob,-1>;
 #declare to19=<1,-1*tob,1>;
 #declare to20=<-1,-1*tob,1>;
 #declare to21=<-.5,-1*toa,-.5>;
 #declare to22=<.5,-1*toa,-.5>;
 #declare to23=<.5,-1*toa,.5>;
 #declare to24=<-.5,-1*toa,.5>;
 #declare tov1=<1,tob,0>;
 #declare tov2=<1,-1*tob,0>;           
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, 1.581139}
   plane{<0,1,0>, toa inverse texture{tex1}}
   plane{<1,0,1>, toa inverse texture{tex1}}
   plane{<1,0,-1>, toa inverse texture{tex1}}
   plane{<-1,0,1>, toa inverse texture{tex1}}
   plane{<-1,0,-1>, toa inverse texture{tex1}}
   plane{<0,-1,0>, toa inverse texture{tex1}}               
   #declare loop=0;
   #while (loop<4)
   plane{tov1, toc inverse texture{tex2} rotate<0,loop*90,0>}
   plane{tov2, toc inverse texture{tex2} rotate<0,loop*90,0>}
   #declare loop=loop+1;
   #end
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {to1 to2 radiuss }
     cylinder {to2 to3 radiuss }
     cylinder {to3 to4 radiuss }
     cylinder {to4 to1 radiuss }              
     cylinder {to1 to5 radiuss }
     cylinder {to2 to6 radiuss }
     cylinder {to3 to7 radiuss }
     cylinder {to4 to8 radiuss }
     cylinder {to5 to9 radiuss }
     cylinder {to5 to10 radiuss }              
     cylinder {to6 to11 radiuss }
     cylinder {to6 to12 radiuss }
     cylinder {to7 to13 radiuss }
     cylinder {to7 to14 radiuss }
     cylinder {to8 to15 radiuss }
     cylinder {to8 to16 radiuss }              
     cylinder {to10 to11 radiuss }
     cylinder {to12 to13 radiuss }
     cylinder {to14 to15 radiuss }
     cylinder {to16 to9 radiuss }
     cylinder {to17 to9 radiuss }
     cylinder {to17 to10 radiuss }
     cylinder {to18 to11 radiuss }
     cylinder {to18 to12 radiuss }
     cylinder {to19 to13 radiuss }
     cylinder {to19 to14 radiuss }              
     cylinder {to20 to15 radiuss }
     cylinder {to20 to16 radiuss }
     cylinder {to17 to21 radiuss }
     cylinder {to18 to22 radiuss }
     cylinder {to19 to23 radiuss }
     cylinder {to20 to24 radiuss }              
     cylinder {to21 to22 radiuss }
     cylinder {to22 to23 radiuss }              
     cylinder {to23 to24 radiuss }
     cylinder {to24 to21 radiuss }                                   
     sphere {to1 radiuss}
     sphere {to2 radiuss}
     sphere {to3 radiuss}
     sphere {to4 radiuss}
     sphere {to5 radiuss}
     sphere {to6 radiuss}
     sphere {to7 radiuss}
     sphere {to8 radiuss}
     sphere {to9 radiuss}
     sphere {to10 radiuss}
     sphere {to11 radiuss}
     sphere {to12 radiuss}
     sphere {to13 radiuss}
     sphere {to14 radiuss}
     sphere {to15 radiuss}
     sphere {to16 radiuss}
     sphere {to17 radiuss}
     sphere {to18 radiuss}
     sphere {to19 radiuss}
     sphere {to20 radiuss}
     sphere {to21 radiuss}
     sphere {to22 radiuss}
     sphere {to23 radiuss}
     sphere {to24 radiuss}                                      
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(9)
//truncated hexahedron (cube) 
 #declare tha=1.207107;
 #declare thb=1.682522; 
 #declare th1=<-.5,tha,tha>;
 #declare th2=<.5,tha,tha>; 
 #declare th3=<tha,tha,.5>;
 #declare th4=<tha,tha,-.5>;
 #declare th5=<.5,tha,-1*tha>;
 #declare th6=<-.5,tha,-1*tha>;
 #declare th7=<-1*tha,tha,-.5>;
 #declare th8=<-1*tha,tha,.5>; 
 #declare th9=<-1*tha,.5,tha>;
 #declare th10=<tha,.5,tha>;
 #declare th11=<tha,.5,-1*tha>;
 #declare th12=<-1*tha,.5,-1*tha>;
 #declare th13=<-1*tha,-.5,tha>;
 #declare th14=<tha,-.5,tha>; 
 #declare th15=<tha,-.5,-1*tha>;
 #declare th16=<-1*tha,-.5,-1*tha>;
 #declare th17=<-.5,-1*tha,tha>;
 #declare th18=<.5,-1*tha,tha>; 
 #declare th19=<tha,-1*tha,.5>;
 #declare th20=<tha,-1*tha,-.5>;
 #declare th21=<.5,-1*tha,-1*tha>;
 #declare th22=<-.5,-1*tha,-1*tha>;
 #declare th23=<-1*tha,-1*tha,-.5>;
 #declare th24=<-1*tha,-1*tha,.5>;        
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, 1.778824}
   plane{<0,1,0>, tha inverse texture{tex1}}
   plane{<0,-1,0>, tha inverse texture{tex1}}   
   #declare loop=0;
   #while (loop<4)
   plane{<-1,0,0>, tha inverse texture{tex1} rotate<0,loop*90,0>}
   plane{<1,1,1>, thb inverse texture{tex2} rotate<0,loop*90,0>}
   plane{<1,-1,1>, thb inverse texture{tex2} rotate<0,loop*90,0>}   
   #declare loop=loop+1;
   #end
   
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {th1 th2 radiuss }
     cylinder {th2 th3 radiuss }
     cylinder {th3 th4 radiuss }
     cylinder {th4 th5 radiuss }
     cylinder {th5 th6 radiuss }
     cylinder {th6 th7 radiuss }
     cylinder {th7 th8 radiuss }
     cylinder {th8 th1 radiuss }
     cylinder {th1 th9 radiuss }
     cylinder {th2 th10 radiuss }
     cylinder {th3 th10 radiuss }
     cylinder {th4 th11 radiuss }
     cylinder {th5 th11 radiuss }
     cylinder {th6 th12 radiuss }
     cylinder {th7 th12 radiuss }
     cylinder {th8 th9 radiuss }
     cylinder {th9 th13 radiuss }
     cylinder {th10 th14 radiuss }
     cylinder {th11 th15 radiuss }
     cylinder {th12 th16 radiuss }
     cylinder {th13 th24 radiuss }
     cylinder {th13 th17 radiuss }
     cylinder {th14 th18 radiuss }
     cylinder {th14 th19 radiuss }
     cylinder {th15 th20 radiuss }
     cylinder {th15 th21 radiuss }
     cylinder {th16 th22 radiuss }
     cylinder {th16 th23 radiuss }
     cylinder {th17 th18 radiuss }
     cylinder {th18 th19 radiuss }
     cylinder {th19 th20 radiuss }
     cylinder {th20 th21 radiuss }
     cylinder {th21 th22 radiuss }
     cylinder {th22 th23 radiuss }
     cylinder {th23 th24 radiuss }
     cylinder {th24 th17 radiuss }                                       
     sphere {th1 radiuss}
     sphere {th2 radiuss}
     sphere {th3 radiuss}
     sphere {th4 radiuss}
     sphere {th5 radiuss}
     sphere {th6 radiuss}
     sphere {th7 radiuss}
     sphere {th8 radiuss}
     sphere {th9 radiuss}
     sphere {th10 radiuss}
     sphere {th11 radiuss}
     sphere {th12 radiuss}
     sphere {th13 radiuss}
     sphere {th14 radiuss}
     sphere {th15 radiuss}
     sphere {th16 radiuss}
     sphere {th17 radiuss}
     sphere {th18 radiuss}
     sphere {th19 radiuss}
     sphere {th20 radiuss}
     sphere {th21 radiuss}
     sphere {th22 radiuss}
     sphere {th23 radiuss}
     sphere {th24 radiuss}                         
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(10)
//rhombicuboctahedron
 #declare rha=1.207107; 
 #declare rhb=1.274274;
 #declare rh1=<.5,rha,.5>;
 #declare rh2=<.5,rha,-.5>;
 #declare rh3=<-.5,rha,-.5>;
 #declare rh4=<-.5,rha,.5>;
 #declare rh5=<rha,.5,.5>;
 #declare rh6=<rha,.5,-.5>;
 #declare rh7=<.5,.5,-1*rha>;
 #declare rh8=<-.5,.5,-1*rha>;
 #declare rh9=<-1*rha,.5,-.5>;
 #declare rh10=<-1*rha,.5,.5>;
 #declare rh11=<-.5,.5,rha>;
 #declare rh12=<.5,.5,rha>;
 #declare rh13=<rha,-.5,.5>;
 #declare rh14=<rha,-.5,-.5>;
 #declare rh15=<.5,-.5,-1*rha>;
 #declare rh16=<-.5,-.5,-1*rha>;
 #declare rh17=<-1*rha,-.5,-.5>;
 #declare rh18=<-1*rha,-.5,.5>;
 #declare rh19=<-.5,-.5,rha>;
 #declare rh20=<.5,-.5,rha>;
 #declare rh21=<.5,-1*rha,.5>;
 #declare rh22=<.5,-1*rha,-.5>;
 #declare rh23=<-.5,-1*rha,-.5>;
 #declare rh24=<-.5,-1*rha,.5>;        
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>,1.398966}
   plane{<0,1,0>, rha inverse texture{tex1}}
   plane{<0,-1,0>, rha inverse texture{tex1}}
   #declare loop=0;
   #while (loop<4)
   plane{<0,1,1>, rha inverse texture{tex1} rotate<0,loop*90,0>}   
   plane{<0,0,1>, rha inverse texture{tex1} rotate<0,loop*90,0>}   
   plane{<0,-1,1>, rha inverse texture{tex1} rotate<0,loop*90,0>}   
   plane{<1,0,1>, rha inverse texture{tex1} rotate<0,loop*90,0>}         
   plane{<1,1,1>, rhb inverse texture{tex2} rotate<0,loop*90,0>}
   plane{<1,-1,1>, rhb inverse texture{tex2} rotate<0,loop*90,0>}   
   #declare loop=loop+1;
   #end
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {rh1 rh2 radiuss }
     cylinder {rh2 rh3 radiuss }     
     cylinder {rh3 rh4 radiuss }
     cylinder {rh4 rh1 radiuss }
     cylinder {rh1 rh12 radiuss }
     cylinder {rh1 rh5 radiuss }
     cylinder {rh2 rh6 radiuss }
     cylinder {rh2 rh7 radiuss }     
     cylinder {rh3 rh8 radiuss }
     cylinder {rh3 rh9 radiuss }
     cylinder {rh4 rh10 radiuss }
     cylinder {rh4 rh11 radiuss }
     cylinder {rh5 rh6 radiuss }
     cylinder {rh6 rh7 radiuss }     
     cylinder {rh7 rh8 radiuss }
     cylinder {rh8 rh9 radiuss }
     cylinder {rh9 rh10 radiuss }
     cylinder {rh10 rh11 radiuss }
     cylinder {rh11 rh12 radiuss }
     cylinder {rh12 rh5 radiuss }     
     cylinder {rh5 rh13 radiuss }
     cylinder {rh6 rh14 radiuss }
     cylinder {rh7 rh15 radiuss }
     cylinder {rh8 rh16 radiuss }
     cylinder {rh9 rh17 radiuss }
     cylinder {rh10 rh18 radiuss }     
     cylinder {rh11 rh19 radiuss }
     cylinder {rh12 rh20 radiuss }
     cylinder {rh13 rh14 radiuss }
     cylinder {rh14 rh15 radiuss }
     cylinder {rh15 rh16 radiuss }
     cylinder {rh16 rh17 radiuss }     
     cylinder {rh17 rh18 radiuss }
     cylinder {rh18 rh19 radiuss }
     cylinder {rh19 rh20 radiuss }
     cylinder {rh20 rh13 radiuss }
     cylinder {rh13 rh21 radiuss }
     cylinder {rh14 rh22 radiuss }     
     cylinder {rh15 rh22 radiuss }
     cylinder {rh16 rh23 radiuss }
     cylinder {rh17 rh23 radiuss }
     cylinder {rh18 rh24 radiuss }
     cylinder {rh19 rh24 radiuss }
     cylinder {rh20 rh21 radiuss }     
     cylinder {rh21 rh22 radiuss }
     cylinder {rh22 rh23 radiuss }
     cylinder {rh23 rh24 radiuss }
     cylinder {rh24 rh21 radiuss }                              

     sphere {rh1 radiuss}      
     sphere {rh2 radiuss}
     sphere {rh3 radiuss}
     sphere {rh4 radiuss}
     sphere {rh5 radiuss}
     sphere {rh6 radiuss}
     sphere {rh7 radiuss}      
     sphere {rh8 radiuss}
     sphere {rh9 radiuss}
     sphere {rh10 radiuss}
     sphere {rh11 radiuss}
     sphere {rh12 radiuss}
     sphere {rh13 radiuss}      
     sphere {rh14 radiuss}
     sphere {rh15 radiuss}
     sphere {rh16 radiuss}
     sphere {rh17 radiuss}
     sphere {rh18 radiuss}
     sphere {rh19 radiuss}      
     sphere {rh20 radiuss}
     sphere {rh21 radiuss}
     sphere {rh22 radiuss}
     sphere {rh23 radiuss}
     sphere {rh24 radiuss}                                        
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(11)
// truncated rhombicuboctahedron
 #declare tra=1.914214;
 #declare trb=1.207107;
 #declare trc=2.207107;
 #declare trd=2.090770; 
 #declare tre=<0,1,1>;
 #declare trf=<1,1,1>;
 #declare trg=<0,0,1>;
 #declare trh=<1,0,1>;
 #declare tri=<1,-1,1>;
 #declare trj=<0,-1,1>;
 #declare tr1=<.5,tra,trb>;
 #declare tr2=<trb,tra,.5>;
 #declare tr3=<trb,tra,-.5>;
 #declare tr4=<.5,tra,-1*trb>;
 #declare tr5=<-.5,tra,-1*trb>;
 #declare tr6=<-1*trb,tra,-.5>;
 #declare tr7=<-1*trb,tra,.5>;
 #declare tr8=<-.5,tra,trb>;
 #declare tr9=<.5,trb,tra>;
 #declare tr10=<tra,trb,.5>;
 #declare tr11=<tra,trb,-.5>;
 #declare tr12=<.5,trb,-tra>;
 #declare tr13=<-.5,trb,-tra>;
 #declare tr14=<-1*tra,trb,-.5>;
 #declare tr15=<-1*tra,trb,.5>;
 #declare tr16=<-.5,trb,tra>;
 #declare tr17=<trb,.5,tra>;
 #declare tr18=<tra,.5,trb>;
 #declare tr19=<tra,.5,-1*trb>;
 #declare tr20=<trb,.5,-1*tra>;
 #declare tr21=<-1*trb,.5,-1*tra>;
 #declare tr22=<-1*tra,.5,-1*trb>;
 #declare tr23=<-1*tra,.5,trb>;
 #declare tr24=<-1*trb,.5,tra>;
 #declare tr25=<trb,-.5,tra>;
 #declare tr26=<tra,-.5,trb>;
 #declare tr27=<tra,-.5,-1*trb>;
 #declare tr28=<trb,-.5,-1*tra>;
 #declare tr29=<-1*trb,-.5,-1*tra>;
 #declare tr30=<-1*tra,-.5,-1*trb>;
 #declare tr31=<-1*tra,-.5,trb>;
 #declare tr32=<-1*trb,-.5,tra>;
 #declare tr33=<.5,-1*trb,tra>;
 #declare tr34=<tra,-1*trb,.5>;
 #declare tr35=<tra,-1*trb,-.5>;
 #declare tr36=<.5,-1*trb,-1*tra>;
 #declare tr37=<-.5,-1*trb,-1*tra>;
 #declare tr38=<-1*tra,-1*trb,-.5>;
 #declare tr39=<-1*tra,-1*trb,.5>;
 #declare tr40=<-.5,-1*trb,tra>;
 #declare tr41=<.5,-1*tra,trb>;
 #declare tr42=<trb,-1*tra,.5>;
 #declare tr43=<trb,-1*tra,-.5>;
 #declare tr44=<.5,-1*tra,-1*trb>;
 #declare tr45=<-.5,-1*tra,-1*trb>;
 #declare tr46=<-1*trb,-1*tra,-.5>;
 #declare tr47=<-1*trb,-1*tra,.5>;
 #declare tr48=<-.5,-1*tra,trb>;       
             
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>,2.474130}
   plane{<0,1,0>, tra inverse texture{tex1}}
   plane{<0,-1,0>, tra inverse texture{tex1}}
   #declare loop=0;
   #while (loop<4)
   plane{tre, trc inverse texture{tex2} rotate <0,loop*90,0>}
   plane{trf, trd inverse texture{tex3} rotate <0,loop*90,0>}
   plane{trg, tra inverse texture{tex1} rotate <0,loop*90,0>}
   plane{trh, trc inverse texture{tex2} rotate <0,loop*90,0>}
   plane{tri, trd inverse texture{tex3} rotate <0,loop*90,0>}
   plane{trj, trc inverse texture{tex2} rotate <0,loop*90,0>}                  
   #declare loop=loop+1;
   #end
   
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {tr1 tr2 radiuss }
     cylinder {tr2 tr3 radiuss }
     cylinder {tr3 tr4 radiuss }
     cylinder {tr4 tr5 radiuss }
     cylinder {tr5 tr6 radiuss }
     cylinder {tr6 tr7 radiuss }
     cylinder {tr7 tr8 radiuss }
     cylinder {tr8 tr1 radiuss }
     cylinder {tr1 tr9 radiuss }
     cylinder {tr2 tr10 radiuss }
     cylinder {tr3 tr11 radiuss }
     cylinder {tr4 tr12 radiuss }
     cylinder {tr5 tr13 radiuss }
     cylinder {tr6 tr14 radiuss }
     cylinder {tr7 tr15 radiuss }
     cylinder {tr8 tr16 radiuss }
     cylinder {tr16 tr9 radiuss }
     cylinder {tr10 tr11 radiuss }
     cylinder {tr12 tr13 radiuss }
     cylinder {tr14 tr15 radiuss }
     cylinder {tr9 tr17 radiuss }
     cylinder {tr10 tr18 radiuss }
     cylinder {tr11 tr19 radiuss }
     cylinder {tr12 tr20 radiuss }
     cylinder {tr13 tr21 radiuss }
     cylinder {tr14 tr22 radiuss }
     cylinder {tr15 tr23 radiuss }
     cylinder {tr16 tr24 radiuss }
     cylinder {tr17 tr18 radiuss }
     cylinder {tr19 tr20 radiuss }
     cylinder {tr21 tr22 radiuss }
     cylinder {tr23 tr24 radiuss }
     cylinder {tr17 tr25 radiuss }
     cylinder {tr18 tr26 radiuss }
     cylinder {tr19 tr27 radiuss }
     cylinder {tr20 tr28 radiuss }
     cylinder {tr21 tr29 radiuss }
     cylinder {tr22 tr30 radiuss }
     cylinder {tr23 tr31 radiuss }
     cylinder {tr24 tr32 radiuss }
     cylinder {tr25 tr26 radiuss }
     cylinder {tr27 tr28 radiuss }
     cylinder {tr29 tr30 radiuss }
     cylinder {tr31 tr32 radiuss }
     cylinder {tr25 tr33 radiuss }
     cylinder {tr26 tr34 radiuss }
     cylinder {tr27 tr35 radiuss }
     cylinder {tr28 tr36 radiuss }
     cylinder {tr29 tr37 radiuss }
     cylinder {tr30 tr38 radiuss }
     cylinder {tr31 tr39 radiuss }
     cylinder {tr32 tr40 radiuss }
     cylinder {tr40 tr33 radiuss }
     cylinder {tr34 tr35 radiuss }
     cylinder {tr36 tr37 radiuss }
     cylinder {tr38 tr39 radiuss }
     cylinder {tr33 tr41 radiuss }
     cylinder {tr34 tr42 radiuss }
     cylinder {tr35 tr43 radiuss }
     cylinder {tr36 tr44 radiuss }
     cylinder {tr37 tr45 radiuss }
     cylinder {tr38 tr46 radiuss }
     cylinder {tr39 tr47 radiuss }
     cylinder {tr40 tr48 radiuss }
     cylinder {tr41 tr42 radiuss }
     cylinder {tr42 tr43 radiuss }
     cylinder {tr43 tr44 radiuss }
     cylinder {tr44 tr45 radiuss }
     cylinder {tr45 tr46 radiuss }
     cylinder {tr46 tr47 radiuss }
     cylinder {tr47 tr48 radiuss }
     cylinder {tr48 tr41 radiuss }                                        

     sphere {tr1 radiuss}
     sphere {tr2 radiuss}
     sphere {tr3 radiuss}
     sphere {tr4 radiuss}
     sphere {tr5 radiuss}
     sphere {tr6 radiuss}
     sphere {tr7 radiuss}
     sphere {tr8 radiuss}
     sphere {tr9 radiuss}
     sphere {tr10 radiuss}
     sphere {tr11 radiuss}
     sphere {tr12 radiuss}
     sphere {tr13 radiuss}
     sphere {tr14 radiuss}
     sphere {tr15 radiuss}
     sphere {tr16 radiuss}
     sphere {tr17 radiuss}
     sphere {tr18 radiuss}
     sphere {tr19 radiuss}
     sphere {tr20 radiuss}
     sphere {tr21 radiuss}
     sphere {tr22 radiuss}
     sphere {tr23 radiuss}
     sphere {tr24 radiuss}
     sphere {tr25 radiuss}
     sphere {tr26 radiuss}
     sphere {tr27 radiuss}
     sphere {tr28 radiuss}
     sphere {tr29 radiuss}
     sphere {tr30 radiuss}
     sphere {tr31 radiuss}
     sphere {tr32 radiuss}
     sphere {tr33 radiuss}
     sphere {tr34 radiuss}
     sphere {tr35 radiuss}
     sphere {tr36 radiuss}
     sphere {tr37 radiuss}
     sphere {tr38 radiuss}
     sphere {tr39 radiuss}
     sphere {tr40 radiuss}
     sphere {tr41 radiuss}
     sphere {tr42 radiuss}
     sphere {tr43 radiuss}
     sphere {tr44 radiuss}
     sphere {tr45 radiuss}
     sphere {tr46 radiuss}
     sphere {tr47 radiuss}
     sphere {tr48 radiuss}                                   
  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(12)
//snub cube, left-handed 
  #declare sca=1.142613;
  #declare scb=0.337754;
  #declare scc=0.621226;
  #declare sc1 = <scb,sca,scc>;
  #declare sc2 = <scc,sca,-1*scb>;
  #declare sc3 = <-1*scb,sca,-1*scc>;
  #declare sc4 = <-1*scc,sca,scb>;
  #declare sc5 = <scc,-1*sca,scb>;
  #declare sc6 = <scb,-1*sca,-1*scc>;
  #declare sc7 = <-1*scc,-1*sca,-1*scb>;        
  #declare sc8 = <-1*scb,-1*sca,scc>;
  #declare sc9 = <scc,scb,sca>;
  #declare sc10 = <-1*scb,scc,sca>;
  #declare sc11 = <-1*scc,-1*scb,sca>;
  #declare sc12 = <scb,-1*scc,sca>;
  #declare sc13 = <scb,scc,-1*sca>;
  #declare sc14 = <-1*scc,scb,-1*sca>;
  #declare sc15 = <-1*scb,-1*scc,-1*sca>; 
  #declare sc16 = <scc,-1*scb,-1*sca>;
  #declare sc17 = <sca,scc,scb>;
  #declare sc18 = <sca,scb,-1*scc>;
  #declare sc19 = <sca,-1*scc,-1*scb>;
  #declare sc20 = <sca,-1*scb,scc>;
  #declare sc21 = <-1*sca,scb,scc>;
  #declare sc22 = <-1*sca,scc,-1*scb>;
  #declare sc23 = <-1*sca,-1*scb,-1*scc>;
  #declare sc24 = <-1*sca,-1*scc,scb>;
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,1.343713}
   plane{<1,0,0>,1.142613 inverse texture{tex1}}
   plane{<-1,0,0>,1.142613 inverse texture{tex1}}
   plane{<0,1,0>,1.142613 inverse texture{tex1}}
   plane{<0,-1,0>,1.142613 inverse texture{tex1}}
   plane{<0,0,1>,1.142613 inverse texture{tex1}}
   plane{<0,0,-1>,1.142613 inverse texture{tex1}}
   plane{((sc1+sc2+sc17)/3),1.213355 inverse texture{tex2}}
   plane{((sc2+sc17+sc18)/3),1.213355 inverse texture{tex2}}
   plane{((sc2+sc13+sc18)/3),1.213355 inverse texture{tex2}} 
   plane{((sc2+sc3+sc13)/3),1.213355 inverse texture{tex2}}
   plane{((sc3+sc13+sc14)/3),1.213355 inverse texture{tex2}}
   plane{((sc3+sc14+sc22)/3),1.213355 inverse texture{tex2}} 
   plane{((sc3+sc4+sc22)/3),1.213355 inverse texture{tex2}}
   plane{((sc4+sc21+sc22)/3),1.213355 inverse texture{tex2}}
   plane{((sc4+sc10+sc21)/3),1.213355 inverse texture{tex2}}
   plane{((sc1+sc4+sc10)/3),1.213355 inverse texture{tex2}} 
   plane{((sc1+sc9+sc10)/3),1.213355 inverse texture{tex2}}
   plane{((sc1+sc9+sc17)/3),1.213355 inverse texture{tex2}} 
   plane{((sc9+sc12+sc20)/3),1.213355 inverse texture{tex2}}
   plane{((sc9+sc17+sc20)/3),1.213355 inverse texture{tex2}} 
   plane{((sc16+sc18+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc13+sc16+sc18)/3),1.213355 inverse texture{tex2}}
   plane{((sc14+sc15+sc23)/3),1.213355 inverse texture{tex2}}
   plane{((sc14+sc22+sc23)/3),1.213355 inverse texture{tex2}} 
   plane{((sc11+sc21+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc10+sc11+sc21)/3),1.213355 inverse texture{tex2}} 
   plane{((sc5+sc12+sc20)/3),1.213355 inverse texture{tex2}}
   plane{((sc5+sc19+sc20)/3),1.213355 inverse texture{tex2}} 
   plane{((sc5+sc6+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc16+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc15+sc16)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc7+sc15)/3),1.213355 inverse texture{tex2}} 
   plane{((sc7+sc15+sc23)/3),1.213355 inverse texture{tex2}}
   plane{((sc7+sc23+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc7+sc8+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc8+sc11+sc24)/3),1.213355 inverse texture{tex2}} 
   plane{((sc8+sc11+sc12)/3),1.213355 inverse texture{tex2}}
   plane{((sc5+sc8+sc12)/3),1.213355 inverse texture{tex2}}                                                       

   texture{tex1}
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {sc1 sc2 radiuss }
     cylinder {sc2 sc3 radiuss }
     cylinder {sc3 sc4 radiuss }
     cylinder {sc4 sc1 radiuss }
     cylinder {sc5 sc6 radiuss }
     cylinder {sc6 sc7 radiuss }
     cylinder {sc7 sc8 radiuss }
     cylinder {sc8 sc5 radiuss }                  
     cylinder {sc9 sc10 radiuss }
     cylinder {sc10 sc11 radiuss }
     cylinder {sc11 sc12 radiuss }
     cylinder {sc12 sc9 radiuss }
     cylinder {sc13 sc14 radiuss }
     cylinder {sc14 sc15 radiuss }
     cylinder {sc15 sc16 radiuss }
     cylinder {sc16 sc13 radiuss }
     cylinder {sc17 sc18 radiuss }
     cylinder {sc18 sc19 radiuss }
     cylinder {sc19 sc20 radiuss }
     cylinder {sc20 sc17 radiuss }
     cylinder {sc21 sc22 radiuss }
     cylinder {sc22 sc23 radiuss }
     cylinder {sc23 sc24 radiuss }                  
     cylinder {sc24 sc21 radiuss }
     cylinder {sc1 sc10 radiuss }
     cylinder {sc1 sc9 radiuss }
     cylinder {sc1 sc17 radiuss }
     cylinder {sc2 sc17 radiuss }
     cylinder {sc2 sc18 radiuss }
     cylinder {sc2 sc13 radiuss }
     cylinder {sc3 sc13 radiuss }
     cylinder {sc3 sc14 radiuss }
     cylinder {sc3 sc22 radiuss }
     cylinder {sc4 sc22 radiuss }
     cylinder {sc4 sc21 radiuss }
     cylinder {sc4 sc10 radiuss }
     cylinder {sc9 sc17 radiuss }
     cylinder {sc9 sc20 radiuss }                  
     cylinder {sc18 sc13 radiuss }
     cylinder {sc18 sc16 radiuss }
     cylinder {sc14 sc22 radiuss }
     cylinder {sc14 sc23 radiuss }
     cylinder {sc21 sc10 radiuss }
     cylinder {sc21 sc11 radiuss }
     cylinder {sc12 sc20 radiuss }
     cylinder {sc19 sc16 radiuss }
     cylinder {sc15 sc23 radiuss }
     cylinder {sc24 sc11 radiuss }
     cylinder {sc5 sc19 radiuss }
     cylinder {sc5 sc20 radiuss }
     cylinder {sc5 sc12 radiuss }
     cylinder {sc6 sc15 radiuss }
     cylinder {sc6 sc16 radiuss }                  
     cylinder {sc6 sc19 radiuss }
     cylinder {sc7 sc24 radiuss }
     cylinder {sc7 sc23 radiuss }
     cylinder {sc7 sc15 radiuss }
     cylinder {sc8 sc12 radiuss }
     cylinder {sc8 sc11 radiuss }
     cylinder {sc8 sc24 radiuss }        

     sphere {sc1  radiuss}
     sphere {sc2  radiuss}
     sphere {sc3  radiuss}
     sphere {sc4  radiuss}
     sphere {sc5  radiuss}
     sphere {sc6  radiuss}
     sphere {sc7  radiuss}
     sphere {sc8  radiuss}
     sphere {sc9  radiuss}
     sphere {sc10 radiuss}
     sphere {sc11 radiuss}
     sphere {sc12 radiuss}
     sphere {sc13 radiuss}
     sphere {sc14 radiuss}
     sphere {sc15 radiuss}
     sphere {sc16 radiuss}
     sphere {sc17 radiuss}
     sphere {sc18 radiuss}
     sphere {sc19 radiuss}
     sphere {sc20 radiuss}
     sphere {sc21 radiuss}
     sphere {sc22 radiuss}
     sphere {sc23 radiuss}
     sphere {sc24 radiuss} 
                                
     texture{tex1} 
    }
  #end   
 #end
#break

#case(13)
//snub cube, right-handed 
  #declare sca=1.142613;
  #declare scb=0.337754;
  #declare scc=0.621226;
  #declare sc1 = <scb,sca,scc>;
  #declare sc2 = <scc,sca,-1*scb>;
  #declare sc3 = <-1*scb,sca,-1*scc>;
  #declare sc4 = <-1*scc,sca,scb>;
  #declare sc5 = <scc,-1*sca,scb>;
  #declare sc6 = <scb,-1*sca,-1*scc>;
  #declare sc7 = <-1*scc,-1*sca,-1*scb>;        
  #declare sc8 = <-1*scb,-1*sca,scc>;
  #declare sc9 = <scc,scb,sca>;
  #declare sc10 = <-1*scb,scc,sca>;
  #declare sc11 = <-1*scc,-1*scb,sca>;
  #declare sc12 = <scb,-1*scc,sca>;
  #declare sc13 = <scb,scc,-1*sca>;
  #declare sc14 = <-1*scc,scb,-1*sca>;
  #declare sc15 = <-1*scb,-1*scc,-1*sca>; 
  #declare sc16 = <scc,-1*scb,-1*sca>;
  #declare sc17 = <sca,scc,scb>;
  #declare sc18 = <sca,scb,-1*scc>;
  #declare sc19 = <sca,-1*scc,-1*scb>;
  #declare sc20 = <sca,-1*scb,scc>;
  #declare sc21 = <-1*sca,scb,scc>;
  #declare sc22 = <-1*sca,scc,-1*scb>;
  #declare sc23 = <-1*sca,-1*scb,-1*scc>;
  #declare sc24 = <-1*sca,-1*scc,scb>;
 #if (asc(verzion)=115)
  difference
  {            
   sphere{<0,0,0>,1.343713}
   plane{<1,0,0>,1.142613 inverse texture{tex1}}
   plane{<-1,0,0>,1.142613 inverse texture{tex1}}
   plane{<0,1,0>,1.142613 inverse texture{tex1}}
   plane{<0,-1,0>,1.142613 inverse texture{tex1}}
   plane{<0,0,1>,1.142613 inverse texture{tex1}}
   plane{<0,0,-1>,1.142613 inverse texture{tex1}}
   plane{((sc1+sc2+sc17)/3),1.213355 inverse texture{tex2}}
   plane{((sc2+sc17+sc18)/3),1.213355 inverse texture{tex2}}
   plane{((sc2+sc13+sc18)/3),1.213355 inverse texture{tex2}} 
   plane{((sc2+sc3+sc13)/3),1.213355 inverse texture{tex2}}
   plane{((sc3+sc13+sc14)/3),1.213355 inverse texture{tex2}}
   plane{((sc3+sc14+sc22)/3),1.213355 inverse texture{tex2}} 
   plane{((sc3+sc4+sc22)/3),1.213355 inverse texture{tex2}}
   plane{((sc4+sc21+sc22)/3),1.213355 inverse texture{tex2}}
   plane{((sc4+sc10+sc21)/3),1.213355 inverse texture{tex2}}
   plane{((sc1+sc4+sc10)/3),1.213355 inverse texture{tex2}} 
   plane{((sc1+sc9+sc10)/3),1.213355 inverse texture{tex2}}
   plane{((sc1+sc9+sc17)/3),1.213355 inverse texture{tex2}} 
   plane{((sc9+sc12+sc20)/3),1.213355 inverse texture{tex2}}
   plane{((sc9+sc17+sc20)/3),1.213355 inverse texture{tex2}} 
   plane{((sc16+sc18+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc13+sc16+sc18)/3),1.213355 inverse texture{tex2}}
   plane{((sc14+sc15+sc23)/3),1.213355 inverse texture{tex2}}
   plane{((sc14+sc22+sc23)/3),1.213355 inverse texture{tex2}} 
   plane{((sc11+sc21+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc10+sc11+sc21)/3),1.213355 inverse texture{tex2}} 
   plane{((sc5+sc12+sc20)/3),1.213355 inverse texture{tex2}}
   plane{((sc5+sc19+sc20)/3),1.213355 inverse texture{tex2}} 
   plane{((sc5+sc6+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc16+sc19)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc15+sc16)/3),1.213355 inverse texture{tex2}}
   plane{((sc6+sc7+sc15)/3),1.213355 inverse texture{tex2}} 
   plane{((sc7+sc15+sc23)/3),1.213355 inverse texture{tex2}}
   plane{((sc7+sc23+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc7+sc8+sc24)/3),1.213355 inverse texture{tex2}}
   plane{((sc8+sc11+sc24)/3),1.213355 inverse texture{tex2}} 
   plane{((sc8+sc11+sc12)/3),1.213355 inverse texture{tex2}}
   plane{((sc5+sc8+sc12)/3),1.213355 inverse texture{tex2}}                                                       

   texture{tex1}
   scale <-1,1,1>
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {sc1 sc2 radiuss }
     cylinder {sc2 sc3 radiuss }
     cylinder {sc3 sc4 radiuss }
     cylinder {sc4 sc1 radiuss }
     cylinder {sc5 sc6 radiuss }
     cylinder {sc6 sc7 radiuss }
     cylinder {sc7 sc8 radiuss }
     cylinder {sc8 sc5 radiuss }                  
     cylinder {sc9 sc10 radiuss }
     cylinder {sc10 sc11 radiuss }
     cylinder {sc11 sc12 radiuss }
     cylinder {sc12 sc9 radiuss }
     cylinder {sc13 sc14 radiuss }
     cylinder {sc14 sc15 radiuss }
     cylinder {sc15 sc16 radiuss }
     cylinder {sc16 sc13 radiuss }
     cylinder {sc17 sc18 radiuss }
     cylinder {sc18 sc19 radiuss }
     cylinder {sc19 sc20 radiuss }
     cylinder {sc20 sc17 radiuss }
     cylinder {sc21 sc22 radiuss }
     cylinder {sc22 sc23 radiuss }
     cylinder {sc23 sc24 radiuss }                  
     cylinder {sc24 sc21 radiuss }
     cylinder {sc1 sc10 radiuss }
     cylinder {sc1 sc9 radiuss }
     cylinder {sc1 sc17 radiuss }
     cylinder {sc2 sc17 radiuss }
     cylinder {sc2 sc18 radiuss }
     cylinder {sc2 sc13 radiuss }
     cylinder {sc3 sc13 radiuss }
     cylinder {sc3 sc14 radiuss }
     cylinder {sc3 sc22 radiuss }
     cylinder {sc4 sc22 radiuss }
     cylinder {sc4 sc21 radiuss }
     cylinder {sc4 sc10 radiuss }
     cylinder {sc9 sc17 radiuss }
     cylinder {sc9 sc20 radiuss }                  
     cylinder {sc18 sc13 radiuss }
     cylinder {sc18 sc16 radiuss }
     cylinder {sc14 sc22 radiuss }
     cylinder {sc14 sc23 radiuss }
     cylinder {sc21 sc10 radiuss }
     cylinder {sc21 sc11 radiuss }
     cylinder {sc12 sc20 radiuss }
     cylinder {sc19 sc16 radiuss }
     cylinder {sc15 sc23 radiuss }
     cylinder {sc24 sc11 radiuss }
     cylinder {sc5 sc19 radiuss }
     cylinder {sc5 sc20 radiuss }
     cylinder {sc5 sc12 radiuss }
     cylinder {sc6 sc15 radiuss }
     cylinder {sc6 sc16 radiuss }                  
     cylinder {sc6 sc19 radiuss }
     cylinder {sc7 sc24 radiuss }
     cylinder {sc7 sc23 radiuss }
     cylinder {sc7 sc15 radiuss }
     cylinder {sc8 sc12 radiuss }
     cylinder {sc8 sc11 radiuss }
     cylinder {sc8 sc24 radiuss }        

     sphere {sc1  radiuss}
     sphere {sc2  radiuss}
     sphere {sc3  radiuss}
     sphere {sc4  radiuss}
     sphere {sc5  radiuss}
     sphere {sc6  radiuss}
     sphere {sc7  radiuss}
     sphere {sc8  radiuss}
     sphere {sc9  radiuss}
     sphere {sc10 radiuss}
     sphere {sc11 radiuss}
     sphere {sc12 radiuss}
     sphere {sc13 radiuss}
     sphere {sc14 radiuss}
     sphere {sc15 radiuss}
     sphere {sc16 radiuss}
     sphere {sc17 radiuss}
     sphere {sc18 radiuss}
     sphere {sc19 radiuss}
     sphere {sc20 radiuss}
     sphere {sc21 radiuss}
     sphere {sc22 radiuss}
     sphere {sc23 radiuss}
     sphere {sc24 radiuss} 
                                
     texture{tex1} 
     scale <-1,1,1>
    }
  #end   
 #end
#break

#case(14)
//icosidodecahedron
 #declare ida=2;
 #declare idb=.809018;
 #declare idc=.688192;
 #declare idd=.755762;    
 #declare ide=<0,.600570,-.458794>;
 #declare idf=<0,.141775,-.742344>;
 #declare idg=<0,-.141775,.742344>;
 #declare idh=<0,-.600570,.458794>;
 #declare idi=<0,.425326,.850651>;
 #declare idj=<0,-.425326,-.850651>;     
 #declare id1=<0,.688192,.425326>;
 #declare id2=<.404509,.688192,.131433>;
 #declare id3=<.25,.688192,-.344096>;
 #declare id4=<-.25,.688192,-.344096>;
 #declare id5=<-.404509,.688192,.131433>;    
 #declare id6=<0,.425326,-.688191>;
 #declare id7=<-.654509,.425326,-.212663>;
 #declare id8=<-.404509,.425326,.556759>;
 #declare id9=<.404509,.425326,.556759>;
 #declare id10=<.654509,.425326,-.212663>;    
 #declare id11=<-.25,0,.769421>;
 #declare id12=<.25,0,.769421>;
 #declare id13=<.654509,0,.475529>;
 #declare id14=<.809017,0,0>;
 #declare id15=<.654509,0,-.475529>;
 #declare id16=<.25,0,-.769421>;
 #declare id17=<-.25,0,-.769421>;
 #declare id18=<-.654509,0,-.475529>;
 #declare id19=<-.809017,0,0>;
 #declare id20=<-.654509,0,.475529>;     
 #declare id21=<0,-.425326,.688191>;
 #declare id22=<.654509,-.425326,.212663>;
 #declare id23=<.404509,-.425326,-.556759>;
 #declare id24=<-.404509,-.425326,-.556759>;
 #declare id25=<-.654509,-.425326,.212663>;   
 #declare id26=<0,-.688192,-.425326>;
 #declare id27=<-.404509,-.688192,-.131433>;
 #declare id28=<-.25,-.688192,.344096>;
 #declare id29=<.25,-.688192,.344096>;
 #declare id30=<.404509,-.688192,-.131433>;     
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, idb}
   plane{<0,1,0>, idc inverse texture{tex1}}
   plane{<0,-1,0>, idc inverse texture{tex1}}   
   #declare loop=0;
   #while (loop<5)
   plane{ide, idd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{idf, idd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{idg, idd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{idh, idd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{idi, idc inverse texture{tex1} rotate <0,loop*72,0>}
   plane{idj, idc inverse texture{tex1} rotate <0,loop*72,0>}         
   #declare loop=loop+1;
   #end
   
   scale ida
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {id1 id2 (radiuss/ida) }
     cylinder {id2 id3 (radiuss/ida) }
     cylinder {id3 id4 (radiuss/ida) }
     cylinder {id4 id5 (radiuss/ida) }
     cylinder {id5 id1 (radiuss/ida) }
     cylinder {id11 id12 (radiuss/ida) }
     cylinder {id12 id13 (radiuss/ida) }
     cylinder {id13 id14 (radiuss/ida) }
     cylinder {id14 id15 (radiuss/ida) }
     cylinder {id15 id16 (radiuss/ida) }
     cylinder {id16 id17 (radiuss/ida) }
     cylinder {id17 id18 (radiuss/ida) }
     cylinder {id18 id19 (radiuss/ida) }
     cylinder {id19 id20 (radiuss/ida) }
     cylinder {id20 id11 (radiuss/ida) }
     cylinder {id26 id27 (radiuss/ida) }
     cylinder {id27 id28 (radiuss/ida) }
     cylinder {id28 id29 (radiuss/ida) }
     cylinder {id29 id30 (radiuss/ida) }
     cylinder {id30 id26 (radiuss/ida) }
     cylinder {id1 id8 (radiuss/ida) }
     cylinder {id1 id9 (radiuss/ida) }
     cylinder {id2 id9 (radiuss/ida) }
     cylinder {id2 id10 (radiuss/ida) }
     cylinder {id3 id10 (radiuss/ida) }
     cylinder {id3 id6 (radiuss/ida) }
     cylinder {id4 id6 (radiuss/ida) }
     cylinder {id4 id7 (radiuss/ida) }
     cylinder {id5 id7 (radiuss/ida) }
     cylinder {id5 id8 (radiuss/ida) }
     cylinder {id6 id16 (radiuss/ida) }
     cylinder {id6 id17 (radiuss/ida) }
     cylinder {id7 id18 (radiuss/ida) }
     cylinder {id7 id19 (radiuss/ida) }
     cylinder {id8 id20 (radiuss/ida) }
     cylinder {id8 id11 (radiuss/ida) }
     cylinder {id9 id12 (radiuss/ida) }
     cylinder {id9 id13 (radiuss/ida) }
     cylinder {id10 id14 (radiuss/ida) }
     cylinder {id10 id15 (radiuss/ida) }
     cylinder {id21 id11 (radiuss/ida) }
     cylinder {id21 id12 (radiuss/ida) }
     cylinder {id22 id13 (radiuss/ida) }
     cylinder {id22 id14 (radiuss/ida) }
     cylinder {id23 id15 (radiuss/ida) }
     cylinder {id23 id16 (radiuss/ida) }
     cylinder {id24 id17 (radiuss/ida) }
     cylinder {id24 id18 (radiuss/ida) }
     cylinder {id25 id19 (radiuss/ida) }
     cylinder {id25 id20 (radiuss/ida) }
     cylinder {id26 id23 (radiuss/ida) }
     cylinder {id26 id24 (radiuss/ida) }
     cylinder {id27 id24 (radiuss/ida) }
     cylinder {id27 id25 (radiuss/ida) }
     cylinder {id28 id25 (radiuss/ida) }
     cylinder {id28 id21 (radiuss/ida) }
     cylinder {id29 id21 (radiuss/ida) }
     cylinder {id29 id22 (radiuss/ida) }
     cylinder {id30 id22 (radiuss/ida) }
     cylinder {id30 id23 (radiuss/ida) }                                                           

     sphere {id1 (radiuss/ida)}
     sphere {id2 (radiuss/ida)}
     sphere {id3 (radiuss/ida)}
     sphere {id4 (radiuss/ida)}
     sphere {id5 (radiuss/ida)}
     sphere {id6 (radiuss/ida)}
     sphere {id7 (radiuss/ida)}
     sphere {id8 (radiuss/ida)}
     sphere {id9 (radiuss/ida)}
     sphere {id10 (radiuss/ida)}
     sphere {id11 (radiuss/ida)}
     sphere {id12 (radiuss/ida)}
     sphere {id13 (radiuss/ida)}
     sphere {id14 (radiuss/ida)}
     sphere {id15 (radiuss/ida)}
     sphere {id16 (radiuss/ida)}
     sphere {id17 (radiuss/ida)}
     sphere {id18 (radiuss/ida)}
     sphere {id19 (radiuss/ida)}
     sphere {id20 (radiuss/ida)}
     sphere {id21 (radiuss/ida)}
     sphere {id22 (radiuss/ida)}
     sphere {id23 (radiuss/ida)}
     sphere {id24 (radiuss/ida)}
     sphere {id25 (radiuss/ida)}
     sphere {id26 (radiuss/ida)}
     sphere {id27 (radiuss/ida)}
     sphere {id28 (radiuss/ida)}
     sphere {id29 (radiuss/ida)}
     sphere {id30 (radiuss/ida)}                                   

     scale ida
     texture{tex1} 
    }
  #end   
 #end
#break

#case(15)
//truncated icosahedron
 #declare tia=3;
 #declare tib=.826006;
 #declare tic=.775813;
 #declare tid=.755762;
 #declare tie=<0,1,0>;
 #declare tif=<0,-1,0>; 
 #declare tig=<0,.497980,.995960>;
 #declare tih=<0,-.497980,-.995960>; 
 #declare tii=<0,.600570,-.458794>;
 #declare tij=<0,-.600570,.458794>; 
 #declare tik=<0,.141775,-.742344>;
 #declare til=<0,-.141775,.742344>; 
 #declare ti1=<0,.775813,.283550>;
 #declare ti2=<.269672,.775813,.087622>;
 #declare ti3=<.166667,.775813,-.229397>;
 #declare ti4=<-.166667,.775813,-.229397>;
 #declare ti5=<-.269672,.775813,.087622>;
 #declare ti6=<0,.600570,.567101>;
 #declare ti7=<.539344,.600570,.175244>;
 #declare ti8=<.333333,.600570,-.458794>;
 #declare ti9=<-.333333,.600570,-.458794>;
 #declare ti10=<-.539344,.600570,.175244>;
 #declare ti11=<.269672,.425326,.654723>;
 #declare ti12=<.539345,.425326,.458794>;
 #declare ti13=<.706011,.425326,-.054153>;
 #declare ti14=<.603006,.425326,-.371172>;
 #declare ti15=<.166667,.425326,-.688191>;
 #declare ti16=<-.166667,.425326,-.688191>;
 #declare ti17=<-.603006,.425326,-.371172>;
 #declare ti18=<-.706011,.425326,-.054153>;
 #declare ti19=<-.539345,.425326,.458794>;
 #declare ti20=<-.269672,.425326,.654723>;
 #declare ti21=<.166667,.141775,.796498>;
 #declare ti22=<.706011,.141775,.404641>;
 #declare ti23=<.809017,.141775,.087622>;
 #declare ti24=<.603006,.141775,-.546416>;
 #declare ti25=<.333333,.141775,-.742344>;
 #declare ti26=<-.333333,.141775,-.742344>;
 #declare ti27=<-.603006,.141775,-.546416>;
 #declare ti28=<-.809017,.141775,.087622>;
 #declare ti29=<-.706011,.141775,.404641>;
 #declare ti30=<-.166667,.141775,.796498>;
 #declare ti31=<.333333,-.141775,.742344>;
 #declare ti32=<.603006,-.141775,.546416>;
 #declare ti33=<.809017,-.141775,-.087622>;
 #declare ti34=<.706011,-.141775,-.404641>;
 #declare ti35=<.166667,-.141775,-.796498>;
 #declare ti36=<-.166667,-.141775,-.796498>;
 #declare ti37=<-.706011,-.141775,-.404641>;
 #declare ti38=<-.809017,-.141775,-.087622>;
 #declare ti39=<-.603006,-.141775,.546416>;
 #declare ti40=<-.333333,-.141775,.742344>;
 #declare ti41=<.166667,-.425326,.688191>;
 #declare ti42=<.603006,-.425326,.371172>;
 #declare ti43=<.706011,-.425326,.054143>;
 #declare ti44=<.539345,-.425326,-.458794>;
 #declare ti45=<.269672,-.425326,-.654723>;
 #declare ti46=<-.269672,-.425326,-.654723>;
 #declare ti47=<-.539345,-.425326,-.458794>;
 #declare ti48=<-.706011,-.425326,.054153>;
 #declare ti49=<-.603006,-.425326,.371172>;
 #declare ti50=<-.166667,-.425326,.688191>;
 #declare ti51=<0,-.600570,-.567101>;
 #declare ti52=<-.539344,-.600570,-.175244>;
 #declare ti53=<-.333333,-.600570,.458794>;
 #declare ti54=<.333333,-.600570,.458794>;
 #declare ti55=<.539344,-.600570,-.175244>;
 #declare ti56=<0,-.775813,-.283550>;
 #declare ti57=<-.269672,-.775813,-.087622>;
 #declare ti58=<-.166667,-.775813,.229397>;
 #declare ti59=<.166667,-.775813,.229397>;
 #declare ti60=<.269672,-.775813,-.087622>;  
                  
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, tib}
   plane{tie, tic inverse texture{tex1}}
   plane{tif, tic inverse texture{tex1}}   
   #declare loop=0;
   #while (loop<5) 
   plane{tig, tic inverse texture{tex1} rotate <0,loop*72,0>}
   plane{tih, tic inverse texture{tex1} rotate <0,loop*72,0>}
   plane{tii, tid inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tij, tid inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tik, tid inverse texture{tex2} rotate <0,loop*72,0>}
   plane{til, tid inverse texture{tex2} rotate <0,loop*72,0>}               
   #declare loop=loop+1;
   #end
   
   scale tia
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {        
     cylinder {ti1 ti2 (radiuss/tia) }
     cylinder {ti2 ti3 (radiuss/tia) }
     cylinder {ti3 ti4 (radiuss/tia) }
     cylinder {ti4 ti5 (radiuss/tia) }
     cylinder {ti5 ti1 (radiuss/tia) }
     cylinder {ti1 ti6 (radiuss/tia) }
     cylinder {ti2 ti7 (radiuss/tia) }
     cylinder {ti3 ti8 (radiuss/tia) }
     cylinder {ti4 ti9 (radiuss/tia) }
     cylinder {ti5 ti10 (radiuss/tia) }
     cylinder {ti6 ti20 (radiuss/tia) }
     cylinder {ti6 ti11 (radiuss/tia) }
     cylinder {ti7 ti12 (radiuss/tia) }
     cylinder {ti7 ti13 (radiuss/tia) }
     cylinder {ti8 ti14 (radiuss/tia) }
     cylinder {ti8 ti15 (radiuss/tia) }
     cylinder {ti9 ti16 (radiuss/tia) }
     cylinder {ti9 ti17 (radiuss/tia) }
     cylinder {ti10 ti18 (radiuss/tia) }
     cylinder {ti10 ti19 (radiuss/tia) }
     cylinder {ti11 ti21 (radiuss/tia) }
     cylinder {ti12 ti22 (radiuss/tia) }
     cylinder {ti13 ti23 (radiuss/tia) }
     cylinder {ti14 ti24 (radiuss/tia) }
     cylinder {ti15 ti25 (radiuss/tia) }
     cylinder {ti16 ti26 (radiuss/tia) }
     cylinder {ti17 ti27 (radiuss/tia) }
     cylinder {ti18 ti28 (radiuss/tia) }
     cylinder {ti19 ti29 (radiuss/tia) }
     cylinder {ti20 ti30 (radiuss/tia) }
     cylinder {ti21 ti31 (radiuss/tia) }
     cylinder {ti22 ti32 (radiuss/tia) }
     cylinder {ti23 ti33 (radiuss/tia) }
     cylinder {ti24 ti34 (radiuss/tia) }
     cylinder {ti25 ti35 (radiuss/tia) }
     cylinder {ti26 ti36 (radiuss/tia) }
     cylinder {ti27 ti37 (radiuss/tia) }
     cylinder {ti28 ti38 (radiuss/tia) }
     cylinder {ti29 ti39 (radiuss/tia) }
     cylinder {ti30 ti40 (radiuss/tia) }
     cylinder {ti31 ti41 (radiuss/tia) }
     cylinder {ti32 ti42 (radiuss/tia) }
     cylinder {ti33 ti43 (radiuss/tia) }
     cylinder {ti34 ti44 (radiuss/tia) }
     cylinder {ti35 ti45 (radiuss/tia) }
     cylinder {ti36 ti46 (radiuss/tia) }
     cylinder {ti37 ti47 (radiuss/tia) }
     cylinder {ti38 ti48 (radiuss/tia) }
     cylinder {ti39 ti49 (radiuss/tia) }
     cylinder {ti40 ti50 (radiuss/tia) }
     cylinder {ti51 ti45 (radiuss/tia) }
     cylinder {ti51 ti46 (radiuss/tia) }
     cylinder {ti52 ti47 (radiuss/tia) }
     cylinder {ti52 ti48 (radiuss/tia) }
     cylinder {ti53 ti49 (radiuss/tia) }
     cylinder {ti53 ti50 (radiuss/tia) }
     cylinder {ti54 ti41 (radiuss/tia) }
     cylinder {ti54 ti42 (radiuss/tia) }
     cylinder {ti55 ti43 (radiuss/tia) }
     cylinder {ti55 ti44 (radiuss/tia) }
     cylinder {ti51 ti56 (radiuss/tia) }
     cylinder {ti52 ti57 (radiuss/tia) }
     cylinder {ti53 ti58 (radiuss/tia) }
     cylinder {ti54 ti59 (radiuss/tia) }
     cylinder {ti55 ti60 (radiuss/tia) }
     cylinder {ti56 ti57 (radiuss/tia) }
     cylinder {ti57 ti58 (radiuss/tia) }
     cylinder {ti58 ti59 (radiuss/tia) }
     cylinder {ti59 ti60 (radiuss/tia) }
     cylinder {ti60 ti56 (radiuss/tia) }
     cylinder {ti11 ti12 (radiuss/tia) }
     cylinder {ti13 ti14 (radiuss/tia) }
     cylinder {ti15 ti16 (radiuss/tia) }
     cylinder {ti17 ti18 (radiuss/tia) }
     cylinder {ti19 ti20 (radiuss/tia) }
     cylinder {ti30 ti21 (radiuss/tia) }
     cylinder {ti22 ti23 (radiuss/tia) }
     cylinder {ti24 ti25 (radiuss/tia) }
     cylinder {ti26 ti27 (radiuss/tia) }
     cylinder {ti28 ti29 (radiuss/tia) }
     cylinder {ti31 ti32 (radiuss/tia) }
     cylinder {ti33 ti34 (radiuss/tia) }
     cylinder {ti35 ti36 (radiuss/tia) }
     cylinder {ti37 ti38 (radiuss/tia) }
     cylinder {ti39 ti40 (radiuss/tia) }
     cylinder {ti50 ti41 (radiuss/tia) }
     cylinder {ti42 ti43 (radiuss/tia) }
     cylinder {ti44 ti45 (radiuss/tia) }
     cylinder {ti46 ti47 (radiuss/tia) }
     cylinder {ti48 ti49 (radiuss/tia) }          

     sphere {ti1 (radiuss/tia)}  
     sphere {ti2 (radiuss/tia)}
     sphere {ti3 (radiuss/tia)}
     sphere {ti4 (radiuss/tia)}
     sphere {ti5 (radiuss/tia)}
     sphere {ti6 (radiuss/tia)}  
     sphere {ti7 (radiuss/tia)}
     sphere {ti8 (radiuss/tia)}
     sphere {ti9 (radiuss/tia)}
     sphere {ti10 (radiuss/tia)} 
     sphere {ti11 (radiuss/tia)}  
     sphere {ti12 (radiuss/tia)}
     sphere {ti13 (radiuss/tia)}
     sphere {ti14 (radiuss/tia)}
     sphere {ti15 (radiuss/tia)}
     sphere {ti16 (radiuss/tia)}  
     sphere {ti17 (radiuss/tia)}
     sphere {ti18 (radiuss/tia)}
     sphere {ti19 (radiuss/tia)}
     sphere {ti20 (radiuss/tia)} 
     sphere {ti21 (radiuss/tia)}  
     sphere {ti22 (radiuss/tia)}
     sphere {ti23 (radiuss/tia)}
     sphere {ti24 (radiuss/tia)}
     sphere {ti25 (radiuss/tia)}
     sphere {ti26 (radiuss/tia)}  
     sphere {ti27 (radiuss/tia)}
     sphere {ti28 (radiuss/tia)}
     sphere {ti29 (radiuss/tia)}
     sphere {ti30 (radiuss/tia)} 
     sphere {ti31 (radiuss/tia)}  
     sphere {ti32 (radiuss/tia)}
     sphere {ti33 (radiuss/tia)}
     sphere {ti34 (radiuss/tia)}
     sphere {ti35 (radiuss/tia)}
     sphere {ti36 (radiuss/tia)}  
     sphere {ti37 (radiuss/tia)}
     sphere {ti38 (radiuss/tia)}
     sphere {ti39 (radiuss/tia)}
     sphere {ti40 (radiuss/tia)}
     sphere {ti41 (radiuss/tia)}  
     sphere {ti42 (radiuss/tia)}
     sphere {ti43 (radiuss/tia)}
     sphere {ti44 (radiuss/tia)}
     sphere {ti45 (radiuss/tia)}
     sphere {ti46 (radiuss/tia)}  
     sphere {ti47 (radiuss/tia)}
     sphere {ti48 (radiuss/tia)}
     sphere {ti49 (radiuss/tia)}
     sphere {ti50 (radiuss/tia)}
     sphere {ti51 (radiuss/tia)}  
     sphere {ti52 (radiuss/tia)}
     sphere {ti53 (radiuss/tia)}
     sphere {ti54 (radiuss/tia)}
     sphere {ti55 (radiuss/tia)}
     sphere {ti56 (radiuss/tia)}  
     sphere {ti57 (radiuss/tia)}
     sphere {ti58 (radiuss/tia)}
     sphere {ti59 (radiuss/tia)}
     sphere {ti60 (radiuss/tia)}                                   
  
     scale tia
     texture{tex1} 
    }
  #end   
 #end
#break

#case(16)
//truncated dodecahedron
 #declare tda=2.236066; 
 #declare tdb=1.327979;
 #declare tdc=1.113517;
 #declare tdd=1.302636;  
 #declare tde=<0,1,0>;
 #declare tdf=<0,-1,0>;
 #declare tdg=<0,.425326,-.850651>;
 #declare tdh=<0,-.425326,.850651>;
 #declare tdi=<0,tdc,.850651>;
 #declare tdj=<0,.262866,1.376383>;
 #declare tdk=<0,-.262866,-1.376383>;
 #declare tdl=<0,-1*tdc,-.850651>;
 #declare td1=<.223607,1.113517,.688191>;
 #declare td2=<.585410,1.113517,.425325>;
 #declare td3=<.723607,1.113517,0>;
 #declare td4=<.585410,1.113517,-.425325>;
 #declare td5=<.223607,1.113517,-.688191>;
 #declare td6=<-.223607,1.113517,-.688191>;
 #declare td7=<-.585410,1.113517,-.425325>;
 #declare td8=<-.723607,1.113517,0>;
 #declare td9=<-.585410,1.113517,.425325>;
 #declare td10=<-.223607,1.113517,.688191>;
 #declare td11=<0,.878403,.995960>;
 #declare td12=<.947214,.878403,.307769>;
 #declare td13=<.585410,.878403,-.805748>;
 #declare td14=<-.585410,.878403,-.805748>;
 #declare td15=<-.947214,.878403,.307769>;
 #declare td16=<0,.497980,1.231074>;
 #declare td17=<1.170821,.497980,.380423>;
 #declare td18=<.723607,.497980,-.995960>;
 #declare td19=<-.723607,.497980,-.995960>;
 #declare td20=<-1.170821,.497980,.380423>;
 #declare td21=<.223607,.117557,1.303729>;
 #declare td22=<1.170821,.117557,.615537>;
 #declare td23=<1.309018,.117557,.190212>;
 #declare td24=<.947214,.117557,-.923306>;
 #declare td25=<.585410,.117557,-1.186171>;
 #declare td26=<-.585410,.117557,-1.186171>;
 #declare td27=<-.947214,.117557,-.923306>;
 #declare td28=<-1.309018,.117557,.190212>;
 #declare td29=<-1.170821,.117557,.615537>;
 #declare td30=<-.223607,.117557,1.303729>;
 #declare td31=<.585410,-.117557,1.186171>;
 #declare td32=<.947214,-.117557,.923306>;
 #declare td33=<1.309018,-.117557,-.190212>;
 #declare td34=<1.170821,-.117557,-.615537>;
 #declare td35=<.223607,-.117557,-1.303729>;
 #declare td36=<-.223607,-.117557,-1.303729>;
 #declare td37=<-1.170821,-.117557,-.615537>;
 #declare td38=<-1.309018,-.117557,-.190212>;
 #declare td39=<-.947214,-.117557,.923306>;
 #declare td40=<-.585410,-.117557,1.186171>;
 #declare td41=<0,-.497980,-1.231074>;
 #declare td42=<-1.170821,-.497980,-.380423>;
 #declare td43=<-.723607,-.497980,.995960>;
 #declare td44=<.723607,-.497980,.995960>;
 #declare td45=<1.170821,-.497980,-.380423>;
 #declare td46=<0,-.878403,-.995960>;
 #declare td47=<-.947214,-.878403,-.307769>;
 #declare td48=<-.585410,-.878403,.805478>;
 #declare td49=<.585410,-.878403,.805748>;
 #declare td50=<.947214,-.878403,-.307769>;
 #declare td51=<-.223607,-1.113517,-.688191>;
 #declare td52=<-.585410,-1.113517,-.425325>;
 #declare td53=<-.723607,-1.113517,0>;
 #declare td54=<-.585410,-1.113517,.425325>;
 #declare td55=<-.223607,-1.113517,.688191>;
 #declare td56=<.223607,-1.113517,.688191>;
 #declare td57=<.585410,-1.113517,.425325>;
 #declare td58=<.723607,-1.113517,0>;
 #declare td59=<.585410,-1.113517,-.425325>;
 #declare td60=<.223607,-1.113517,-.688191>;                 
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, tdb}
   plane{tde, tdc inverse texture{tex1}}
   plane{tdf, tdc inverse texture{tex1}}
   #declare loop=0;
   #while (loop<5)
   plane{tdg, tdc inverse texture{tex1} rotate <0,loop*72,0>}
   plane{tdh, tdc inverse texture{tex1} rotate <0,loop*72,0>}         
   plane{tdi, tdd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tdj, tdd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tdk, tdd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tdl, tdd inverse texture{tex2} rotate <0,loop*72,0>}         
   #declare loop=loop+1;
   #end 
   
   scale tda
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {td1 td2 (radiuss/tda) }
     cylinder {td2 td3 (radiuss/tda) }
     cylinder {td3 td4 (radiuss/tda) }
     cylinder {td4 td5 (radiuss/tda) }
     cylinder {td5 td6 (radiuss/tda) }
     cylinder {td6 td7 (radiuss/tda) }
     cylinder {td7 td8 (radiuss/tda) }
     cylinder {td8 td9 (radiuss/tda) }
     cylinder {td9 td10 (radiuss/tda) }
     cylinder {td10 td1 (radiuss/tda) }
     cylinder {td11 td10 (radiuss/tda) }
     cylinder {td11 td1 (radiuss/tda) }
     cylinder {td12 td2 (radiuss/tda) }
     cylinder {td12 td3 (radiuss/tda) }
     cylinder {td13 td4 (radiuss/tda) }
     cylinder {td13 td5 (radiuss/tda) }
     cylinder {td14 td6 (radiuss/tda) }
     cylinder {td14 td7 (radiuss/tda) }
     cylinder {td15 td8 (radiuss/tda) }
     cylinder {td15 td9 (radiuss/tda) }
     cylinder {td11 td16 (radiuss/tda) }
     cylinder {td12 td17 (radiuss/tda) }
     cylinder {td13 td18 (radiuss/tda) }
     cylinder {td14 td19 (radiuss/tda) }
     cylinder {td15 td20 (radiuss/tda) }
     cylinder {td16 td30 (radiuss/tda) }
     cylinder {td16 td21 (radiuss/tda) }
     cylinder {td17 td22 (radiuss/tda) }
     cylinder {td17 td23 (radiuss/tda) }
     cylinder {td18 td24 (radiuss/tda) }
     cylinder {td18 td25 (radiuss/tda) }
     cylinder {td19 td26 (radiuss/tda) }
     cylinder {td19 td27 (radiuss/tda) }
     cylinder {td20 td28 (radiuss/tda) }
     cylinder {td20 td29 (radiuss/tda) }
     cylinder {td30 td21 (radiuss/tda) }
     cylinder {td21 td31 (radiuss/tda) }
     cylinder {td31 td32 (radiuss/tda) }
     cylinder {td32 td22 (radiuss/tda) }
     cylinder {td22 td23 (radiuss/tda) }
     cylinder {td23 td33 (radiuss/tda) }
     cylinder {td33 td34 (radiuss/tda) }
     cylinder {td34 td24 (radiuss/tda) }
     cylinder {td24 td25 (radiuss/tda) }
     cylinder {td25 td35 (radiuss/tda) }
     cylinder {td35 td36 (radiuss/tda) }
     cylinder {td36 td26 (radiuss/tda) }
     cylinder {td26 td27 (radiuss/tda) }
     cylinder {td27 td37 (radiuss/tda) }
     cylinder {td37 td38 (radiuss/tda) }
     cylinder {td38 td28 (radiuss/tda) }
     cylinder {td28 td29 (radiuss/tda) }
     cylinder {td29 td39 (radiuss/tda) }
     cylinder {td39 td40 (radiuss/tda) }
     cylinder {td40 td30 (radiuss/tda) }
     cylinder {td41 td35 (radiuss/tda) }
     cylinder {td41 td36 (radiuss/tda) }
     cylinder {td42 td37 (radiuss/tda) }
     cylinder {td42 td38 (radiuss/tda) }
     cylinder {td43 td39 (radiuss/tda) }
     cylinder {td43 td40 (radiuss/tda) }
     cylinder {td44 td31 (radiuss/tda) }
     cylinder {td44 td32 (radiuss/tda) }
     cylinder {td45 td33 (radiuss/tda) }
     cylinder {td45 td34 (radiuss/tda) }
     cylinder {td41 td46 (radiuss/tda) }
     cylinder {td42 td47 (radiuss/tda) }
     cylinder {td43 td48 (radiuss/tda) }
     cylinder {td44 td49 (radiuss/tda) }
     cylinder {td45 td50 (radiuss/tda) }
     cylinder {td46 td60 (radiuss/tda) }
     cylinder {td46 td51 (radiuss/tda) }
     cylinder {td47 td52 (radiuss/tda) }
     cylinder {td47 td53 (radiuss/tda) }
     cylinder {td48 td54 (radiuss/tda) }
     cylinder {td48 td55 (radiuss/tda) }
     cylinder {td49 td56 (radiuss/tda) }
     cylinder {td49 td57 (radiuss/tda) }
     cylinder {td50 td58 (radiuss/tda) }
     cylinder {td50 td59 (radiuss/tda) }
     cylinder {td51 td52 (radiuss/tda) }
     cylinder {td52 td53 (radiuss/tda) }
     cylinder {td53 td54 (radiuss/tda) }
     cylinder {td54 td55 (radiuss/tda) }
     cylinder {td55 td56 (radiuss/tda) }
     cylinder {td56 td57 (radiuss/tda) }
     cylinder {td57 td58 (radiuss/tda) }
     cylinder {td58 td59 (radiuss/tda) }
     cylinder {td59 td60 (radiuss/tda) }
     cylinder {td60 td51 (radiuss/tda) }                                             

     sphere {td1 (radiuss/tda)}
     sphere {td2 (radiuss/tda)}
     sphere {td3 (radiuss/tda)}
     sphere {td4 (radiuss/tda)}
     sphere {td5 (radiuss/tda)}
     sphere {td6 (radiuss/tda)}
     sphere {td7 (radiuss/tda)}
     sphere {td8 (radiuss/tda)}
     sphere {td9 (radiuss/tda)}
     sphere {td10 (radiuss/tda)}
     sphere {td11 (radiuss/tda)}
     sphere {td12 (radiuss/tda)}
     sphere {td13 (radiuss/tda)}
     sphere {td14 (radiuss/tda)}
     sphere {td15 (radiuss/tda)}
     sphere {td16 (radiuss/tda)}
     sphere {td17 (radiuss/tda)}
     sphere {td18 (radiuss/tda)}
     sphere {td19 (radiuss/tda)}
     sphere {td20 (radiuss/tda)}
     sphere {td21 (radiuss/tda)}
     sphere {td22 (radiuss/tda)}
     sphere {td23 (radiuss/tda)}
     sphere {td24 (radiuss/tda)}
     sphere {td25 (radiuss/tda)}
     sphere {td26 (radiuss/tda)}
     sphere {td27 (radiuss/tda)}
     sphere {td28 (radiuss/tda)}
     sphere {td29 (radiuss/tda)}
     sphere {td30 (radiuss/tda)}
     sphere {td31 (radiuss/tda)}
     sphere {td32 (radiuss/tda)}
     sphere {td33 (radiuss/tda)}
     sphere {td34 (radiuss/tda)}
     sphere {td35 (radiuss/tda)}
     sphere {td36 (radiuss/tda)}
     sphere {td37 (radiuss/tda)}
     sphere {td38 (radiuss/tda)}
     sphere {td39 (radiuss/tda)}
     sphere {td40 (radiuss/tda)}
     sphere {td41 (radiuss/tda)}
     sphere {td42 (radiuss/tda)}
     sphere {td43 (radiuss/tda)}
     sphere {td44 (radiuss/tda)}
     sphere {td45 (radiuss/tda)}
     sphere {td46 (radiuss/tda)}
     sphere {td47 (radiuss/tda)}
     sphere {td48 (radiuss/tda)}
     sphere {td49 (radiuss/tda)}
     sphere {td50 (radiuss/tda)}
     sphere {td51 (radiuss/tda)}
     sphere {td52 (radiuss/tda)}
     sphere {td53 (radiuss/tda)}
     sphere {td54 (radiuss/tda)}
     sphere {td55 (radiuss/tda)}
     sphere {td56 (radiuss/tda)}
     sphere {td57 (radiuss/tda)}
     sphere {td58 (radiuss/tda)}
     sphere {td59 (radiuss/tda)}                                        
     sphere {td60 (radiuss/tda)}
     
     scale tda  
     texture{tex1} 
    }
  #end   
 #end
#break

#case(17)
//rhombicosidodecahedron
 #declare rda=1;
 #declare rdb=2.232952;
 #declare rdc=2.157021;
 #declare rdd=2.118036;
 #declare rde=2.064574;
 #declare rdf=<0,1,0>;
 #declare rdg=<0,-1,0>;
 #declare rdh=<0,1.113517,.850651>;
 #declare rdi=<0,.262866,1.376383>;
 #declare rdj=<0,-.262866,-1.376383>;
 #declare rdk=<0,-1.113517,-.850651>;
 #declare rdl=<0,1.113517,-.688191>;
 #declare rdm=<0,.688192,1.113517>;
 #declare rdn=<.900855,0,.654509>;
 #declare rdo=<-.900855,0,.654509>;
 #declare rdp=<0,-.688192,-1.113517>;
 #declare rdq=<0,-1.113517,.688191>;
 #declare rdr=<0,.425325,-.850651>;
 #declare rds=<0,-.425325,.850651>;
 #declare rd1=<0,2.064574,.850651>;
 #declare rd2=<.809017,2.064574,.262866>;
 #declare rd3=<.5,2.064574,-.688191>;
 #declare rd4=<-.5,2.064574,-.688191>;
 #declare rd5=<-.809017,2.064574,.262866>;
 #declare rd6=<-.5,1.538843,-1.538842>;
 #declare rd7=<.5,1.538843,-1.538842>;
 #declare rd8=<.809017,.688191,-1.964168>;
 #declare rd9=<0,.162459,-2.227034>;
 #declare rd10=<-.809017,.688191,-1.964168>;
 #declare rd11=<-1.618034,1.538843,0>;
 #declare rd12=<-1.309017,1.538843,-.951057>;
 #declare rd13=<-1.618034,.688191,-1.376383>;
 #declare rd14=<-2.118035,.162459,-.688192>;
 #declare rd15=<-2.118035,.688191,.162460>;
 #declare rd16=<-.5,1.538843,1.538842>;
 #declare rd17=<-1.309017,1.538843,.951057>;
 #declare rd18=<-1.809018,.688191,1.113517>;
 #declare rd19=<-1.309017,.162459,1.801708>;
 #declare rd20=<-.5,.688191,2.064574>;
 #declare rd21=<1.309017,1.538843,.951057>;
 #declare rd22=<.5,1.538843,1.538842>;
 #declare rd23=<.5,.688191,2.064574>;
 #declare rd24=<1.309017,.162459,1.801708>;
 #declare rd25=<1.809018,.688191,1.113517>;
 #declare rd26=<1.309017,1.538843,-.951057>;
 #declare rd27=<1.618034,1.538843,0>;
 #declare rd28=<2.118035,.688191,.162460>;
 #declare rd29=<2.118035,.162459,-.688192>;
 #declare rd30=<1.618034,.688191,-1.376383>;
 #declare rd31=<0,-.162459,2.227034>;
 #declare rd32=<-.809017,-.688191,1.964168>;
 #declare rd33=<-.5,-1.538843,1.538842>;
 #declare rd34=<.5,-1.538843,1.538842>;
 #declare rd35=<.809017,-.688191,1.964168>;
 #declare rd36=<2.118035,-.162459,.688192>;
 #declare rd37=<1.618034,-.688191,1.376383>;
 #declare rd38=<1.309017,-1.538843,.951057>;
 #declare rd39=<1.618034,-1.538843,0>;
 #declare rd40=<2.118035,-.688191,-.162460>;
 #declare rd41=<1.309017,-.162459,-1.801708>;
 #declare rd42=<1.809018,-.688191,-1.113517>;
 #declare rd43=<1.309017,-1.538843,-.951057>;
 #declare rd44=<.5,-1.538843,-1.538842>;
 #declare rd45=<.5,-.688191,-2.064574>;
 #declare rd46=<-1.309017,-.162459,-1.801708>;
 #declare rd47=<-.5,-.688191,-2.064574>;
 #declare rd48=<-.5,-1.538843,-1.538842>;
 #declare rd49=<-1.309017,-1.538843,-.951057>;
 #declare rd50=<-1.809018,-.688191,-1.113517>;
 #declare rd51=<-2.118035,-.162459,.688192>;
 #declare rd52=<-2.118035,-.688191,-.162460>;
 #declare rd53=<-1.618034,-1.538843,0>;
 #declare rd54=<-1.309017,-1.538843,.951057>;
 #declare rd55=<-1.618034,-.688191,1.376383>;
 #declare rd56=<0,-2.064574,-.850651>;
 #declare rd57=<-.809017,-2.064574,-.262866>;
 #declare rd58=<-.5,-2.064574,.688191>;
 #declare rd59=<.5,-2.064574,.688191>;
 #declare rd60=<.809017,-2.064574,-.262866>;
          
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, rdb}
   plane{rdf, rde inverse texture{tex1}}
   plane{rdg, rde inverse texture{tex1}}
   #declare loop=0;
   #while (loop<5)   
   plane{rdh, rdc inverse texture{tex3} rotate<0,loop*72,0>}
   plane{rdi, rdc inverse texture{tex3} rotate<0,loop*72,0>}
   plane{rdj, rdc inverse texture{tex3} rotate<0,loop*72,0>}
   plane{rdk, rdc inverse texture{tex3} rotate<0,loop*72,0>}
   plane{rdl, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdm, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdn, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdo, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdp, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdq, rdd inverse texture{tex2} rotate<0,loop*72,0>}
   plane{rdr, rde inverse texture{tex1} rotate<0,loop*72,0>}
   plane{rds, rde inverse texture{tex1} rotate<0,loop*72,0>}                  
   #declare loop=loop+1;
   #end
   
   scale rda
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     cylinder {rd1 rd2 (radiuss/rda) }
     cylinder {rd2 rd3 (radiuss/rda) }
     cylinder {rd3 rd4 (radiuss/rda) }
     cylinder {rd4 rd5 (radiuss/rda) }
     cylinder {rd5 rd1 (radiuss/rda) }
     cylinder {rd6 rd7 (radiuss/rda) }
     cylinder {rd7 rd8 (radiuss/rda) }
     cylinder {rd8 rd9 (radiuss/rda) }
     cylinder {rd9 rd10 (radiuss/rda) }
     cylinder {rd10 rd6 (radiuss/rda) }
     cylinder {rd11 rd12 (radiuss/rda) }
     cylinder {rd12 rd13 (radiuss/rda) }
     cylinder {rd13 rd14 (radiuss/rda) }
     cylinder {rd14 rd15 (radiuss/rda) }
     cylinder {rd15 rd11 (radiuss/rda) }
     cylinder {rd16 rd17 (radiuss/rda) }
     cylinder {rd17 rd18 (radiuss/rda) }
     cylinder {rd18 rd19 (radiuss/rda) }
     cylinder {rd19 rd20 (radiuss/rda) }
     cylinder {rd20 rd16 (radiuss/rda) }
     cylinder {rd21 rd22 (radiuss/rda) }
     cylinder {rd22 rd23 (radiuss/rda) }
     cylinder {rd23 rd24 (radiuss/rda) }
     cylinder {rd24 rd25 (radiuss/rda) }
     cylinder {rd25 rd21 (radiuss/rda) }
     cylinder {rd26 rd27 (radiuss/rda) }
     cylinder {rd27 rd28 (radiuss/rda) }
     cylinder {rd28 rd29 (radiuss/rda) }
     cylinder {rd29 rd30 (radiuss/rda) }
     cylinder {rd30 rd26 (radiuss/rda) }
     cylinder {rd31 rd32 (radiuss/rda) }
     cylinder {rd32 rd33 (radiuss/rda) }
     cylinder {rd33 rd34 (radiuss/rda) }
     cylinder {rd34 rd35 (radiuss/rda) }
     cylinder {rd35 rd31 (radiuss/rda) }
     cylinder {rd36 rd37 (radiuss/rda) }
     cylinder {rd37 rd38 (radiuss/rda) }
     cylinder {rd38 rd39 (radiuss/rda) }
     cylinder {rd39 rd40 (radiuss/rda) }
     cylinder {rd40 rd36 (radiuss/rda) }
     cylinder {rd41 rd42 (radiuss/rda) }
     cylinder {rd42 rd43 (radiuss/rda) }
     cylinder {rd43 rd44 (radiuss/rda) }
     cylinder {rd44 rd45 (radiuss/rda) }
     cylinder {rd45 rd41 (radiuss/rda) }
     cylinder {rd46 rd47 (radiuss/rda) }
     cylinder {rd47 rd48 (radiuss/rda) }
     cylinder {rd48 rd49 (radiuss/rda) }
     cylinder {rd49 rd50 (radiuss/rda) }
     cylinder {rd50 rd46 (radiuss/rda) }
     cylinder {rd51 rd52 (radiuss/rda) }
     cylinder {rd52 rd53 (radiuss/rda) }
     cylinder {rd53 rd54 (radiuss/rda) }
     cylinder {rd54 rd55 (radiuss/rda) }
     cylinder {rd55 rd51 (radiuss/rda) }
     cylinder {rd56 rd57 (radiuss/rda) }
     cylinder {rd57 rd58 (radiuss/rda) }
     cylinder {rd58 rd59 (radiuss/rda) }
     cylinder {rd59 rd60 (radiuss/rda) }
     cylinder {rd60 rd56 (radiuss/rda) }
     cylinder {rd1 rd16 (radiuss/rda) }
     cylinder {rd16 rd22 (radiuss/rda) }
     cylinder {rd22 rd1 (radiuss/rda) }
     cylinder {rd2 rd21 (radiuss/rda) }
     cylinder {rd21 rd27 (radiuss/rda) }
     cylinder {rd27 rd2 (radiuss/rda) }
     cylinder {rd3 rd26 (radiuss/rda) }
     cylinder {rd26 rd7 (radiuss/rda) }
     cylinder {rd7 rd3 (radiuss/rda) }
     cylinder {rd4 rd6 (radiuss/rda) }
     cylinder {rd6 rd12 (radiuss/rda) }
     cylinder {rd12 rd4 (radiuss/rda) }
     cylinder {rd5 rd11 (radiuss/rda) }
     cylinder {rd11 rd17 (radiuss/rda) }
     cylinder {rd17 rd5 (radiuss/rda) }
     cylinder {rd20 rd31 (radiuss/rda) }
     cylinder {rd31 rd23 (radiuss/rda) }
     cylinder {rd23 rd20 (radiuss/rda) }
     cylinder {rd24 rd35 (radiuss/rda) }
     cylinder {rd35 rd37 (radiuss/rda) }
     cylinder {rd37 rd24 (radiuss/rda) }
     cylinder {rd25 rd36 (radiuss/rda) }
     cylinder {rd36 rd28 (radiuss/rda) }
     cylinder {rd28 rd25 (radiuss/rda) }
     cylinder {rd29 rd40 (radiuss/rda) }
     cylinder {rd40 rd42 (radiuss/rda) }
     cylinder {rd42 rd29 (radiuss/rda) }
     cylinder {rd30 rd41 (radiuss/rda) }
     cylinder {rd41 rd8 (radiuss/rda) }
     cylinder {rd8 rd30 (radiuss/rda) }
     cylinder {rd9 rd45 (radiuss/rda) }
     cylinder {rd45 rd47 (radiuss/rda) }
     cylinder {rd47 rd9 (radiuss/rda) }
     cylinder {rd10 rd46 (radiuss/rda) }
     cylinder {rd46 rd13 (radiuss/rda) }
     cylinder {rd13 rd10 (radiuss/rda) }
     cylinder {rd14 rd50 (radiuss/rda) }
     cylinder {rd50 rd52 (radiuss/rda) }
     cylinder {rd52 rd14 (radiuss/rda) }
     cylinder {rd15 rd51 (radiuss/rda) }
     cylinder {rd51 rd18 (radiuss/rda) }
     cylinder {rd18 rd15 (radiuss/rda) }
     cylinder {rd19 rd55 (radiuss/rda) }
     cylinder {rd55 rd32 (radiuss/rda) }
     cylinder {rd32 rd19 (radiuss/rda) }
     cylinder {rd56 rd48 (radiuss/rda) }
     cylinder {rd48 rd44 (radiuss/rda) }
     cylinder {rd44 rd56 (radiuss/rda) }
     cylinder {rd57 rd53 (radiuss/rda) }
     cylinder {rd53 rd49 (radiuss/rda) }
     cylinder {rd49 rd57 (radiuss/rda) }
     cylinder {rd58 rd33 (radiuss/rda) }
     cylinder {rd33 rd54 (radiuss/rda) }
     cylinder {rd54 rd58 (radiuss/rda) }
     cylinder {rd59 rd38 (radiuss/rda) }
     cylinder {rd38 rd34 (radiuss/rda) }
     cylinder {rd34 rd59 (radiuss/rda) }
     cylinder {rd60 rd43 (radiuss/rda) }
     cylinder {rd43 rd39 (radiuss/rda) }
     cylinder {rd39 rd60 (radiuss/rda) }               

     sphere {rd1 (radiuss/rda)}
     sphere {rd2 (radiuss/rda)}
     sphere {rd3 (radiuss/rda)}
     sphere {rd4 (radiuss/rda)}
     sphere {rd5 (radiuss/rda)}
     sphere {rd6 (radiuss/rda)}
     sphere {rd7 (radiuss/rda)}
     sphere {rd8 (radiuss/rda)}
     sphere {rd9 (radiuss/rda)}
     sphere {rd10 (radiuss/rda)}
     sphere {rd11 (radiuss/rda)}
     sphere {rd12 (radiuss/rda)}
     sphere {rd13 (radiuss/rda)}
     sphere {rd14 (radiuss/rda)}
     sphere {rd15 (radiuss/rda)}
     sphere {rd16 (radiuss/rda)}
     sphere {rd17 (radiuss/rda)}
     sphere {rd18 (radiuss/rda)}
     sphere {rd19 (radiuss/rda)}
     sphere {rd20 (radiuss/rda)}
     sphere {rd21 (radiuss/rda)}
     sphere {rd22 (radiuss/rda)}
     sphere {rd23 (radiuss/rda)}
     sphere {rd24 (radiuss/rda)}
     sphere {rd25 (radiuss/rda)}
     sphere {rd26 (radiuss/rda)}
     sphere {rd27 (radiuss/rda)}
     sphere {rd28 (radiuss/rda)}
     sphere {rd29 (radiuss/rda)}
     sphere {rd30 (radiuss/rda)}
     sphere {rd31 (radiuss/rda)}
     sphere {rd32 (radiuss/rda)}
     sphere {rd33 (radiuss/rda)}
     sphere {rd34 (radiuss/rda)}
     sphere {rd35 (radiuss/rda)}
     sphere {rd36 (radiuss/rda)}
     sphere {rd37 (radiuss/rda)}
     sphere {rd38 (radiuss/rda)}
     sphere {rd39 (radiuss/rda)}
     sphere {rd40 (radiuss/rda)}
     sphere {rd41 (radiuss/rda)}
     sphere {rd42 (radiuss/rda)}
     sphere {rd43 (radiuss/rda)}
     sphere {rd44 (radiuss/rda)}
     sphere {rd45 (radiuss/rda)}
     sphere {rd46 (radiuss/rda)}
     sphere {rd47 (radiuss/rda)}
     sphere {rd48 (radiuss/rda)}
     sphere {rd49 (radiuss/rda)}
     sphere {rd50 (radiuss/rda)}
     sphere {rd51 (radiuss/rda)}
     sphere {rd52 (radiuss/rda)}
     sphere {rd53 (radiuss/rda)}
     sphere {rd54 (radiuss/rda)}
     sphere {rd55 (radiuss/rda)}
     sphere {rd56 (radiuss/rda)}
     sphere {rd57 (radiuss/rda)}
     sphere {rd58 (radiuss/rda)}
     sphere {rd59 (radiuss/rda)}
     sphere {rd60 (radiuss/rda)}                                                  

     scale rda
     texture{tex1} 
    }
  #end   
 #end
#break

#case(18)
//truncated icosidodecahedron
 #declare tna=1;
 #declare tnb=3.802396;
 #declare tnc=3.736069;
 #declare tnd=3.668544;
 #declare tne=3.440956;     
 #declare tnf=<0,1,0>;
 #declare tng=<0,-1,0>;
 #declare tnh=<0,.425326,.850651>;
 #declare tni=<0,-.425326,-.850651>;
 #declare tnj=<0,1.113517,-.850651>;
 #declare tnk=<0,.262866,-1.376383>;
 #declare tnl=<0,-.262866,1.376383>;
 #declare tnm=<0,-1.113517,.850651>;
 #declare tnn=<0,.688192,.425326>;
 #declare tno=<0,.425326,-.688191>;
 #declare tnp=<.25,0,.769421>;
 #declare tnq=<-.25,0,.769421>;
 #declare tnr=<0,-.425326,.688191>;
 #declare tns=<0,-.688192,-.425326>;       
 #declare tnt=1.618034;
 #declare tnu=3.141592654/180;
 #declare tnv=-63.434949;
 #declare tn=array[121]
 #declare loop1=0;
 #while (loop1<10)
  #declare x1=tnt*cos( (108-loop1*36.0)*tnu );
  #declare z1=tnt*sin( (108-loop1*36.0)*tnu );
  #declare y1=tne;
  #declare tn[(loop1+1)]=<x1,y1,z1>;
  #declare tn[(loop1+111)]=<-1*x1,-1*y1,-1*z1>;
  #declare z1=-1*z1;
  #declare x2=x1;
  #declare z2=(z1*cos( tnv*tnu ))-(y1*sin( tnv*tnu ));
  #declare y2=(z1*sin( tnv*tnu ))+(y1*cos( tnv*tnu ));
  #declare loop2=0;
  #while(loop2<5)
  #declare angle1=(loop2*-72)*tnu;
  #declare x3=(x2*cos(angle1))-(z2*sin(angle1));
  #declare z3=(x2*sin(angle1))+(z2*cos(angle1));
  #declare y3=y2;
  #declare tn[((loop1+1)+((loop2+1)*10))]=<x3,y3,z3>;
  #declare tn[((loop1+1)+((loop2+1)*10)+50)]=<-1*x3,-1*y3,-1*z3>;  
  #declare loop2=loop2+1;
  #end 
  #declare loop1=loop1+1;
 #end 
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, tnb}
   plane{tnf, tne inverse texture{tex1}}
   plane{tng, tne inverse texture{tex1}}   
   #declare loop=0;
   #while (loop<5)
   plane{tnh, tne inverse texture{tex1} rotate <0,loop*72,0>}
   plane{tni, tne inverse texture{tex1} rotate <0,loop*72,0>}
   plane{tnj, tnd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tnk, tnd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tnl, tnd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tnm, tnd inverse texture{tex2} rotate <0,loop*72,0>}
   plane{tnn, tnc inverse texture{tex3} rotate <0,loop*72,0>}
   plane{tno, tnc inverse texture{tex3} rotate <0,loop*72,0>}
   plane{tnp, tnc inverse texture{tex3} rotate <0,loop*72,0>}
   plane{tnq, tnc inverse texture{tex3} rotate <0,loop*72,0>}
   plane{tnr, tnc inverse texture{tex3} rotate <0,loop*72,0>}
   plane{tns, tnc inverse texture{tex3} rotate <0,loop*72,0>}                  
   #declare loop=loop+1;
   #end
   
   scale tna
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     #declare loop1=0;
     #while (loop1<12)
      #declare loop2=0;
      #declare index=loop1*10;
       cylinder {tn[(index+loop2+10)] tn[index+loop2+1] (radiuss/tna) }
      #while (loop2<9)
       cylinder {tn[(index+loop2+1)] tn[index+loop2+2] (radiuss/tna) }
      #declare loop2=loop2+1;
      #end
     #declare loop1=loop1+1; 
     #end
     cylinder {tn[1] tn[11] (radiuss/tna) }
     cylinder {tn[2] tn[12] (radiuss/tna) }
     cylinder {tn[3] tn[21] (radiuss/tna) }
     cylinder {tn[4] tn[22] (radiuss/tna) }
     cylinder {tn[5] tn[31] (radiuss/tna) }
     cylinder {tn[6] tn[32] (radiuss/tna) }
     cylinder {tn[7] tn[41] (radiuss/tna) }
     cylinder {tn[8] tn[42] (radiuss/tna) }
     cylinder {tn[9] tn[51] (radiuss/tna) }
     cylinder {tn[10] tn[52] (radiuss/tna) }
     cylinder {tn[53] tn[20] (radiuss/tna) }
     cylinder {tn[54] tn[19] (radiuss/tna) }
     cylinder {tn[13] tn[30] (radiuss/tna) }
     cylinder {tn[14] tn[29] (radiuss/tna) }
     cylinder {tn[23] tn[40] (radiuss/tna) }
     cylinder {tn[24] tn[39] (radiuss/tna) }
     cylinder {tn[33] tn[50] (radiuss/tna) }
     cylinder {tn[34] tn[49] (radiuss/tna) }
     cylinder {tn[43] tn[60] (radiuss/tna) }
     cylinder {tn[44] tn[59] (radiuss/tna) }
     cylinder {tn[18] tn[86] (radiuss/tna) }
     cylinder {tn[17] tn[85] (radiuss/tna) }
     cylinder {tn[16] tn[98] (radiuss/tna) }
     cylinder {tn[15] tn[97] (radiuss/tna) }
     cylinder {tn[28] tn[96] (radiuss/tna) }
     cylinder {tn[27] tn[95] (radiuss/tna) }
     cylinder {tn[26] tn[108] (radiuss/tna) }
     cylinder {tn[25] tn[107] (radiuss/tna) }
     cylinder {tn[38] tn[106] (radiuss/tna) }
     cylinder {tn[37] tn[105] (radiuss/tna) }
     cylinder {tn[36] tn[68] (radiuss/tna) }
     cylinder {tn[35] tn[67] (radiuss/tna) }
     cylinder {tn[48] tn[66] (radiuss/tna) }
     cylinder {tn[47] tn[65] (radiuss/tna) }
     cylinder {tn[46] tn[78] (radiuss/tna) }
     cylinder {tn[45] tn[77] (radiuss/tna) }
     cylinder {tn[58] tn[76] (radiuss/tna) }
     cylinder {tn[57] tn[75] (radiuss/tna) }
     cylinder {tn[56] tn[88] (radiuss/tna) }
     cylinder {tn[55] tn[87] (radiuss/tna) }
     cylinder {tn[84] tn[99] (radiuss/tna) }
     cylinder {tn[83] tn[100] (radiuss/tna) }
     cylinder {tn[94] tn[109] (radiuss/tna) }
     cylinder {tn[93] tn[110] (radiuss/tna) }
     cylinder {tn[104] tn[69] (radiuss/tna) }
     cylinder {tn[103] tn[70] (radiuss/tna) }
     cylinder {tn[64] tn[79] (radiuss/tna) }
     cylinder {tn[63] tn[80] (radiuss/tna) }
     cylinder {tn[74] tn[89] (radiuss/tna) }
     cylinder {tn[73] tn[90] (radiuss/tna) }
     cylinder {tn[61] tn[111] (radiuss/tna) }
     cylinder {tn[62] tn[112] (radiuss/tna) }
     cylinder {tn[71] tn[113] (radiuss/tna) }
     cylinder {tn[72] tn[114] (radiuss/tna) }
     cylinder {tn[81] tn[115] (radiuss/tna) }
     cylinder {tn[82] tn[116] (radiuss/tna) }
     cylinder {tn[91] tn[117] (radiuss/tna) }
     cylinder {tn[92] tn[118] (radiuss/tna) }
     cylinder {tn[101] tn[119] (radiuss/tna) }
     cylinder {tn[102] tn[120] (radiuss/tna) }               
      
     #declare loop=0;
     #while (loop<120)
      sphere {tn[(loop+1)] (radiuss/tna)}
      #declare loop=loop+1;
     #end

     scale tna
     texture{tex1} 
    }
  #end   
 #end
#break

#case(19)
//snub dodecahedron, left-handed
 #declare sda=1;
 #declare sdb=2.155837;
 #declare sdc=1.980916;
 #declare sdd=2.077090; 
 #declare sde=<0,1,0>;
 #declare sdf=<0,-1,0>;
 #declare sdg=<0,.425326,-.850651>;
 #declare sdh=<0,-.425326,.850651>;
 #declare sd=array[61]
 #declare sdt=.850651;
 #declare sdu=3.141592654/180;
 #declare sdv=63.434949;
 #declare sd=array[61]
 #declare loop1=0;
 #while (loop1<5)
  #declare sdw=(270+22.893595-(loop1*72.0))*sdu;
  #declare x1=sdt*cos( sdw );
  #declare z1=sdt*sin( sdw );
  #declare y1=sdc;
  #declare sd[(loop1+1)]=<x1,y1,z1>;
  #declare z1=-1*z1;
  #declare y1=-1*y1;
  #declare sd[(loop1+56)]=<x1,y1,z1>;
  #declare sdw=(90+22.893595+(loop1*72.0))*sdu;
  #declare x1=sdt*cos( sdw );
  #declare z1=sdt*sin( sdw );
  #declare y1=sdc;  
  #declare x2=x1;
  #declare sdw=sdv*sdu;
  #declare z2=(z1*cos( sdw ))-(y1*sin( sdw ));
  #declare y2=(z1*sin( sdw ))+(y1*cos( sdw ));
  #declare x3=x1;
  #declare z3=-1*z2;
  #declare y3=-1*y2;
  #declare loop2=0;
  #while(loop2<5)
  #declare angle1=(loop2*72)*sdu;
  #declare x4=(x2*cos(angle1))-(z2*sin(angle1));
  #declare z4=(x2*sin(angle1))+(z2*cos(angle1));
  #declare y4=y2;
  #declare sd[((loop1+1)+((loop2+1)*5))]=<x4,y4,z4>;
  #declare x5=(x3*cos(angle1))-(z3*sin(angle1));
  #declare z5=(x3*sin(angle1))+(z3*cos(angle1));
  #declare y5=y3; 
  #declare sd[((loop1+1)+((loop2+1)*5)+25)]=<x5,y5,z5>;
  #declare loop2=loop2+1;
  #end 
  #declare loop1=loop1+1;
 #end 
 #declare snvec=array[16]
 # declare snvec[0]=(sd[1]+sd[2]+sd[6])/3;
 # declare snvec[1]=(sd[1]+sd[6]+sd[10])/3;
 # declare snvec[2]=(sd[1]+sd[10]+sd[11])/3;
 # declare snvec[3]=(sd[10]+sd[11]+sd[12])/3;
 # declare snvec[4]=(sd[9]+sd[10]+sd[12])/3;
 # declare snvec[5]=(sd[9]+sd[12]+sd[48])/3;
 # declare snvec[6]=(sd[12]+sd[13]+sd[48])/3;
 # declare snvec[7]=(sd[13]+sd[47]+sd[48])/3;
 # declare snvec[8]=(sd[9]+sd[48]+sd[49])/3;
 # declare snvec[9]=(sd[9]+sd[8]+sd[49])/3;
 # declare snvec[10]=(sd[8]+sd[42]+sd[49])/3;
 # declare snvec[11]=(sd[42]+sd[49]+sd[50])/3;
 # declare snvec[12]=(sd[41]+sd[42]+sd[50])/3;
 # declare snvec[13]=(sd[41]+sd[50]+sd[59])/3;
 # declare snvec[14]=(sd[41]+sd[58]+sd[59])/3;
 # declare snvec[15]=(sd[41]+sd[45]+sd[58])/3;     
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, sdb}
   plane{sde, sdc inverse texture{tex1}}
   plane{sdf, sdc inverse texture{tex1}}
   #declare loop=0;
   #while (loop<5)
   plane{sdg, sdc inverse texture{tex1} rotate <0,loop*72,0>}
   plane{sdh, sdc inverse texture{tex1} rotate <0,loop*72,0>}   
   #declare loop=loop+1;
   #end
   #declare loop1=0;
   #while(loop1<16) 
    #declare loop2=0;
    #while (loop2<5)
     plane{snvec[loop1], sdd inverse texture{tex2} rotate <0,loop2*72,0> }
     #declare loop2=loop2+1;
    #end
    #declare loop1=loop1+1;
   #end
   
   scale sda
   texture{tex1} 
   scale <-1,1,1>
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     #declare loop1=0;
     #while (loop1<12)
      #declare loop2=0;
      cylinder {sd[loop2+5+(loop1*5)] sd[loop2+1+(loop1*5)] (radiuss/sda) }
      #while (loop2<4)
       cylinder {sd[loop2+1+(loop1*5)] sd[loop2+2+(loop1*5)] (radiuss/sda) }
       #declare loop2=loop2+1;
      #end
      #declare loop1=loop1+1;
     #end  
     cylinder {sd[1] sd[11] (radiuss/sda)}
     cylinder {sd[1] sd[10] (radiuss/sda)}
     cylinder {sd[1] sd[6] (radiuss/sda)}
     cylinder {sd[2] sd[6] (radiuss/sda)}
     cylinder {sd[2] sd[30] (radiuss/sda)}
     cylinder {sd[2] sd[26] (radiuss/sda)}
     cylinder {sd[3] sd[26] (radiuss/sda)}
     cylinder {sd[3] sd[25] (radiuss/sda)}
     cylinder {sd[3] sd[21] (radiuss/sda)}
     cylinder {sd[4] sd[21] (radiuss/sda)}
     cylinder {sd[4] sd[20] (radiuss/sda)}
     cylinder {sd[4] sd[16] (radiuss/sda)}
     cylinder {sd[5] sd[16] (radiuss/sda)}
     cylinder {sd[5] sd[15] (radiuss/sda)}
     cylinder {sd[5] sd[11] (radiuss/sda)}
     cylinder {sd[11] sd[10] (radiuss/sda)}
     cylinder {sd[6] sd[30] (radiuss/sda)}
     cylinder {sd[26] sd[25] (radiuss/sda)}
     cylinder {sd[21] sd[20] (radiuss/sda)}
     cylinder {sd[16] sd[15] (radiuss/sda)}
     cylinder {sd[10] sd[12] (radiuss/sda)}
     cylinder {sd[30] sd[7] (radiuss/sda)}
     cylinder {sd[25] sd[27] (radiuss/sda)}
     cylinder {sd[20] sd[22] (radiuss/sda)}
     cylinder {sd[15] sd[17] (radiuss/sda)}
     cylinder {sd[9] sd[12] (radiuss/sda)}
     cylinder {sd[7] sd[29] (radiuss/sda)}
     cylinder {sd[27] sd[24] (radiuss/sda)}
     cylinder {sd[22] sd[19] (radiuss/sda)}
     cylinder {sd[17] sd[14] (radiuss/sda)}
     cylinder {sd[9] sd[48] (radiuss/sda)}
     cylinder {sd[9] sd[49] (radiuss/sda)}
     cylinder {sd[8] sd[49] (radiuss/sda)}
     cylinder {sd[8] sd[42] (radiuss/sda)}
     cylinder {sd[8] sd[43] (radiuss/sda)}
     cylinder {sd[7] sd[43] (radiuss/sda)}
     cylinder {sd[29] sd[43] (radiuss/sda)}
     cylinder {sd[29] sd[44] (radiuss/sda)}
     cylinder {sd[28] sd[44] (radiuss/sda)}
     cylinder {sd[28] sd[37] (radiuss/sda)}
     cylinder {sd[28] sd[38] (radiuss/sda)}
     cylinder {sd[27] sd[38] (radiuss/sda)}
     cylinder {sd[24] sd[38] (radiuss/sda)}
     cylinder {sd[24] sd[39] (radiuss/sda)}
     cylinder {sd[23] sd[39] (radiuss/sda)}
     cylinder {sd[23] sd[32] (radiuss/sda)}
     cylinder {sd[23] sd[33] (radiuss/sda)}
     cylinder {sd[22] sd[33] (radiuss/sda)}
     cylinder {sd[19] sd[33] (radiuss/sda)}
     cylinder {sd[19] sd[34] (radiuss/sda)}
     cylinder {sd[18] sd[34] (radiuss/sda)}
     cylinder {sd[18] sd[52] (radiuss/sda)}
     cylinder {sd[18] sd[53] (radiuss/sda)}
     cylinder {sd[17] sd[53] (radiuss/sda)}
     cylinder {sd[14] sd[53] (radiuss/sda)}
     cylinder {sd[14] sd[54] (radiuss/sda)}
     cylinder {sd[13] sd[54] (radiuss/sda)}
     cylinder {sd[13] sd[47] (radiuss/sda)}
     cylinder {sd[13] sd[48] (radiuss/sda)}
     cylinder {sd[12] sd[48] (radiuss/sda)}
     cylinder {sd[49] sd[42] (radiuss/sda)}
     cylinder {sd[44] sd[37] (radiuss/sda)}
     cylinder {sd[39] sd[32] (radiuss/sda)}
     cylinder {sd[34] sd[52] (radiuss/sda)}
     cylinder {sd[54] sd[47] (radiuss/sda)}
     cylinder {sd[42] sd[50] (radiuss/sda)}
     cylinder {sd[37] sd[45] (radiuss/sda)}
     cylinder {sd[32] sd[40] (radiuss/sda)}
     cylinder {sd[52] sd[35] (radiuss/sda)}
     cylinder {sd[47] sd[55] (radiuss/sda)}
     cylinder {sd[50] sd[41] (radiuss/sda)}
     cylinder {sd[45] sd[36] (radiuss/sda)}
     cylinder {sd[40] sd[31] (radiuss/sda)}
     cylinder {sd[35] sd[51] (radiuss/sda)}
     cylinder {sd[55] sd[46] (radiuss/sda)}
     cylinder {sd[59] sd[46] (radiuss/sda)}
     cylinder {sd[59] sd[50] (radiuss/sda)}
     cylinder {sd[59] sd[41] (radiuss/sda)}
     cylinder {sd[58] sd[41] (radiuss/sda)}
     cylinder {sd[58] sd[45] (radiuss/sda)}
     cylinder {sd[58] sd[36] (radiuss/sda)}
     cylinder {sd[57] sd[36] (radiuss/sda)}
     cylinder {sd[57] sd[40] (radiuss/sda)}
     cylinder {sd[57] sd[31] (radiuss/sda)}
     cylinder {sd[56] sd[31] (radiuss/sda)}
     cylinder {sd[56] sd[35] (radiuss/sda)}
     cylinder {sd[56] sd[51] (radiuss/sda)}
     cylinder {sd[60] sd[51] (radiuss/sda)}
     cylinder {sd[60] sd[55] (radiuss/sda)}
     cylinder {sd[60] sd[46] (radiuss/sda)}                    
     #declare loop=0;
     #while (loop<60)
     sphere {sd[loop+1] (radiuss/sda)}
     #declare loop=loop+1;
     #end
     
     scale sda
     texture{tex1} 
     scale <-1,1,1>
    }
  #end   
 #end
#break

#case(20)
//snub dodecahedron, right-handed
 #declare sda=1;
 #declare sdb=2.155837;
 #declare sdc=1.980916;
 #declare sdd=2.077090; 
 #declare sde=<0,1,0>;
 #declare sdf=<0,-1,0>;
 #declare sdg=<0,.425326,-.850651>;
 #declare sdh=<0,-.425326,.850651>;
 #declare sd=array[61]
 #declare sdt=.850651;
 #declare sdu=3.141592654/180;
 #declare sdv=63.434949;
 #declare sd=array[61]
 #declare loop1=0;
 #while (loop1<5)
  #declare sdw=(270+22.893595-(loop1*72.0))*sdu;
  #declare x1=sdt*cos( sdw );
  #declare z1=sdt*sin( sdw );
  #declare y1=sdc;
  #declare sd[(loop1+1)]=<x1,y1,z1>;
  #declare z1=-1*z1;
  #declare y1=-1*y1;
  #declare sd[(loop1+56)]=<x1,y1,z1>;
  #declare sdw=(90+22.893595+(loop1*72.0))*sdu;
  #declare x1=sdt*cos( sdw );
  #declare z1=sdt*sin( sdw );
  #declare y1=sdc;  
  #declare x2=x1;
  #declare sdw=sdv*sdu;
  #declare z2=(z1*cos( sdw ))-(y1*sin( sdw ));
  #declare y2=(z1*sin( sdw ))+(y1*cos( sdw ));
  #declare x3=x1;
  #declare z3=-1*z2;
  #declare y3=-1*y2;
  #declare loop2=0;
  #while(loop2<5)
  #declare angle1=(loop2*72)*sdu;
  #declare x4=(x2*cos(angle1))-(z2*sin(angle1));
  #declare z4=(x2*sin(angle1))+(z2*cos(angle1));
  #declare y4=y2;
  #declare sd[((loop1+1)+((loop2+1)*5))]=<x4,y4,z4>;
  #declare x5=(x3*cos(angle1))-(z3*sin(angle1));
  #declare z5=(x3*sin(angle1))+(z3*cos(angle1));
  #declare y5=y3; 
  #declare sd[((loop1+1)+((loop2+1)*5)+25)]=<x5,y5,z5>;
  #declare loop2=loop2+1;
  #end 
  #declare loop1=loop1+1;
 #end 
 #declare snvec=array[16]
 # declare snvec[0]=(sd[1]+sd[2]+sd[6])/3;
 # declare snvec[1]=(sd[1]+sd[6]+sd[10])/3;
 # declare snvec[2]=(sd[1]+sd[10]+sd[11])/3;
 # declare snvec[3]=(sd[10]+sd[11]+sd[12])/3;
 # declare snvec[4]=(sd[9]+sd[10]+sd[12])/3;
 # declare snvec[5]=(sd[9]+sd[12]+sd[48])/3;
 # declare snvec[6]=(sd[12]+sd[13]+sd[48])/3;
 # declare snvec[7]=(sd[13]+sd[47]+sd[48])/3;
 # declare snvec[8]=(sd[9]+sd[48]+sd[49])/3;
 # declare snvec[9]=(sd[9]+sd[8]+sd[49])/3;
 # declare snvec[10]=(sd[8]+sd[42]+sd[49])/3;
 # declare snvec[11]=(sd[42]+sd[49]+sd[50])/3;
 # declare snvec[12]=(sd[41]+sd[42]+sd[50])/3;
 # declare snvec[13]=(sd[41]+sd[50]+sd[59])/3;
 # declare snvec[14]=(sd[41]+sd[58]+sd[59])/3;
 # declare snvec[15]=(sd[41]+sd[45]+sd[58])/3;     
 #if (asc(verzion)=115)
  difference
  {
   sphere{<0,0,0>, sdb}
   plane{sde, sdc inverse texture{tex1}}
   plane{sdf, sdc inverse texture{tex1}}
   #declare loop=0;
   #while (loop<5)
   plane{sdg, sdc inverse texture{tex1} rotate <0,loop*72,0>}
   plane{sdh, sdc inverse texture{tex1} rotate <0,loop*72,0>}   
   #declare loop=loop+1;
   #end
   #declare loop1=0;
   #while(loop1<16) 
    #declare loop2=0;
    #while (loop2<5)
     plane{snvec[loop1], sdd inverse texture{tex2} rotate <0,loop2*72,0> }
     #declare loop2=loop2+1;
    #end
    #declare loop1=loop1+1;
   #end
   
   scale sda
   texture{tex1} 
  }

 #else
  #if(asc(verzion)=102)
    merge
    {
     #declare loop1=0;
     #while (loop1<12)
      #declare loop2=0;
      cylinder {sd[loop2+5+(loop1*5)] sd[loop2+1+(loop1*5)] (radiuss/sda) }
      #while (loop2<4)
       cylinder {sd[loop2+1+(loop1*5)] sd[loop2+2+(loop1*5)] (radiuss/sda) }
       #declare loop2=loop2+1;
      #end
      #declare loop1=loop1+1;
     #end  
     cylinder {sd[1] sd[11] (radiuss/sda)}
     cylinder {sd[1] sd[10] (radiuss/sda)}
     cylinder {sd[1] sd[6] (radiuss/sda)}
     cylinder {sd[2] sd[6] (radiuss/sda)}
     cylinder {sd[2] sd[30] (radiuss/sda)}
     cylinder {sd[2] sd[26] (radiuss/sda)}
     cylinder {sd[3] sd[26] (radiuss/sda)}
     cylinder {sd[3] sd[25] (radiuss/sda)}
     cylinder {sd[3] sd[21] (radiuss/sda)}
     cylinder {sd[4] sd[21] (radiuss/sda)}
     cylinder {sd[4] sd[20] (radiuss/sda)}
     cylinder {sd[4] sd[16] (radiuss/sda)}
     cylinder {sd[5] sd[16] (radiuss/sda)}
     cylinder {sd[5] sd[15] (radiuss/sda)}
     cylinder {sd[5] sd[11] (radiuss/sda)}
     cylinder {sd[11] sd[10] (radiuss/sda)}
     cylinder {sd[6] sd[30] (radiuss/sda)}
     cylinder {sd[26] sd[25] (radiuss/sda)}
     cylinder {sd[21] sd[20] (radiuss/sda)}
     cylinder {sd[16] sd[15] (radiuss/sda)}
     cylinder {sd[10] sd[12] (radiuss/sda)}
     cylinder {sd[30] sd[7] (radiuss/sda)}
     cylinder {sd[25] sd[27] (radiuss/sda)}
     cylinder {sd[20] sd[22] (radiuss/sda)}
     cylinder {sd[15] sd[17] (radiuss/sda)}
     cylinder {sd[9] sd[12] (radiuss/sda)}
     cylinder {sd[7] sd[29] (radiuss/sda)}
     cylinder {sd[27] sd[24] (radiuss/sda)}
     cylinder {sd[22] sd[19] (radiuss/sda)}
     cylinder {sd[17] sd[14] (radiuss/sda)}
     cylinder {sd[9] sd[48] (radiuss/sda)}
     cylinder {sd[9] sd[49] (radiuss/sda)}
     cylinder {sd[8] sd[49] (radiuss/sda)}
     cylinder {sd[8] sd[42] (radiuss/sda)}
     cylinder {sd[8] sd[43] (radiuss/sda)}
     cylinder {sd[7] sd[43] (radiuss/sda)}
     cylinder {sd[29] sd[43] (radiuss/sda)}
     cylinder {sd[29] sd[44] (radiuss/sda)}
     cylinder {sd[28] sd[44] (radiuss/sda)}
     cylinder {sd[28] sd[37] (radiuss/sda)}
     cylinder {sd[28] sd[38] (radiuss/sda)}
     cylinder {sd[27] sd[38] (radiuss/sda)}
     cylinder {sd[24] sd[38] (radiuss/sda)}
     cylinder {sd[24] sd[39] (radiuss/sda)}
     cylinder {sd[23] sd[39] (radiuss/sda)}
     cylinder {sd[23] sd[32] (radiuss/sda)}
     cylinder {sd[23] sd[33] (radiuss/sda)}
     cylinder {sd[22] sd[33] (radiuss/sda)}
     cylinder {sd[19] sd[33] (radiuss/sda)}
     cylinder {sd[19] sd[34] (radiuss/sda)}
     cylinder {sd[18] sd[34] (radiuss/sda)}
     cylinder {sd[18] sd[52] (radiuss/sda)}
     cylinder {sd[18] sd[53] (radiuss/sda)}
     cylinder {sd[17] sd[53] (radiuss/sda)}
     cylinder {sd[14] sd[53] (radiuss/sda)}
     cylinder {sd[14] sd[54] (radiuss/sda)}
     cylinder {sd[13] sd[54] (radiuss/sda)}
     cylinder {sd[13] sd[47] (radiuss/sda)}
     cylinder {sd[13] sd[48] (radiuss/sda)}
     cylinder {sd[12] sd[48] (radiuss/sda)}
     cylinder {sd[49] sd[42] (radiuss/sda)}
     cylinder {sd[44] sd[37] (radiuss/sda)}
     cylinder {sd[39] sd[32] (radiuss/sda)}
     cylinder {sd[34] sd[52] (radiuss/sda)}
     cylinder {sd[54] sd[47] (radiuss/sda)}
     cylinder {sd[42] sd[50] (radiuss/sda)}
     cylinder {sd[37] sd[45] (radiuss/sda)}
     cylinder {sd[32] sd[40] (radiuss/sda)}
     cylinder {sd[52] sd[35] (radiuss/sda)}
     cylinder {sd[47] sd[55] (radiuss/sda)}
     cylinder {sd[50] sd[41] (radiuss/sda)}
     cylinder {sd[45] sd[36] (radiuss/sda)}
     cylinder {sd[40] sd[31] (radiuss/sda)}
     cylinder {sd[35] sd[51] (radiuss/sda)}
     cylinder {sd[55] sd[46] (radiuss/sda)}
     cylinder {sd[59] sd[46] (radiuss/sda)}
     cylinder {sd[59] sd[50] (radiuss/sda)}
     cylinder {sd[59] sd[41] (radiuss/sda)}
     cylinder {sd[58] sd[41] (radiuss/sda)}
     cylinder {sd[58] sd[45] (radiuss/sda)}
     cylinder {sd[58] sd[36] (radiuss/sda)}
     cylinder {sd[57] sd[36] (radiuss/sda)}
     cylinder {sd[57] sd[40] (radiuss/sda)}
     cylinder {sd[57] sd[31] (radiuss/sda)}
     cylinder {sd[56] sd[31] (radiuss/sda)}
     cylinder {sd[56] sd[35] (radiuss/sda)}
     cylinder {sd[56] sd[51] (radiuss/sda)}
     cylinder {sd[60] sd[51] (radiuss/sda)}
     cylinder {sd[60] sd[55] (radiuss/sda)}
     cylinder {sd[60] sd[46] (radiuss/sda)}                    
     #declare loop=0;
     #while (loop<60)
     sphere {sd[loop+1] (radiuss/sda)}
     #declare loop=loop+1;
     #end
     
     scale sda
     texture{tex1} 
    }
  #end   
 #end
#break

#else
 #error
  "polyhedral.inc error: invalid tiipe used, check list in polyhedral.inc\n"

#end//of switch directive

#end //of macro
