// original this code is used for the valves from an engine 

camera { location <0,2,-6>
         look_at    <0,2.5,0>
         angle 9 }

// set: clock 0 => 0.99; cyclic_animation = on

light_source { 0*x        
               color rgb     <1,1,1>
               spotlight        
               translate <10,20,-10>
               point_at    <0,2.5,0>     
               radius            15              
               tightness        100           
               falloff           28 }

#declare subseg = intersection {
  torus { 1,0.125 }
  prism { linear_sweep linear_spline -0.150,0.150,4,
          <0,0>,<1.5*sin(-0.95*(2*pi/36)),1.5*cos(-0.95*(2*pi/36))>,
          <1.5*sin( 0.95*(2*pi/36)),1.5*cos( 0.95*(2*pi/36))>,<0,0> }
          pigment { color rgb 1 }
          finish { ambient 0.3 diffuse 0.5 specular 0.6 }}

#declare ft = 2*pi/72

#switch (clock) 
  #range (  0    , 0.035) 
    #declare dwe = 1.175-(2*clock)
    #break
  #range (  0.035, 0.275) 
    #declare dwe = 1.105
    #break
  #range (  0.275, 0.310) 
    #declare dwe = 1.105+(2*(clock-0.275))
    #break
  #range (  0.310, 1.000) 
    #declare dwe = 1.175
    #break
  #range (  1.000, 1.035) 
    #declare dwe = 1.175-(2*(clock-1))
    #break
  #range (  1.035, 1.275) 
    #declare dwe = 1.105
    #break
  #range (  1.275, 1.310) 
    #declare dwe = 1.105+(2*(clock-1.275))
    #break
  #range (  1.310, 2.000) 
    #declare dwe = 1.175
    #break
  #range (  2.000, 2.035) 
    #declare dwe = 1.175-(2*(clock-2))
    #break
  #range (  2.035, 2.275) 
    #declare dwe = 1.105
    #break
  #range (  2.275, 2.310) 
    #declare dwe = 1.105+(2*(clock-2.275))
    #break
  #range (  2.310, 3.000) 
    #declare dwe = 1.175
    #break
  #range (  3.000, 3.035) 
    #declare dwe = 1.175-(2*(clock-3))
    #break
  #range (  3.035, 3.275) 
    #declare dwe = 1.105
    #break
  #range (  3.275, 3.310) 
    #declare dwe = 1.105+(2*(clock-3.275))
    #break
  #range (  3.310, 4.000) 
    #declare dwe = 1.175
    #break
#end

#switch (clock) 
  #range (  0    , 0.700) 
    #declare dwa = 1.175
    #break
  #range (  0.700, 0.735) 
    #declare dwa = 1.175-(2*(clock-0.700))
    #break
  #range (  0.735, 0.965) 
    #declare dwa = 1.105
    #break
  #range (  0.965, 1.000) 
    #declare dwa = 1.105+(2*(clock-0.965))
    #break
  #range (  1.000, 1.700) 
    #declare dwa = 1.175
    #break
  #range (  1.700, 1.735)
    #declare dwa = 1.175-(2*(clock-1.700))
    #break
  #range (  1.735, 1.965)
    #declare dwa = 1.105
    #break
  #range (  1.965, 2.000) 
    #declare dwa = 1.105+(2*(clock-1.965))
    #break
  #range (  2.000, 2.700) 
    #declare dwa = 1.175
    #break
  #range (  2.700, 2.735) 
    #declare dwa = 1.175-(2*(clock-2.700))
    #break
  #range (  2.735, 2.965) 
    #declare dwa = 1.105
    #break
  #range (  2.965, 3.000) 
    #declare dwa = 1.105+(2*(clock-2.965))
    #break
  #range (  3.000, 3.700) 
    #declare dwa = 1.175
    #break
  #range (  3.700, 3.735) 
    #declare dwa = 1.175-(2*(clock-3.700))
    #break
  #range (  3.735, 3.965) 
    #declare dwa = 1.105
    #break
  #range (  3.965, 4.000) 
    #declare dwa = 1.105+(2*(clock-3.965))
    #break
#end

#declare seg_e = union {
 #declare Count = 0
  #while (Count < 20)
   object { subseg rotate <0,0,2.8+dwe> rotate <0,Count*18,0> translate <0,(0.015*Count)*dwe,0> }
  #declare Count = Count + 1 #end }

#declare feder_e = union {
  difference { object { seg_e }
               box { <-1.5,-1,-1.5>,<1.5,0.1,1.5> } translate <0,1*0.30*dwe,0> }
  #declare Count = 2
   #while (Count < 8)
    object { seg_e translate <0,Count*0.30*dwe,0> }
   #declare Count = Count + 1 #end
  difference { object { seg_e }
               box { <-1.5,0.25,-1.5>,<1.5,2,1.5> } translate <0,8*0.30*dwe,0> }
  rotate <0,0,-12> scale <0.1,0.1,0.1> }

#declare seg_a = union {
  #declare Count = 0
   #while (Count < 20)
    object { subseg rotate <0,0,2.8+dwa> rotate <0,Count*18,0> translate <0,Count*0.015*dwa,0> }
   #declare Count = Count + 1 #end }

#declare feder_a = union {
  difference { object { seg_a }
               box { <-1.5,-1,-1.5>,<1.5,0.1,1.5> } translate <0,1*0.30*dwa,0> }
  #declare Count = 2
   #while (Count < 8)
    object { seg_a translate <0,Count*0.30*dwa,0> }
   #declare Count = Count + 1 #end
  difference { object { seg_a }
               box { <-1.5,0.25,-1.5>,<1.5,2,1.5> } translate <0,8*0.30*dwa,0> }
  rotate <0,0, 12> scale <0.1,0.1,0.1> }

  object { feder_e translate < 0.21,2.3,0> }
  object { feder_a translate <-0.21,2.3,0> }

