
# Qt + TinySpline + POV-Ray Starter

Cross‑platform Qt Widgets app to edit a simple 2‑D spline, export a POV‑Ray include, and spawn POV‑Ray for quick previews.

## Features
- Qt Widgets UI with a canvas to add/move/delete control points (left‑click add, drag to move, Del to delete, right‑click to close/open curve).
- Uses **TinySpline** (C++ wrapper) if available to evaluate a cubic B‑spline; falls back to linear sampling if TinySpline is not found at configure time.
- Exports a POV‑Ray `lathe{}` (profile in x–y rotated around y) and optional `sphere_sweep{}` path include (`model_splines.inc`).
- Generates a minimal `driver.pov` and `quick.ini`; spawns **POV‑Ray** (`pvengine.exe /RENDER ... /EXIT` on Windows, `povray +I...` on Unix/macOS).

> References: POV‑Ray lathe/prism/sphere_sweep objects and CLI usage are documented in the official docs and manpages. See:
> - Lathe (spline‑based revolution) and Prism (swept curve) docs.>   https://www.povray.org/documentation/view/3.8.2/281/ , https://www.povray.org/documentation/view/3.6.0/282/
> - Sphere_sweep docs. https://www.povray.org/documentation/view/3.6.1/284/
> - Windows special CLI flags (/RENDER, /EXIT). https://www.povray.org/documentation/view/3.6.1/603/
> - Unix povray manpage. https://man.archlinux.org/man/extra/povray/povray.1.en
> - TinySpline library (MIT). https://github.com/msteinbeck/tinyspline

## Build (CMake + Qt 6/5)

```bash
# Linux/macOS
mkdir build && cd build
cmake -DCMAKE_BUILD_TYPE=Release       -DTINYSPLINE_REQUIRED=OFF       ..
cmake --build . --config Release

# Windows (from x64 Native Tools Prompt)
mkdir build && cd build
cmake -G "NMake Makefiles" -DCMAKE_BUILD_TYPE=Release ..
nmake
```

### TinySpline integration
- If TinySpline is installed system‑wide (CMake package `tinyspline`), the build will link to `tinysplinecxx::tinysplinecxx` (or `tinyspline::tinyspline`) automatically.
- Otherwise set `-DTINYSPLINE_REQUIRED=OFF` to allow a linear‑only fallback sampler.

### Run
1. Launch the app, add a few points (left‑click). Drag to move, press **Del** to remove, **C** to toggle closed.
2. **File → Export & Render…**: choose a folder, set the POV‑Ray binary path once (stored in a settings file), and render a quick preview.

### Notes
- Exported files:
  - `model_splines.inc` (array + lathe + optional sphere_sweep)
  - `driver.pov` (includes the above)
  - `quick.ini` (640×360 preview config)

- POV‑Ray primitives mapping:
  - Lathe expects 2‑D points in x–y, rotated about **y** (see docs).
  - Prism expects 2‑D points in x–z and sweeps along **y** (not used by default, but exporter shows how to write one).

## License
- This starter is provided under the MIT license (see `LICENSE`).
- TinySpline is MIT; you must install it separately if you enable it.
- POV‑Ray is AGPL‑3.0 licensed. You are **calling** the renderer, not redistributing it.
