
# SDL Name Indirection PoC — Git Branch Instructions

This PoC adds parse-time built-ins:

- `getvar("name")`
- `setvar("name", value)`
- `exists("name")`
- `undefvar("name")`

### Steps

```bash
git clone https://github.com/POV-Ray/povray.git
cd povray
git checkout -b feature/sdl-name-indirection
# Apply the patch
git apply ../name_indirection/PATCH_0001_name_indirection.diff
# Build (CMake example)
mkdir build && cd build
cmake .. -DCMAKE_BUILD_TYPE=Release
cmake --build . -j
```

### Demo

Render `name_indirection_demo.pov` with `#version 3.9`:

```bash
./build/povray +I../name_indirection/name_indirection_demo.pov +W320 +H240 +D +V
```

Expected console:
```
index_03 = 9
index_05 exists
index_05 exists after undef? 0
Q=<1,3>
```

