
# HOWTO: Apply and test the draft complex patches

## 1) Copy helper header

Place `src/base/complex.hpp` into your source tree at `source/base/complex.hpp` (or merge the content into an existing math header and adjust includes in the patch accordingly).

## 2) Apply patches (fuzz OK)

From the repo root of a recent POV-Ray checkout:

```bash
patch -p1 < patches/tokenizer_i_suffix.patch
patch -p1 < patches/parser_expressions.patch
```

If context fails, open the files and insert the `// [COMPLEX]` blocks manually.

## 3) Build

Build as usual for your platform (e.g., `unix` makefiles or Visual Studio solution). If you compile only the parser, make sure to touch the affected files.

## 4) Quick sanity test (SDL)

```pov
#declare Z1 = 2 + 3i;            // requires tokenizer suffix + parser support
#declare Z2 = complex(1, -2) + cis(pi/6);
#debug concat("Z1=", str(re(Z1),0,3), "+", str(im(Z1),0,3), "i\n")

// If your function VM isn't complex-aware yet, keep complex outside function{}
// or reduce to float with abs()/re()/im().
```

If you also extend the function VM, you can use `i` and complex inside `function{}` expressions.
