
# Complex Number Draft Patches for POV-Ray Parser

This zip contains **draft, minimally-invasive patches** that demonstrate how to:

1. Add complex-number awareness to `parser_expressions.cpp` (recognize an `IMAGINARY_LITERAL_TOKEN` and perform complex arithmetic dispatch), and
2. Implement an **`i` suffix** for numeric literals in the tokenizer so that `3i`, `2.5i`, `1e-3i`, etc., are scanned as *imaginary literals*.

> These patches are intentionally small and designed to apply with *fuzzy* offsets. They illustrate the changes; you will likely adapt names/locations to the exact upstream files and enums in your branch.

## Files

- `patches/parser_expressions.patch` — unified diff for `source/parser/parser_expressions.cpp`.
- `patches/tokenizer_i_suffix.patch` — unified diff for `source/parser/parser_tokenizer.cpp` and `source/parser/parser.h` (new token type).
- `src/base/complex.hpp` — a lightweight complex helper used by the parser.
- `HOWTO.md` — how to apply and test quickly.

## License
Public domain for the patch snippets in this archive.
