#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_
#include <iostream>
#include <stdexcept>
using std::ostream;

namespace geometry
{
    enum pointName {X,Y,Z};

    class point3d
    {
    public:
        point3d();
        point3d(const double &, const double &, const double &);
        ~point3d();

        double operator [](pointName) const;
        double &operator [](pointName);

        virtual bool operator ==(const point3d &);
        virtual bool operator !=(const point3d &);
        virtual point3d &operator =(const point3d &);
        point3d operator -();

        friend ostream &operator <<(ostream &, const point3d &);

    private:
        double coords[3];
    };

    // 3D geometric vector class extends point3d through inheritance.
    // Angles are measured in radians.
    // Reference frame is Right-Handed. (Z is up)
    class vector3d : public point3d
    {
    public:
        vector3d();
        vector3d(const point3d &, const point3d &);
        vector3d(const double, const double, const double);

        vector3d normalize() const;
        double dot(const vector3d &) const;
        vector3d cross(const vector3d &) const;

        double getMagnitude();
        double getPhi();
        double getTheta();
        point3d getUnitIntercept() const;
        point3d &getIntercept();
        bool updated();

        vector3d &operator =(const vector3d &);
        vector3d operator +(const vector3d &);
        vector3d operator -(const vector3d &);
        vector3d operator -();
        vector3d operator *(const double &);
        vector3d operator +=(const vector3d &);
        vector3d operator -=(const vector3d &);

        bool operator ==(const vector3d &);
        bool operator !=(const vector3d &);

    private:
        point3d reference;
        double mag, phi, theta;
        void recompute_spherical();
    };

    const point3d ORIGIN;         // default constructor returns (0,0,0)
    const vector3d ZERO_VECTOR;   // default constructor returns <0,0,0>
//    ostream &operator <<(ostream &os, const point3d &P)
//    {
//    os << "(" << P[X] << ", " << P[Y] << ", " << P[Z] << ")" << std::endl;

//    return os;
//    };
}

#endif
