
camera { orthographic location  <8, 5, -10> look_at <0, 0, 0> angle 22}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ---------------------------------------- 

#include "transforms.inc"
#declare TR=Shear_Trans(<-0.5,0.5,0.5>,<1.1,0,-0.3>,<-0.3,0.5,0>)
#declare TRFI = function {transform {TR inverse}}
                                                 
#declare A=TRFI(1,0,0);
#declare B=TRFI(0,1,0);
#declare C=TRFI(0,0,1);

#declare Ax=A.x;#declare Bx=B.x;#declare Cx=C.x;
#declare Ay=A.y;#declare By=B.y;#declare Cy=C.y;
#declare Az=A.z;#declare Bz=B.z;#declare Cz=C.z;

#declare F=function{max((y*y-1),(x*x-1),(z*z-1))}

isosurface {
  function { F(Ax*x+Bx*y+Cx*z, Ay*x+By*y+Cy*z, Az*x+Bz*y+Cz*z) }
        max_gradient 28
        contained_by{sphere{0,3}}
        pigment {rgb 1}
  translate -x*1.2
}

isosurface {
  function { F(x,y,z) }
        max_gradient 3.5
        contained_by{sphere{0,2}}
        pigment {rgb 1}
  transform {TR}
  translate x*1.2
}

