//StereoSphere

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 5.5}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}



#declare Fx = function(u,v){ 2*u/(u*u + v*v + 1) }
#declare Fy = function(u,v){ 2*v/(u*u + v*v + 1) }
#declare Fz = function(u,v){ -(u*u + v*v-1) / (u*u + v*v+1) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-4,-4>,<4,4>,60,60,"")
  pigment {uv_mapping checker rgb 1.1 rgb 0.75 scale 0.4}
  finish {phong 0.5 phong_size 10}
  no_shadow
  rotate -y*40
}
