


camera { location  <-4, 5, -10> look_at <0, 0, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 rgb <.3,.3,.8>] [1.0 color rgb 1] }
  }
}

light_source {<30,200,-30> colour rgb 1}
light_source {<-30,200,-100> colour rgb 0.5}
light_source {<0,20,-100> colour rgb 0.5}
                     
                     
#declare BurkhardtQuartic = function (x,y,z,a,b) {
   a*a*a*a - a*(x*x*x + y*y*y + z*z*z + b*b*b)
   + 3*x*y*z*b}
   
   
isosurface {
  function { BurkhardtQuartic(x,y,z,0.01,1.5) }
        max_gradient 12
        contained_by{box {-1.5,1.5}}      open
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
   