/* The Barth Sextic is the sextic equation with the highest
   possible number of ordinary double points (65) */


camera { location  <0, 0, -10> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 rgb <.3,.3,.8>] [1.0 color rgb 1] }
  }
}

light_source {<30,200,-30> colour rgb 1}
light_source {<-30,200,-100> colour rgb 0.5}
light_source {<0,20,-100> colour rgb 0.5}
                     
#declare GR=1.6180339887; // Golden ratio
#declare GR2=GR*GR;
                     
#declare BarthSextic=function(x,y,z,w) {
   4*(GR2*x*x - y*y)*(GR2*y*y - z*z)*(GR2*z*z - x*x)
   - (1+2*GR)*pow((x*x + y*y + z*z - w*w),2)*w*w }
   
isosurface {
  function { -BarthSextic(x,y,z,0.9) }
        max_gradient 105
        contained_by{sphere {0,1.55}}
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
   