/*
	Isosurface.inc
	by 
	Kevin Loney
	
	(adapted by Jaap Frank)
	
	Changes:
	1.	Changed if_statements to (.. ? .. : ..). Gain of about 10%.
	2.	Changed calls to 'math.inc' for triangle normals into functions.
			Total gain 22%.
	3.	Changed calls to interpolation macro into direct code.
			Total gain 27%.
	4.	The major change is in the calculation of the vertex 
			function values of the grid	cells.	In the original file 
			all vertices are calculated for every grid cell, but that
			means that the values for inside grid cells are calculated 
			eight times for the same X,Y,Z-point.
			I've changed this in two YZplane arrays and transfer the 
			data from the right YZplane to the left YZplane if 'X' is 
			increased with 'xstep'. Although the overhead is greater,
			there is a slight improvement in speed, but I think that 
			it will be considerable if the isofunctions become complicated.
			Total gain 37.5%.
*/

//Value Being Solved for
#ifndef(isoThreshold) 				#declare isoThreshold = 0;						#end
#ifndef(isoSmooth)						#declare isoSmooth = no;							#end
#ifndef(isoNormalAccuracy)		#declare isoNormalAccuracy = .00001;	#end

//Function Extents
#ifndef(isoMin)						#declare isoMin = -<1, 1, 1>;					#end
#ifndef(isoMax)						#declare isoMax = <1, 1, 1>;					#end

//Accuracy
#ifndef(isoSegs)					#declare isoSegs = <10, 10, 10>;			#end

//File to save in
#ifndef(isoFileOption)		#declare isoFileOption = 0;					#end		//0 = Load, 1 = Save, 2 = Ignore
#ifndef(isoFile)					#declare isoFile = "";							#end
#ifndef(isoName)					#declare isoName = "";							#end

//Function in Question

#ifndef(Fn)							#declare Fn = function(x,y,z) {x*x+y*y+z*z-1}	#end

//Compute function extents along each axis
#declare xmin = isoMin.x; #declare xmax = isoMax.x;
#declare ymin = isoMin.y; #declare ymax = isoMax.y;
#declare zmin = isoMin.z; #declare zmax = isoMax.z;

//Number of segments to break the mesh into along each axis
#declare xsegs = isoSegs.x;
#declare ysegs = isoSegs.y;
#declare zsegs = isoSegs.z;

//Size of each step
#declare xstep = (xmax - xmin) / xsegs;
#declare ystep = (ymax - ymin) / ysegs;
#declare zstep = (zmax - zmin) / zsegs;

#declare vertex = array[8]						//Vertex coordinates of each corners of the current grid cell
#declare value = array[8]							//The function values at each grid cell vertex coordinate
#declare triCount = 0;								//Total number of triangles in the mesh

#if(strlen(isoFile) & isoFileOption = 1)
	#declare saveIsoInFile = yes;
#else
	#declare saveIsoInFile = no;
#end

#declare Accuracy = abs(isoNormalAccuracy);
#declare GradX = function(XX,YY,ZZ){(Fn(XX+Accuracy,YY,ZZ)-Fn(XX-Accuracy,YY,ZZ))/(2*Accuracy)}
#declare GradY = function(XX,YY,ZZ){(Fn(XX,YY+Accuracy,ZZ)-Fn(XX,YY-Accuracy,ZZ))/(2*Accuracy)}
#declare GradZ = function(XX,YY,ZZ){(Fn(XX,YY,ZZ+Accuracy)-Fn(XX,YY,ZZ-Accuracy))/(2*Accuracy)}

#macro makeTri(a, b, c)
	#if(saveIsoInFile)
		#if(isoSmooth)
			#local AX = a.x;	#local BX = b.x;	#local CX = c.x;
			#local AY = a.y;	#local BY = b.y;	#local CY = c.y;
			#local AZ = a.z;	#local BZ = b.z;	#local CZ = c.z;
			#write(isoStream,
				"smooth_triangle{",a, ",<",GradX(AX,AY,AZ),",",GradY(AX,AY,AZ),",",GradZ(AX,AY,AZ),">, ",
													 b, ",<",GradX(BX,BY,BZ),",",GradY(BX,BY,BZ),",",GradZ(BX,BY,BZ),">, ",
													 c, ",<",GradX(CX,CY,CZ),",",GradY(CX,CY,CZ),",",GradZ(CX,CY,CZ),">}\n")
		#else
			#write(isoStream, "triangle{",a,",",b,",",c,"}\n")
		#end
	#else
		#if(isoSmooth)
			#local AX = a.x;	#local BX = b.x;	#local CX = c.x;
			#local AY = a.y;	#local BY = b.y;	#local CY = c.y;
			#local AZ = a.z;	#local BZ = b.z;	#local CZ = c.z;
			smooth_triangle {a, <GradX(AX,AY,AZ),GradY(AX,AY,AZ),GradZ(AX,AY,AZ)>,
											 b, <GradX(BX,BY,BZ),GradY(BX,BY,BZ),GradZ(BX,BY,BZ)>,
											 c, <GradX(CX,CY,CZ),GradY(CX,CY,CZ),GradZ(CX,CY,CZ)> }
		#else
			triangle {a, b, c}
		#end
	#end
#end

#macro polygonizeTetra(v0, v1, v2, v3)
	#local triIdx = 0;
	#local tri = array[3]
	
	#local triIdx = (value[v0]<0 ?triIdx+1 :triIdx);
	#local triIdx = (value[v1]<0 ?triIdx+2 :triIdx);
	#local triIdx = (value[v2]<0 ?triIdx+4 :triIdx);
	#local triIdx = (value[v3]<0 ?triIdx+8 :triIdx);
	
	#switch(triIdx)
		#case(1)
		#case(14)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			#local tri[2] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(2)
		#case(13)
			#local tri[0] = (vertex[v0]-vertex[v1])*((isoThreshold-value[v1])/(value[v0]-value[v1]))+vertex[v1];
			#local tri[1] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			#local tri[2] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(3)
		#case(12)
			#local tri[0] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			#local tri[2] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[0] = tri[2];
			#local tri[2] = tri[1];
			#local tri[1] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(4)
		#case(11)
			#local tri[0] = (vertex[v0]-vertex[v2])*((isoThreshold-value[v2])/(value[v0]-value[v2]))+vertex[v2];
			#local tri[1] = (vertex[v1]-vertex[v2])*((isoThreshold-value[v2])/(value[v1]-value[v2]))+vertex[v2];
			#local tri[2] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(5)
		#case(10)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			#local tri[2] = (vertex[v3]-vertex[v0])*((isoThreshold-value[v0])/(value[v3]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[2] = tri[1];
			#local tri[1] = (vertex[v2]-vertex[v1])*((isoThreshold-value[v1])/(value[v2]-value[v1]))+vertex[v1];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(6)
		#case(9)
			#local tri[0] = (vertex[v1]-vertex[v0])*((isoThreshold-value[v0])/(value[v1]-value[v0]))+vertex[v0];
			#local tri[1] = (vertex[v3]-vertex[v1])*((isoThreshold-value[v1])/(value[v3]-value[v1]))+vertex[v1];
			#local tri[2] = (vertex[v3]-vertex[v2])*((isoThreshold-value[v2])/(value[v3]-value[v2]))+vertex[v2];
			makeTri(tri[0], tri[1], tri[2])
			#local tri[1] = (vertex[v2]-vertex[v0])*((isoThreshold-value[v0])/(value[v2]-value[v0]))+vertex[v0];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(7)
		#case(8)
			#local tri[0] = (vertex[v2]-vertex[v3])*((isoThreshold-value[v3])/(value[v2]-value[v3]))+vertex[v3];
			#local tri[1] = (vertex[v0]-vertex[v3])*((isoThreshold-value[v3])/(value[v0]-value[v3]))+vertex[v3];
			#local tri[2] = (vertex[v1]-vertex[v3])*((isoThreshold-value[v3])/(value[v1]-value[v3]))+vertex[v3];
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
	#end
#end

#macro polygonizeCell()
	polygonizeTetra(0, 2, 3, 7)
	polygonizeTetra(0, 2, 6, 7)
	polygonizeTetra(0, 4, 6, 7)
	polygonizeTetra(0, 6, 1, 2)
	polygonizeTetra(0, 6, 1, 4)
	polygonizeTetra(5, 6, 1, 4)
#end

#macro makeCell()
	#declare value[0] = YZplaneLeft[NY][NZ];
	#declare value[1] = YZplaneRight[NY][NZ];
	#declare value[2] = YZplaneRight[NY][NZ+1];
	#declare value[3] = YZplaneLeft[NY][NZ+1];
	#declare value[4] = YZplaneLeft[NY+1][NZ];
	#declare value[5] = YZplaneRight[NY+1][NZ];
	#declare value[6] = YZplaneRight[NY+1][NZ+1];
	#declare value[7] = YZplaneLeft[NY+1][NZ+1];
	#local lessThan = 0; #local greaterThan = 0;
	#local i = 0;
	#while (i < 8)
		#local lessThan = (value[i]<0 ?lessThan+1 :lessThan);
		#local greaterThan = (value[i]>0 ?greaterThan+1 :greaterThan);
		#local i=i+1;
	#end
	#if(lessThan & greaterThan)polygonizeCell()#end
#end

#if(saveIsoInFile)
	#fopen isoStream isoFile write
	#if(strlen(isoName))
		#write(isoStream, "#declare ", isoName, " = ")
	#end
	#write(isoStream, "mesh{\n")
#end

//Prepare YZ-plane
#declare YZplaneLeft = array[ysegs+1][zsegs+1]			//Remember calculated points in YZ plane of left ...
#declare YZplaneRight = array[ysegs+1][zsegs+1]			//	... and of right side of cubes
#declare NXmax = xsegs;
#declare NYmax = ysegs;
#declare NZmax = zsegs;

#if(isoFileOption != 0)
	#debug "\n Start: Filling of Right YZ_plane_1 ...\n"
	#declare XX = xmin;
	#declare YY = ymin;
	#declare IY = 0;
	#while(IY <= NYmax)
		#declare ZZ = zmin;
		#declare IZ = 0;
		#while(IZ <= NZmax)
			#declare YZplaneRight[IY][IZ] = Fn(XX, YY, ZZ);
			#declare ZZ = ZZ + zstep;
			#declare IZ = IZ + 1;
		#end
		#declare YY = YY + ystep;
		#declare IY = IY + 1;
	#end	//Fill right side of cubes
	
	#if(isoFileOption = 2)
		mesh {
	#end
		#declare X = xmin;
		#declare NX = 0;
		#while(NX < NXmax)
		
			//Transfer Right YZ-plane to the left and fill right YZ-plane with new values
			#debug concat(" Transfering to Left YZ_plane_",str(NX,0,0)," and Filling of Right YZ_plane_",str(NX+1,0,0)," ...\n")
			#declare XX = X + xstep;
			#declare YY = ymin;
			#declare IY = 0;
			#while(IY <= NYmax)
				#declare ZZ = zmin;
				#declare IZ = 0;
				#while(IZ <= NZmax)
					#declare YZplaneLeft[IY][IZ] = YZplaneRight[IY][IZ];
					#declare YZplaneRight[IY][IZ] = Fn(XX, YY, ZZ);
					#declare ZZ = ZZ + zstep;
					#declare IZ = IZ + 1;
				#end
				#declare YY = YY + ystep;
				#declare IY = IY + 1;
			#end
			
			#debug " Calculating triangles ...\n"
			#declare Y = ymin;
			#declare NY = 0;
			#while(NY < NYmax)
				#declare Z = zmin;
				#declare NZ = 0;
				#while(NZ < NZmax)
					#declare vertex[0] = <X, Y, Z>;
					#declare vertex[1] = <X+xstep, Y, Z>;
					#declare vertex[2] = <X+xstep, Y, Z+zstep>;
					#declare vertex[3] = <X, Y, Z+zstep>;
					#declare vertex[4] = <X, Y+ystep, Z>;
					#declare vertex[5] = <X+xstep, Y+ystep, Z>;
					#declare vertex[6] = <X+xstep, Y+ystep, Z+zstep>;
					#declare vertex[7] = <X, Y+ystep, Z+zstep>;
	
					makeCell()
	
					#declare Z = Z + zstep;
					#declare NZ = NZ + 1;
				#end	//#while(NZ < NZmax)
				#declare Y = Y + ystep;
				#declare NY = NY + 1;
			#end	//#while(NY < NYmax)
			#declare X = X + xstep;
			#declare NX = NX + 1;
		#end	//#while(NX < NXmax)
	#if(isoFileOption = 2)
		}
	#end
#end

#if(saveIsoInFile)
	#write(isoStream, "}\n")
	#write(isoStream, "#declare triCount = ", triCount, ";")
	#fclose isoStream
#end

#if(isoFileOption != 2)
	#if(strlen(isoFile))
		#if(file_exists(isoFile))
			#include isoFile
		#end
	#end
#end

#debug concat("Triangle Count: ", str(triCount, 0, 0), "\n")