
camera { location  <4, 0, -5> look_at <0, 0.25, 0> angle 17}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.2}

// ----------------------------------------




#declare S = function {
   spline {
     natural_spline
      -1, < 0, 0.5, 0.0>,
    -0.5, < 0, 0.2, 0.4>,
    0.01, < 0, 0.2, 0.2>,
     0.5, < 0, 0.4, 0.4>,
       1, < 0, 0.0,-0.6>
   }
 }

#declare Hoop = function(x,y,z,r){y*y + z*z - r*r}

isosurface {
  function {Hoop(x, y-S(x).y, z-S(x).z, 0.223)}
        max_gradient 4
        contained_by{box{-1,1}}   open
        pigment {rgbt <1,1,1,0.2>}
        finish {phong 0.5 phong_size 10}
        no_shadow
}

#declare ctr = -1;
#while (ctr < 1)
  sphere {<ctr, S(ctr).y, S(ctr).z> ,.04  pigment { rgb <1,1,0> } no_shadow}
  #declare ctr = ctr + 0.01;
#end

