
camera { location  <4, 0, -5> look_at <0, 0.25, 0> angle 17}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.2}

// ----------------------------------------




#declare S = function {
   spline {
     natural_spline
      -1, < 0, 0.5, 0.0>,
    -0.5, < 0, 0.2, 0.4>,
    0.01, < 0, 0.2, 0.2>,
     0.5, < 0, 0.4, 0.4>,
       1, < 0, 0.0,-0.6>
   }
 }


isosurface {
  function { pow((y - S(x).y),2) + pow((z - S(x).z),2) - 0.05*(1+sin(x*30)*0.1) }
        max_gradient 4
        contained_by{box{-1,1}} open
        pigment {rgb <1,0.7,0.6>}
        finish {phong 0.4 phong_size 5}
}


