#include "functions.inc"

#declare R=2;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <0*R, 1*R, -4*R> look_at <0, 0, 0> angle 36}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------

isosurface {
  function { - f_hyperbolic_torus(x, y, z, 1, 0.6, 0.4)}
        max_gradient 100
        #if (Box=0)
           contained_by{sphere {0,R}}
        #else
          contained_by{box {<-R,-R,-0>,R}}
        #end
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
        rotate x*90
}
      
#if (Box=0)
  sphere {0,R1 pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-0.01>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
        