// Almost a lathe

#version 3.5;

camera { location  <2, 3, -5> look_at <-0.8, -0.15, 0> angle 28}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-500> colour rgb 1}

// One open 2D spline 
#declare S = function {
   spline {
     natural_spline
      -1, < 0.6, 0, 1.0>,
    -0.8, < 0.4, 0, 0.5>,
    -0.5, < 0.2, 0, 0.8>,
    -0.2, < 0.2, 0, 0.2>,
     0.3, < 0.8, 0, 0.7>,
     0.7, < 1.2, 0, 0.5>,
       1, < 1.2, 0, 0.2>
   }
 }

// Another open 2D spline
#declare S2 = function {
   spline {
     natural_spline
      -1, < 0.3, 0, 0.3>,
    -0.8, < 0.4, 0, 0.2>,
    -0.5, < 0.1, 0, 0.6>,
    -0.2, < 0.4, 0, 0.4>,
     0.3, < 0.1, 0, 0.6>,
     0.7, < 0.4, 0, 0.4>,
       1, < 0.4, 0, 0.7>
   }
 }

#declare Fx  = function(x,y) {(S(u).x*-(v<=pi) + S2(u).x*-(v>pi)) * sin(v)/2}
#declare Fy  = function(x,y) {u}
#declare Fz  = function(x,y) {(S(u).z*(cos(v)<=0) + S2(u).z*(cos(v)>0)) * cos(v)/2}


#include "param.inc"

#declare Thing =
object {Parametric(Fx,Fy,Fz,<-1,0>,<1,pi*2>,40,40,"")
        texture {
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10 ambient 0.2}
        }
}

object {Thing}
object {Thing translate <-1,0,-0.5>}


#declare I=-1;
#while (I<1)
  sphere {<-S(I).x/2,I,0>,0.02 pigment {rgb 1}}
  sphere {<S2(I).x/2,I,0>,0.02 pigment {rgb 1}}
  sphere {<0,I,-S(I).z/2>,0.02 pigment {rgb 1}}
  sphere {<0,I,S2(I).z/2>,0.02 pigment {rgb 1}}
  #declare I=I+0.003;
#end