
camera { location  <0, 0, -2.2> look_at <0, 0, 0>}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare r_1 = function(u,v){max(abs(sin(4*u)),0.9-0.2*abs(cos(8*u)))}
#declare r_2 = function(u,v){cos(v)*cos(v)}

#declare R = function(u,v){
    abs(sin(4*u))
    *cos(v)*cos(v)
}



#declare Fx= function(u,v){R(u,v)*cos(u)*cos(v)}
#declare Fy= function(u,v){R(u,v)*sin(u)*cos(v)}
#declare Fz= function(u,v){R(u,v)*sin(v)}

#include "param.inc"

object{
    Parametric(
       Fx, Fy, Fz,
       <FromU(0),FromV(0)>,<ToU(pi),ToV(2*pi)>,
       150,70,""
    )
  pigment {rgb 1}
  finish {phong 0.5 phong_size 10}
}
