/* ============================
 NACA 4-digit aerofoil section
 
 This scene draws NACA Airfoil section NC5415
 i.e M=5        (max camber is 2% of chord)
     P=4        (max thickness is 40% back from leading edge)
     T=15       (max thickness is 15% of chord)
*/ 



camera { location  <-10, 4, -10> look_at <0.5, 0, 0.5> angle 6}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}

// ----------------------------------------

#declare M = 0.05; // max camber: first digit * 0.01
#declare P = 0.4;  // position of max thickness: second digit * 0.1
#declare T = 0.15; // max thickness: last 2 digits * 0.01

#declare Yc1 = function(x){M/(P*P)*(2*P*x-x*x)}
#declare Yc2 = function(x){M/(1-P)/(1-P)*((1-2*P)+2*P*x-x*x)}
#declare Yt = function(x){(T/0.2)*(0.2969*pow(x,0.5) - 0.1260*x -0.3516*x*x + 0.2843*x*x*x -0.1015*x*x*x*x)}


#declare Fy1 = function(u,v){Yt(u) + select(u-P, Yc1(u), Yc2(u)) }
#declare Fy2 = function(u,v){-Yt(u) + select(u-P, Yc1(u), Yc2(u)) }
#declare Fx = function(u,v) {u}
#declare Fz = function(u,v) {v}

#include "param.inc"

object {Parametric(Fx,Fy1,Fz,<0,0>,<1.01,1>,100,2,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
}
      
object {Parametric(Fx,Fy2,Fz,<0,0>,<1.01,1>,100,2,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
}
