#declare R=1.1;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------


#declare Fx = function {u*v*sin(15*v)}
#declare Fy = function {v}
#declare Fz = function {u*v*cos(15*v)}
#declare Fp = function {pigment {granite scale 0.1}}


parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0) + Fp(u,v,0).grey*0.2}
  function {Fz(u,v,0)}
      <0,-1>,<1,1>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
