#declare R=1.1;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------


#declare Fp = function {pattern {granite scale 0.1}}

#declare Fx = function(u,v){u*v*sin(15*v)}
#declare Fy = function(u,v){v + Fp(u*0.1,v,0)*0.3}
#declare Fz = function(u,v){u*v*cos(15*v)}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-1>,<1,1>,50,200,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
